# -*- coding: utf-8 -*-

"""
/***************************************************************************
 emiTools
                                 A QGIS plugin
 This plugin compiles tools used by EMI-PB
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-10-10
        copyright            : (C) 2024 by Alexandre Parente Lima
        email                : alexandre.parente@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Alexandre Parente Lima'
__date__ = '2024-10-10'
__copyright__ = '(C) 2024 by Alexandre Parente Lima'

# This will get replaced with a git SHA1 when you do a git archive

from qgis.core import QgsProcessingProvider
from .emi_tools_export_terms import emiToolsExportTerms
from .emi_tools_export_kml_rpa import emiToolsExportKmlRpa
from .emi_tools_imagem_stamp_rpa import emiToolsStampImagemRpa
from .emi_tools_import_geotagged_photos import emiToolsImportGeotaggedPhotos
from .emi_tools_apply_style_geotagged_photos import emiToolsApplyStyleGeotaggedPhotos
#from .emi_tools_join_geotagged_photos_features import AssociarFotosPoligonos
#from .emi_tools_photographic_report import emiToolsPhotographicReport


class emiToolsProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(emiToolsExportTerms())
        self.addAlgorithm(emiToolsExportKmlRpa())        
        self.addAlgorithm(emiToolsStampImagemRpa())
        self.addAlgorithm(emiToolsImportGeotaggedPhotos())
        self.addAlgorithm(emiToolsApplyStyleGeotaggedPhotos())
        # self.addAlgorithm(AssociarFotosPoligonos())
        # self.addAlgorithm(emiToolsPhotographicReport())

    # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'emiTools'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('Emi Tools')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QgsProcessingProvider.icon(self)

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()