# -*- coding: utf-8 -*-

"""
/***************************************************************************
 emiTools
                                 A QGIS plugin
 This plugin compiles tools used by EMI-PB
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-10-10
        copyright            : (C) 2024 by Alexandre Parente Lima
        email                : alexandre.parente@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Alexandre Parente Lima'
__date__ = '2024-10-10'
__copyright__ = '(C) 2024 by Alexandre Parente Lima'



from qgis.core import (
    QgsProcessing,
    QgsProcessingAlgorithm,
    QgsProcessingParameterFeatureSource,
    QgsProcessingParameterField,
    QgsProcessingParameterFeatureSink,
    QgsProcessingParameterVectorLayer,
    QgsProcessingParameterVectorDestination,
    QgsProcessingParameterNumber,
    QgsFeature,
    QgsFeatureSink,
    QgsWkbTypes,
    QgsField,
    QgsFields,
    QgsPointXY,
    QgsGeometry,
    edit
)
from qgis.PyQt.QtCore import QVariant
import math


class AssociarFotosPoligonos(QgsProcessingAlgorithm):
    PARAM_CAMADA_PONTOS = 'CAMADA_PONTOS'
    PARAM_CAMADA_POLIGONOS = 'CAMADA_POLIGONOS'
    PARAM_TOLERANCIA = 'TOLERANCIA'
    PARAM_DIST_MAX = 'DIST_MAX'
    PARAM_SAIDA = 'SAIDA'

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterFeatureSource(
            self.PARAM_CAMADA_PONTOS,
            'Camada de pontos (fotos)',
            [QgsProcessing.TypeVectorPoint]
        ))
        self.addParameter(QgsProcessingParameterFeatureSource(
            self.PARAM_CAMADA_POLIGONOS,
            'Camada de polígonos',
            [QgsProcessing.TypeVectorPolygon]
        ))
        self.addParameter(QgsProcessingParameterNumber(
            self.PARAM_TOLERANCIA,
            'Tolerância angular (graus)',
            QgsProcessingParameterNumber.Double,
            defaultValue=30,
            minValue=0,
            maxValue=180
        ))
        self.addParameter(QgsProcessingParameterNumber(
            self.PARAM_DIST_MAX,
            'Distância máxima (opcional, deixe 0 para ignorar)',
            QgsProcessingParameterNumber.Double,
            defaultValue=0,
            minValue=0
        ))
        self.addParameter(QgsProcessingParameterVectorDestination(
            self.PARAM_SAIDA,
            'Camada de saída com associação ao polígono'
        ))


    def calcular_azimute(self, ponto, centroide):
        dx = centroide.x() - ponto.x()
        dy = centroide.y() - ponto.y()
        azimute_rad = math.atan2(dx, dy)
        azimute_deg = math.degrees(azimute_rad)
        return (azimute_deg + 360) % 360

    def diff_angular(self, a1, a2):
        diff = abs(a1 - a2) % 360
        return min(diff, 360 - diff)

    def processAlgorithm(self, parameters, context, feedback):
        camada_pontos = self.parameterAsSource(parameters, self.PARAM_CAMADA_PONTOS, context)
        camada_poligonos = self.parameterAsSource(parameters, self.PARAM_CAMADA_POLIGONOS, context)
        tolerancia = self.parameterAsDouble(parameters, self.PARAM_TOLERANCIA, context)
        dist_max = self.parameterAsDouble(parameters, self.PARAM_DIST_MAX, context)

        campos = camada_pontos.fields()
        campos.append(QgsField('id_poligono', QVariant.String))

        (sink, dest_id) = self.parameterAsSink(parameters, self.PARAM_SAIDA, context, campos, camada_pontos.wkbType(),
                                               camada_pontos.sourceCrs())

        poligonos = list(camada_poligonos.getFeatures())

        for f in camada_pontos.getFeatures():
            nova_feat = QgsFeature(campos)
            nova_feat.setGeometry(f.geometry())
            nova_feat.setAttributes(f.attributes() + [None])

            geom_ponto = f.geometry()
            if geom_ponto.isEmpty():
                sink.addFeature(nova_feat, QgsFeatureSink.FastInsert)
                continue

            ponto = geom_ponto.asPoint()
            az_foto = f['rotation']

            candidatos = []
            for pol in poligonos:
                centroide = pol.geometry().centroid().asPoint()
                az_centroide = self.calcular_azimute(ponto, centroide)
                angulo = self.diff_angular(az_foto, az_centroide)
                if angulo <= (tolerancia / 2):
                    distancia = QgsGeometry.fromPointXY(ponto).distance(QgsGeometry.fromPointXY(centroide))
                    if dist_max == 0 or distancia <= dist_max:
                        candidatos.append((distancia, pol))

            if candidatos:
                candidatos.sort(key=lambda x: x[0])
                pol_mais_prox = candidatos[0][1]
                nova_feat.setAttribute(len(f.attributes()), str(pol_mais_prox.id()))

            sink.addFeature(nova_feat, QgsFeatureSink.FastInsert)

        return {self.PARAM_SAIDA: dest_id}


    def name(self):
        return 'associar_fotos_a_poligonos'

    def displayName(self):
        return 'Join geolocated photos to features'
    #Associar fotos geolocalizadas a feições

    def group(self):
        return tr("Emi Tools")

    def groupId(self):
        return ""

    def createInstance(self):
        return AssociarFotosPoligonos()
