# -*- coding: utf-8 -*-
"""
/***************************************************************************
 embedded_svg
                                 A QGIS plugin
 embedding SVG into Projectfiles
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-01-09
        git sha              : $Format:%H$
        copyright            : (C) 2020 by d.b.g. Datenbankgesellschaft
        email                : info@datenbankgesellschaft.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from qgis.core import QgsProject, QgsSymbolLayerUtils, QgsMessageLog

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
# from .svg_embedder_dialog import embedded_svgDialog
import os.path
from xml.etree import ElementTree as ET
import base64
import json
import os
import tempfile
from os.path import basename
from zipfile import ZipFile

class embedded_svg:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'embedded_svg_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&SVG Embeddor')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('embedded_svg', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/svg_embedder/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'embedding SVG'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&SVG Embeddor'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""
        # project folder
        qgz_path = QgsProject.instance().fileName()

        filename = QFileDialog.getSaveFileName(QFileDialog(), "Save Folder", qgz_path, 'QGZ files (*.qgz)')
        # temporary folder
        temp_path = tempfile.gettempdir()
        QgsMessageLog.logMessage("Start", 'embedded SVG', 0)
        try:
            # extraction of qgs file
            with ZipFile(qgz_path, "r") as in_qgz:
                for f in in_qgz.infolist():
                    if f.filename.endswith('.qgs'):
                        in_qgz.extract(f.filename, temp_path)
                        datafile = temp_path + "\\" + f.filename

            with open(datafile, 'r') as f:
                tree = ET.parse(datafile)
                root = tree.getroot()

                # search for layers
                for symbol in root.iter("layer-tree-layer"):
                    sym_att = symbol.attrib
                    text = json.dumps(str(sym_att), ensure_ascii=False).encode('utf-8')
                    try:

                        if b".shp" not in text:
                            continue

                        else:

                            test = text.decode().split("'")
                            matching = [s for s in test if ".shp" in s]
                            layer_paths = [layer.source() for layer in QgsProject.instance().mapLayers().values()]

                            for layer in layer_paths:
                                test = matching[0].split("/")

                                if test[-1] in layer:
                                    symbol.set("source", layer)

                                for symbol2 in root.iter("datasource"):

                                    if test[-1] in symbol2.text and test[-1] in layer:
                                        symbol2.text = layer

                    except Exception as e:
                        QgsMessageLog.logMessage(" search fail: " + str(e), 'embedded SVG', 0)



                # search for svg filenames
                for symbol in root.iter("prop"):
                    sym_att = symbol.attrib
                    text = json.dumps(str(sym_att), ensure_ascii=False).encode('utf-8')

                    try:
                        if b".svg" not in text:

                            continue
                        else:

                            test = text.decode().split("'")
                            matching = [s for s in test if ".svg" in s]

                            # SVG Ordner des Alkis Plugins
                            svg_folder = QgsSymbolLayerUtils.listSvgFiles()

                            # search for svg name in svg folder
                            for svg_pic in svg_folder:

                                if matching[0] in svg_pic:

                                    image = open(svg_pic, 'r')

                            # encode svg file to base64 and write into qgs
                            image_read = str(image.read())
                            image_64_encode = base64.b64encode(image_read.encode("utf-8"))
                            image_64_encode_str = str(image_64_encode, "utf-8")
                            encoded_svg = "base64:" + image_64_encode_str
                            symbol.set("v", encoded_svg)
                    except Exception as e:
                        QgsMessageLog.logMessage(" search fail: " + str(e), 'embedded SVG', 0)

            tree.write(datafile)
            file_paths = []
            # new zipfile for new qgs file
            with ZipFile(filename[0][:-4] + ".qgz", 'w') as zip:

            # with ZipFile(qgz_path[:-4] + "_svg_embedded.qgz", 'w') as zip:
                zip.write(datafile, basename(datafile))

            os.remove(datafile)

            QgsMessageLog.logMessage("Finish", 'embedded SVG', 0)
        except Exception as e:
            QgsMessageLog.logMessage(" search fail: " + str(e), 'embedded SVG', 0)