# -*- coding: utf-8 -*-
"""
/***************************************************************************
 EllipsisConnectDialog
                                 A QGIS plugin
 Connect to Ellipsis Drive
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-06-24
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Ellipsis Drive
        email                : floydremmerswaal@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal
from qgis.PyQt.QtWidgets import QDockWidget

from .connect.util import *
from .connect.MyDrive import MyDriveTab

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'ellipsis_drive_dialog_base.ui'))

class EllipsisConnectDialog(QDockWidget, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(EllipsisConnectDialog, self).__init__(parent)
        self.mydrivetab = MyDriveTab()
        self.communitytab = CommunityTab()
        self.mydrivetab.loginSignal.connect(self.handleLoginSignal)
        self.mydrivetab.logoutSignal.connect(self.handleLogoutSignal)
        self.setupUi(self)
        self.tabWidget.addTab(self.mydrivetab, "My Drive")
        self.tabWidget.addTab(self.communitytab, "Community Library")
    
    def handleLoginSignal(self, token):
        self.communitytab.loginToken = token
        self.communitytab.getCommunityList()
    
    def handleLogoutSignal(self):
        self.communitytab.loginToken = ""
        self.communitytab.getCommunityList()