# -*- coding: utf-8 -*-
"""
/***************************************************************************
 dtcloudDialog
                                 A QGIS plugin
 egiscloud
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-07-12
        git sha              : $Format:%H$
        copyright            : (C) 2022 by egis
        email                : iyeti@egiskorea.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import json
import socket
import requests
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from PyQt5.QtCore import *
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *
from qgis.PyQt.QtCore import QThread, pyqtSignal
from qgis.utils import iface
from qgis.core import (
  QgsLayerTreeLayer,
  QgsApplication,
  QgsDataSourceUri,
  QgsCategorizedSymbolRenderer,
  QgsClassificationRange,
  QgsPointXY,
  QgsProject,
  QgsExpression,
  QgsField,
  QgsFields,
  QgsFeature,
  QgsFeatureRequest,
  QgsFeatureRenderer,
  QgsGeometry,
  QgsGraduatedSymbolRenderer,
  QgsMarkerSymbol,
  QgsMapLayerType,
  QgsMessageLog,
  QgsProcessing,
  QgsRectangle,
  QgsRendererCategory,
  QgsRendererRange,
  QgsSettings,
  QgsSymbol,
  QgsVectorLayer,
  QgsRasterLayer,
  QgsVectorFileWriter,
  QgsWkbTypes,
  QgsSpatialIndex,
  QgsVectorLayerUtils,
  QgsVectorDataProvider,
  QgsProcessingUtils,
  QgsCoordinateReferenceSystem,
  QgsBilinearRasterResampler
)
import zipfile
import json,urllib.request
# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'dtcloud_dialog_base.ui'))

    
class dtcloudDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(dtcloudDialog, self).__init__(parent)
        self.setupUi(self)

        self.model = QStandardItemModel()
        self.model.clear()
        self.mode = 0
        self.pushButton.clicked.connect(self.button1Click)
        self.pushButton_2.clicked.connect(self.button2Click)
        self.pushButton_3.clicked.connect(self.button3Click)
        self.pushButton_4.clicked.connect(self.button4Click)
        self.pushButton_7.clicked.connect(self.button7Click)
        self.pushButton_8.clicked.connect(self.button8Click)

        self.pushButton_10.clicked.connect(self.button10Click)    #주제도
        self.pushButton_11.clicked.connect(self.button11Click)
        self.pushButton_13.clicked.connect(self.button13Click)
        self.pushButton_14.clicked.connect(self.button14Click)
        self.pushButton_15.clicked.connect(self.button15Click)
        self.checkBox.stateChanged.connect(self.stateChanged)
        ip = socket.gethostbyname(socket.gethostname())
        if ip == "127.0.0.1":
            QtWidgets.QMessageBox.information(self, "알림", "인터넷 연결이 필요합니다.")
        key = QgsSettings().value("dtcloud/key", "test")
        data = urllib.request.urlopen("https://www.egiscloud.com/plugin/getLayerInfo.do?apiKey="+key).read()
        print(data)
        self.jsonObject = json.loads(data)
        self.url = self.jsonObject['url']
        if self.jsonObject['status'] == "200":
            self.jsonObject = self.jsonObject['layers']
            self.lineEdit.setText(key)
        elif self.jsonObject['status'] == "202":
            QtWidgets.QMessageBox.information(self, "알림", "사용자 키(KEY)를 입력해 주세요. \n키가 없는 사용자는 'www.egiscloud.com'에서 키를 발급 받으실 수 있습니다.")
        else:
            print(self.jsonObject['status'], self.jsonObject['message'])

        #self.button10Click()
        self.pushButton_10.setVisible(False)
    def showList(self):
        self.model.clear()        
        for layer in self.jsonObject:
            item = QStandardItem(layer['DATA_NAME'])
            item.setCheckable(True)
            if len(item.text()) > 0:
                self.model.appendRow(item)
        self.listView.setModel(self.model)
    #오픈랩활용갤러리
    def button1Click(self):
        url1 = QUrl('https://www.egiscloud.com')
        QDesktopServices.openUrl(url1)

    #레이어추가하기
    def button2Click(self):
        i = 0
        isEmpty = True
        if self.mode == 2:
            print('공개레이어')
            layerlist = []
            while self.model.item(i):
                if self.model.item(i).checkState():
                    shpname = self.model.item(i).text().split('(')
                    shpname1 = shpname[1].split(',')[0]
                    epsg = shpname[1].split(',')[1].split(')')[0]
                    layername = self.model.item(i).text()
                    uri = QgsDataSourceUri()
#                    if 'cbnd' in shpname1:
#                        urlWithParams = 'url=https://openlab-2d.eseoul.go.kr/smap_theme/wms?version=1.1.0&format=image/png&styles=&crs='+epsg+'&layers='+shpname1
#                        layer = QgsRasterLayer(urlWithParams, shpname[0], 'wms')
#                    else:
                    uri.setParam('version', '2.0.0')
                    uri.setParam('typename', 'smap_theme:'+shpname1)
                    uri.setParam('url', 'https://openlab-2d.eseoul.go.kr/smap_theme/wfs')
                    layer = QgsVectorLayer(uri.uri(), shpname[0], 'wfs')
                    if not layer.isValid():
                        print("Layer failed to load!", layername, shpname)
                    else:
                        if(layer.featureCount()>100000):
                            print(layer.name()+": 객체가 10만개가 이상인 레이어는 WMS로 제공됩니다.")
                            #QtWidgets.QMessageBox.information(self, "알림", "객체가 10만개가 이상인 레이어는 WMS로 제공됩니다.")
                            urlWithParams = 'url=https://openlab-2d.eseoul.go.kr/smap_theme/wms?version=1.1.0&format=image/png&styles=&crs='+epsg+'&layers='+shpname1
                            layer = QgsRasterLayer(urlWithParams, shpname[0], 'wms')
                    layerlist.append(layer)
                i += 1

            for k in range(len(layerlist)):
                QgsProject.instance().addMapLayer(layerlist[k], True)
                isEmpty = False
            self.close()

        elif self.mode == 0:
            print('사용자레이어')
            layerlist = []
            while self.model.item(i):
                if self.model.item(i).checkState():
                    shpname = self.model.item(i).text()
                    layername = self.model.item(i).text()
                    for layer in reversed(self.jsonObject):
                        if layer['DATA_NAME'] == shpname:
                            shpname = layer['SHP_TABLE_NAME']
                    urlWithParams = 'url='+self.url+'version=1.1.0&format=image/png&layers='+shpname+'&styles=&crs=EPSG:4326'
                    print(shpname, urlWithParams)
                    rlayer = QgsRasterLayer(urlWithParams, layername, 'wms')
                    if not rlayer.isValid():
                        print("Layer failed to load!", layername, shpname)
                    else:
                        layerlist.append(rlayer)
                i += 1

            for k in range(len(layerlist)):
                QgsProject.instance().addMapLayer(layerlist[k], True)
                isEmpty = False
            self.close()

        elif self.mode == 1:
            layerlist = []
            temp_folder = QgsProcessingUtils.tempFolder();
            os.chdir(temp_folder)
            if os.path.exists(temp_folder+"/"+self.lineEdit.text()+".zip"):
                os.remove(temp_folder+"/"+self.lineEdit.text()+".zip")
            while self.model.item(i):
                if self.model.item(i).checkState():
                    layername = self.model.item(i).text()
                    for layer in QgsProject.instance().mapLayers().values():
                        if isinstance(layer, QgsVectorLayer):
                            if layer.name() == layername:
                                layerlist.append(layer)
                                tpath = temp_folder+"/"+layer.name()+".shp"
                                QgsVectorFileWriter.writeAsVectorFormat(layer, tpath, "EUC-KR", layer.crs(), "ESRI Shapefile")
                i += 1
            crs = ""
            zip_path = temp_folder+"/"+self.lineEdit.text()+".zip"
            zip_file = zipfile.ZipFile(zip_path, "w")
            for file in os.listdir(temp_folder):
                if file.endswith('.shp') or file.endswith('.SHP'):
                    for l in layerlist:
                        if file == l.name() + ".shp" or file == l.name() + ".SHP":
                            zip_file.write(file, compress_type=zipfile.ZIP_DEFLATED)
                            crs = l.crs().authid()
                if file.endswith('.dbf') or file.endswith('.DBF'):
                    for l in layerlist:
                        if file == l.name() + ".dbf" or file == l.name() + ".DBF":
                            zip_file.write(file, compress_type=zipfile.ZIP_DEFLATED)
                if file.endswith('.shx') or file.endswith('.SHX'):
                    for l in layerlist:
                        if file == l.name() + ".shx" or file == l.name() + ".SHX":
                            zip_file.write(file, compress_type=zipfile.ZIP_DEFLATED)
                if file.endswith('.cpg') or file.endswith('.CPG'):
                    for l in layerlist:
                        if file == l.name() + ".cpg" or file == l.name() + ".CPG":
                            zip_file.write(file, compress_type=zipfile.ZIP_DEFLATED)
                if file.endswith('.prj') or file.endswith('.PRJ'):
                    for l in layerlist:
                        if file == l.name() + ".prj" or file == l.name() + ".PRJ":
                            zip_file.write(file, compress_type=zipfile.ZIP_DEFLATED)
            zip_file.close();

            if crs.startswith("EPSG"):
                url = "https://www.egiscloud.com/plugin/uploadShpFiles.do"
                files = open(zip_path, 'rb')
                upload = {'file':files}
                obj = {"key":self.lineEdit.text(), "crs:":crs}
                res = requests.post(url, files=upload, data=obj)
                files.close()
                isEmpty = False
#                print(res)
        elif self.mode == 4:
            isEmpty = True
            i = 0
            while self.model.item(i):
                print(self.model.item(i).text())
                if self.model.item(i).checkState():
                    layername = self.model.item(i).text()
                    for layer in QgsProject.instance().mapLayers().values():
                        if isinstance(layer, QgsVectorLayer):                            
                            if layer.name() == layername:
                                isEmpty = False
                                self.ulayer = layer
                                self.upload_layer()
                i += 1

        if isEmpty:                
            QtWidgets.QMessageBox.information(self, "Infomation", "선택된 레이어가 없거나 오류가 있습니다.")


    #사용자레이어 가져오기
    def button3Click(self):
        self.pushButton_2.setText("선택된 레이어 추가하기")
        self.checkBox.setCheckState(0)
        if self.mode == 1:
            self.button7Click()
        self.mode = 0
        key = self.lineEdit.text()
        data = urllib.request.urlopen("https://www.egiscloud.com/plugin/getLayerInfo.do?apiKey="+key).read()
        self.jsonObject = json.loads(data);
        self.url = self.jsonObject['url']
        if self.jsonObject['status'] == "200":
            self.jsonObject = self.jsonObject['layers']
            self.lineEdit.setText(key)
            self.showList()
            QgsSettings().setValue("dtcloud/key", key)
        elif self.jsonObject['status'] == "202":
            QtWidgets.QMessageBox.information(self, "알림", "사용자 키(KEY)를 입력해 주세요. \n키가 없는 사용자는 '오픈랩 누리집'에서 키를 발급 받으실 수 있습니다.")
        else:
            self.model.clear()

    #모드변환(다운로드/업로드)
    def button7Click(self):
        if self.mode == 0:
            self.model.clear()
            for layer in QgsProject.instance().mapLayers().values():
                if isinstance(layer, QgsVectorLayer):
                    if len(layer.name()) > 0:
                        item = QStandardItem(layer.name())
                        item.setCheckable(True)
                        item.setCheckState(0)
                        self.model.appendRow(item)
            self.mode = 1
        else:
            self.showList()
    #배경1
    def button8Click(self):
        layers = QgsProject.instance().mapLayers()
        layerExist = False
        for layer in layers.values():
            print(layer.name())
            if layer.name() == "seoul_2020":
                QtWidgets.QMessageBox.information(self, "알림", "이미 레이어가 추가되었습니다.")
                layerExist = True
                break

        if layerExist == False:
            #urlWithParams = 'type=xyz&url=http://49.247.33.82/2020/%7Bz%7D/%7Bx%7D/%7By%7D.jpg&zmax=20&zmin=0'
            rlayer = QgsRasterLayer("type=xyz&url=https://xdworld.vworld.kr/2d/Satellite/service/{z}/{x}/{y}.jpeg","vworld_satellite", "wms")
            #QgsProject.instance().addMapLayer(rlayer)
            #rlayer = QgsRasterLayer(urlWithParams, 'seoul_2020', 'wms')  
            resampleFilter = rlayer.resampleFilter()
            resampleFilter.setZoomedInResampler(QgsBilinearRasterResampler())
            resampleFilter.setZoomedOutResampler(QgsBilinearRasterResampler())
            QgsProject.instance().addMapLayer(rlayer)

    #공개레이어
    def button10Click(self):
        self.pushButton_2.setText("선택된 레이어 추가하기")
        self.checkBox.setCheckState(0)
        self.mode = 2
        data = urllib.request.urlopen("https://openlab.eseoul.go.kr/plugin/themeMapList.do").read()
        self.model.clear()
        self.jsonObject = json.loads(data)
        if self.jsonObject['status'] == "200":
            layers = self.jsonObject['layers']
            self.url = self.jsonObject['url']    
            for layer in layers:
                item = QStandardItem(""+layer['DATA_NAME']+"("+layer['SHP_TABLE_NAME']+","+layer['COORD_EPSG']+")")
                item.setCheckable(True)
                self.model.appendRow(item)
        self.listView.setModel(self.model)
    
    #업로드레이어가져오기
    def button4Click(self):
        self.pushButton_2.setText("선택된 레이어 업로드하기")
        self.mode = 4
        self.model.clear()
        layers = QgsProject.instance().mapLayers()

        for layer in layers.values():
            if layer.type() == QgsMapLayerType.VectorLayer:
                if layer.dataProvider().name() == "ogr":
                    item = QStandardItem(layer.name())
                    item.setCheckable(True)
                    self.model.appendRow(item)
                    print(layer)
        self.listView.setModel(self.model)

    #브이월드배경
    def button11Click(self):
        QtWidgets.QMessageBox.information(self, "테스트", "브이월드배경(위성)을 가져옵니다.")
        rlayer = QgsRasterLayer("type=xyz&url=https://xdworld.vworld.kr/2d/Satellite/service/{z}/{x}/{y}.jpeg","vworld_satellite", "wms")
        QgsProject.instance().addMapLayer(rlayer, True)
    def button13Click(self):
        QtWidgets.QMessageBox.information(self, "테스트", "브이월드배경(스트리트맵)을 가져옵니다.")
        rlayer = QgsRasterLayer("type=xyz&url=https://xdworld.vworld.kr/2d/Base/service/{z}/{x}/{y}.png","vworld_street", "wms")
        QgsProject.instance().addMapLayer(rlayer, True)
    def button14Click(self):
        QtWidgets.QMessageBox.information(self, "테스트", "브이월드배경(하이브리드)을 가져옵니다.")
        rlayer = QgsRasterLayer("type=xyz&url=https://xdworld.vworld.kr/2d/Base/service/{z}/{x}/{y}.png","vworld_street", "wms")
        QgsProject.instance().addMapLayer(rlayer, True)
        rlayer = QgsRasterLayer("type=xyz&url=https://xdworld.vworld.kr/2d/Hybrid/service/{z}/{x}/{y}.png","vworld_hybrid", "wms")
        QgsProject.instance().addMapLayer(rlayer, True)
    def button15Click(self):
        QtWidgets.QMessageBox.information(self, "테스트", "브이월드배경(회색)을 가져옵니다.")
        rlayer = QgsRasterLayer("type=xyz&url=https://xdworld.vworld.kr/2d/gray/service/{z}/{x}/{y}.png","vworld_gray", "wms")
        QgsProject.instance().addMapLayer(rlayer, True)
    def stateChanged(self):
        i = 0
        j = 0
        if self.checkBox.isChecked():
            while self.model.item(i):
                self.model.item(i).setCheckState(2)
                i += 1
        else:
            while self.model.item(j):
                self.model.item(j).setCheckState(0)
                j += 1
        if i > 5:
            QtWidgets.QMessageBox.information(self, "안내", "너무많은 레이어를 동시에 추가하면 속도가 느려질 수 있습니다. \n5개단위로 추가하시는 것을 권장립니다.")

    def upload_layer(self):
        layer = self.ulayer
        temp_folder = QgsProcessingUtils.tempFolder();
        os.chdir(temp_folder)
#        if os.path.exists(temp_folder+"/"+self.lineEdit.text()+"_"+layer.name()+".zip"):
#            os.remove(temp_folder+"/"+self.lineEdit.text()+"_"+layer.name()+".zip")
        # 압축 파일 생성
        zip_file_path = temp_folder+"/"+self.lineEdit.text()+"_"+layer.name()+".zip"
        print(zip_file_path)
		
        shp_file_path = temp_folder+"/"+layer.name()+".shp"
        QgsVectorFileWriter.writeAsVectorFormat(layer, shp_file_path, "utf-8", layer.crs(), "ESRI Shapefile")

        zipf = zipfile.ZipFile(zip_file_path, 'w')
        for ext in ['.shp', '.shx', '.dbf', '.prj', '.cpg']:
            file_path = shp_file_path.replace('.shp', ext)
            if os.path.exists(file_path):
                print(file_path)
                zipf.write(file_path, os.path.basename(file_path), compress_type=zipfile.ZIP_DEFLATED)
        zipf.close()

        url = "https://www.egiscloud.com/plugin/uploadShpFiles.do"
        apikey = self.lineEdit.text()

        files = open(zip_file_path, 'rb')
        upload = {'file': files }
        data = {'apikey': apikey }

        res = requests.post(url, files=upload, data=data, verify=False)
        if res is not None:
            print(res)        
        if res.status_code == 200:
            print('success')
            if res.json()['result'] == 'ok':
                print(res.json())
                #print('서울 외곽 지역의 레이어는 가시화가 되지 않을 수 있습니다.')
                #print('There is a posibility for this layer not to be shown if the internal boundary box is out of the city of Seoul.')
                QtWidgets.QMessageBox.information(self, "알림", "업로드 성공")
            else:
                print('Upload failed!')
                print(res.json())
                QtWidgets.QMessageBox.information(self, "알림", "업로드 실패")    
        else:
            print('Upload failed!')
            QtWidgets.QMessageBox.information(self, "알림", "업로드 실패")