# -*- coding: utf-8 -*-
"""
/***************************************************************************
 EcoResDialog - Ecosystem Respiration Tool - a QGIS plugin 
                               
 This plugin calculates ecosystem respiration from thermal images.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-02-06
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Florian Ellsäßer
        email                : el-flori@gmx.de
        
More information: https://github.com/FloEll/Ecosystem_Respiration_Tool

This is still an experimental version and I don't claim that it is perfect 
yet. If you spot bugs or problems with the method, please contact me! I'm 
always happy to improve this software. 

This software is based on two scientific publications: 
    
    Heskel et al. (2016) - Convergence in temperature response of leaf 
    respiration across biomes and plant functional types, Proceedings of the 
    National Academy of Sciences, 13 (14) 3832-3837; DOI: 10.1073/pnas.1520282113 
    
    and
    
    Kelly et al. (2021) - Modelling and upscaling ecosystem respiration using 
    thermal cameras and UAVs: Application to a peatland during and after a hot 
    drought,Agricultural and Forest Meteorology, Vol. 300, 108330, 
    https://doi.org/10.1016/j.agrformet.2021.108330.
    
If you want to cite this Plugin, please refer to: 
    
    F. Ellsäßer (2021) - Ecosystem Respiration Tool [...]

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

# import the necessary libraries
import os
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

# This loads the .ui file so that PyQt can populate the EcoRes plugin with the 
# elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'ecores_dialog_base.ui'))

# here we create a class for the EcoResDialog
class EcoResDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(EcoResDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
        # here we start with the biome dropdown combobox
        self.biome_input = self.biome_dropdown_comboBox
        # we populate it with the respective options of choice
        self.biome_input.addItems(['None selected',
                                   'Tundra (Tu)',
                                   'Boreal Forest (BF)',
                                   'Temperate Deciduous Forest (TeDF)',
                                   'Temperate Woodland (TeW)',
                                   'Temperate Rainforest (TeRF)',
                                   'High-Elevation Tropical Rainforest (TrRF_hi)',
                                   'Low-Elevation Tropical Rainforest (TrRF_lw)'
                                   ])
        # if it is activated we run the self.enter_biome function that fills 
        # the equation with predefined variables a, b and c an that sets the other 
        # combobox to default 
        self.biome_input.activated[str].connect(self.enter_biome)
        
        # here we start with the plant functional traits dropdown combobox
        self.pft_input = self.pft_dropdown_comboBox
        # we populate it with the respective options of choice
        self.pft_input.addItems(['None selected',
                                   'Broadleaf Deciduous Temperate (BIDcTmp)',
                                   'Broadleaf Deciduous Tropical (BIDcTrp)',
                                   'Broadleaf Evergreen Temperate (BIEvTmp)',
                                   'Broadleaf Evergreen Tropical (BIEvTrp)',
                                   'C3 Herbaceous (C3H)',
                                   'Needle-Leaf Evergreen (NIEv)',
                                   'Evergreen Shrubs (SEv)',
                                   'Oil palm dominated tropical landscape (OpTrp)',
                                   'Global Mean'
                                   ])
        # if it is activated we run the self.enter_biome function that fills 
        # the equation with predefined variables a, b and c an that sets the other 
        # combobox to default 
        self.pft_input.activated[str].connect(self.enter_pft)
        
        # if the manual input checkbox is checked, call the enter_manual_input function
        self.manual_checkBox.toggled.connect(self.enter_manual_input)
        
    
        # if the invert output checkbox is checked, call the invert_output function
        #self.invert_output_checkBox.toggled.connect(self.invert_output)
            
    def enter_manual_input(self):
        '''This function sets the comboboxes to default and empties the equation
        variables a, b and c to empty strings for manual input'''
        # set both comboboxes to default (empty state)
        self.pft_dropdown_comboBox.setCurrentIndex(-1)
        self.biome_dropdown_comboBox.setCurrentIndex(-1)
        # remove the numbers from the equation?! Not sure if this is a necessary feature
        self.a_input.setText('')
        self.b_input.setText('')
        self.c_input.setText('')
    
    def enter_biome(self):
        '''This function defines the a,b and c variable values from Heskel et 
        al. 2016 in the equation and unchecks the the checkbx and sets the 
        combobox to default/empty'''
        if self.biome_input.currentText() == 'Tundra (Tu)':
            self.a_input.setText('-1.6043')
            self.b_input.setText('0.1277')
            self.c_input.setText('-0.00107')
            # unselect the other 
            self.pft_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        elif self.biome_input.currentText() == 'Boreal Forest (BF)':
            self.a_input.setText('-2.0043')
            self.b_input.setText('0.0894')
            self.c_input.setText('-0.00037')
            # unselect the other 
            self.pft_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        elif self.biome_input.currentText() == 'Temperate Deciduous Forest (TeDF)':
            self.a_input.setText('-2.4286')
            self.b_input.setText('0.0923')
            self.c_input.setText('0.00026')
            # unselect the other 
            self.pft_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        elif self.biome_input.currentText() == 'Temperate Woodland (TeW)':
            self.a_input.setText('-1.8958')
            self.b_input.setText('0.0974')
            self.c_input.setText('0.00040')
            # unselect the other 
            self.pft_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        elif self.biome_input.currentText() == 'Temperate Rainforest (TeRF)':
            self.a_input.setText('2.1544')
            self.b_input.setText('0.1014')
            self.c_input.setText('0.00046')
            # unselect the other 
            self.pft_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        elif self.biome_input.currentText() == 'High-Elevation Tropical Rainforest (TrRF_hi)':
            self.a_input.setText('2.0173')
            self.b_input.setText('0.1154')
            self.c_input.setText('0.00071')
            # unselect the other 
            self.pft_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        elif self.biome_input.currentText() == 'Low-Elevation Tropical Rainforest (TrRF_lw)':
            self.a_input.setText('2.0173')
            self.b_input.setText('0.1154')
            self.c_input.setText('0.00071')
            # unselect the other 
            self.pft_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        else: 
            pass
        
        
    def enter_pft(self):
        '''This function defines the a,b and c variable values from Heskel et 
        al. 2016 in the equation and unchecks the the checkbx and sets the 
        combobox to default/empty'''
        if self.pft_input.currentText() == 'Broadleaf Deciduous Temperate (BIDcTmp)':
            self.a_input.setText('-2.2264')
            self.b_input.setText('0.0993')
            self.c_input.setText('-0.00050')
            # unselect the other 
            self.biome_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        elif self.pft_input.currentText() == 'Broadleaf Deciduous Tropical (BIDcTrp)':
            self.a_input.setText('2.7270')
            self.b_input.setText('0.1125')
            self.c_input.setText('-0.00058')
            # unselect the other 
            self.biome_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        elif self.pft_input.currentText() == 'Broadleaf Evergreen Temperate (BIEvTmp)':
            self.a_input.setText('-1.8106')
            self.b_input.setText('0.0896')
            self.c_input.setText('-0.00021')
            # unselect the other 
            self.biome_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        elif self.pft_input.currentText() == 'Broadleaf Evergreen Tropical (BIEvTrp)':
            self.a_input.setText('-2.6105')
            self.b_input.setText('0.1022')
            self.c_input.setText('-0.00052')
            # unselect the other 
            self.biome_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        elif self.pft_input.currentText() == 'C3 Herbaceous (C3H)':
            self.a_input.setText('1.7507')
            self.b_input.setText('0.1125')
            self.c_input.setText('-0.00110')
            # unselect the other 
            self.biome_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        elif self.pft_input.currentText() == 'Needle-Leaf Evergreen (NIEv)':
            self.a_input.setText('-2.0464')
            self.b_input.setText('0.0971')
            self.c_input.setText('-0.00047')
            # unselect the other 
            self.biome_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        elif self.pft_input.currentText() == 'Evergreen Shrubs (SEv)':
            self.a_input.setText('-2.2276')
            self.b_input.setText('0.1012')
            self.c_input.setText('-0.00050')
            # unselect the other 
            self.biome_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        elif self.pft_input.currentText() == 'Oil palm dominated tropical landscape (OpTrp)':
            self.a_input.setText('1.2783')
            self.b_input.setText('0.1017')
            self.c_input.setText('-0.0031')
            # unselect the other 
            self.biome_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
                       
        elif self.pft_input.currentText() == 'Global Mean':
            self.a_input.setText('-2.2276')
            self.b_input.setText('0.1012')
            self.c_input.setText('-0.00050')
            # unselect the other 
            self.biome_dropdown_comboBox.setCurrentIndex(-1)
            self.manual_checkBox.setChecked(False)
            
        else: 
            pass
        
      