# -*- coding: utf-8 -*-

"""
EconoMe - Connecting your QGIS-Project with EconoMe.
Version 1.3.1

Copyright (C) 2025 Federal Office for the Environment FOEN, Switzerland

Authors
  - Kevin Helzel (WSL Institute for Snow and Avalanche Research SLF, Davos, Switzerland)
  - Tobia Lezuo (Geotest AG, Davos, Switzerland)

Email
  - Plugin & Code: kevin.helzel@slf.ch
  - EconoMe project leader: linda.ettlin@slf.ch

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <https://www.gnu.org/licenses/>.

Generated by QGIS Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
"""

import os
import sys

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtGui import QIcon, QPixmap, QPalette
from qgis.PyQt.QtCore import Qt, QCoreApplication
from qgis.PyQt.QtWidgets import QLabel, QScrollArea


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'econo_me_dialog_asset_handling.ui'))


class DamagePotentialMismatchResolveDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None, mode = None, mismatch = None, main_dialog = None):
        super(DamagePotentialMismatchResolveDialog, self).__init__(parent)
        self.setupUi(self)

        # Force light mode when dark mode is detected
        if self.palette().color(QPalette.Window).value() < 100:
            self.setStyleSheet("""
                    QWidget { background-color: #F0F0F0; color: black; }  /* Light gray */
                    QLabel { color: black; }
                    QPushButton { background-color: #E0E0E0; border: 1px solid #C0C0C0; padding: 5px; }
                    QPushButton:hover { background-color: #D0D0D0; }
                    QLineEdit, QTextEdit { background-color: white; color: black; border: 1px solid #B0B0B0; }
                """)

        # Increase font size for Mac
        if sys.platform == 'darwin':
            for widget in self.findChildren(QLabel):
                font = widget.font()
                font.setPointSize(font.pointSize() + 5)
                widget.setFont(font)

        # Dialog header
        self.setWindowTitle(QCoreApplication.translate("EconoMe", "Schadenpotenzial synchronisieren"))
        self.setWindowIcon(QIcon(os.path.join(os.path.dirname(__file__), "icon.png")))
        self.labelScrollArea_message_text.setWordWrap(True)
        
        # Status icon
        self.plugin_dir = os.path.dirname(__file__)
        path_to_warning = os.path.join(self.plugin_dir + "\\icons", "warning.png")
        pixmap_warning = QPixmap(path_to_warning)
        scaled_pixmap_warning = pixmap_warning.scaled(
            main_dialog.IMAGE_LABEL_DAM_POT_STATUS_BUILDING.size(),
            Qt.KeepAspectRatio,
            Qt.SmoothTransformation)
        self.img_label.setPixmap(scaled_pixmap_warning)
        
        # avoid error none of the buttons is clicked and the dialog is closed
        self.selected_option = ""
        
        if mode == "MISMATCH":
            # set texts
            self.label_message_title.setText(QCoreApplication.translate("EconoMe", "ÄNDERUNGEN ZUSAMMENFÜHREN"))
            self.label_suptitle.setText(QCoreApplication.translate("EconoMe", "{exp} Schadenobjekte weisen Konflikte auf:").format(exp=len(mismatch.keys())))
            mismatch_text = ""
            for i, (AssetIdentID, asset_mismatch_dict) in enumerate(mismatch.items()):
                mismatch_text += f" {i + 1}) "
                mismatch_text += QCoreApplication.translate("EconoMe", "Objekt {asset_ident_id} \n").format(asset_ident_id=AssetIdentID)
                try:
                    # TODO: replace empty str/values with "leer"
                    # TODO: replace key with german translation
                    mismatch_text += "\n".join([QCoreApplication.translate("EconoMe", "    Attribut {key} ist in Layer {layer} und in EconoMe {value}").format(key=key, layer=value['Layer'], value=value['API']) for key, value in asset_mismatch_dict.items()]) + "\n"
                except:
                    mismatch_text += f"    {asset_mismatch_dict['Missing']}\n"
            self.label_question.setText(QCoreApplication.translate("EconoMe", "Welche Schadenobjekte sollen beibehalten werden?"))
            self.button_opt1.setText(QCoreApplication.translate("EconoMe", "Layer-Objekte"))
            self.label_opt1.setText(QCoreApplication.translate("EconoMe", "Überschreibt Objekt-Attribute in EconoMe."))
            self.button_opt2.setText(QCoreApplication.translate("EconoMe", "EconoMe-Objekte"))
            self.label_opt2.setText(QCoreApplication.translate("EconoMe", "Überschreibt Objekt-Attribute im Layer."))
            
            # buttons and answer
            self.button_opt1.clicked.connect(self.keep_layer_assets)
            self.button_opt2.clicked.connect(self.keep_econome_assets)
        elif mode == "MISSING":
            # set texts
            self.label_message_title.setText(QCoreApplication.translate("EconoMe", "ÄNDERUNGEN ZUSAMMENFÜHREN"))
            self.label_suptitle.setText(QCoreApplication.translate("EconoMe", "{len_objects} Schadenobjekte fehlen im Layer:").format(len_objects=len(mismatch.keys())))
            mismatch_text = ""
            for AssetIdentID, asset_mismatch_dict in mismatch.items():
                mismatch_text += QCoreApplication.translate("EconoMe", "Objekt {asset_ident_id} \n").format(asset_ident_id=AssetIdentID)
                mismatch_text += f"    {asset_mismatch_dict['Missing']}\n"
            self.label_question.setText(QCoreApplication.translate("EconoMe", "Was soll mit den diesen fehlenden Schadenobjekten passieren?"))
            self.button_opt1.setText(QCoreApplication.translate("EconoMe", "Im EconoMe löschen"))
            self.label_opt1.setText(QCoreApplication.translate("EconoMe", "Informationen gehen verloren."))
            self.button_opt2.setText(QCoreApplication.translate("EconoMe", "In EconoMe behalten"))
            self.label_opt2.setText(QCoreApplication.translate("EconoMe", "Bitte fehlende Objekte dem Layer hinzufügen."))
            
            # buttons and answer
            self.button_opt1.clicked.connect(self.delete_missing_assets)
            self.button_opt2.clicked.connect(self.no_change)

        layout = self.layout()
        if len(mismatch_text) < 100:  # CASE: Message text has less than 100 characters

            self.label_suptitle.setText(mismatch_text)  # Set message text to subtitle label

            # Hide scroll area
            self.scrollArea.hide()
            # Adjust dialog size
            self.adjustSize()

        else:  # CASE: Message text has more than 100 characters

            self.labelScrollArea_message_text.setText(mismatch_text)  # Set message text to scroll area label

            # Add some padding for better UI appearance
            self.labelScrollArea_message_text.setStyleSheet("""
                        padding-left: 10px;
                        padding-right: 10px;
                    """)

            # Get text container height and width
            content_height = self.labelScrollArea_message_text.sizeHint().height()
            content_width = self.labelScrollArea_message_text.sizeHint().width() + 200

            # Create new scroll area customized for longer text
            self.scrollAreaLongText = QScrollArea()
            self.scrollAreaLongText.setWidget(self.labelScrollArea_message_text)
            self.scrollAreaLongText.setWidgetResizable(True)
            self.scrollAreaLongText.setVerticalScrollBarPolicy(Qt.ScrollBarAsNeeded)
            self.scrollAreaLongText.setHorizontalScrollBarPolicy(Qt.ScrollBarAlwaysOff)

            # Set dynamic height
            self.scrollAreaLongText.setMinimumHeight(200)
            self.scrollAreaLongText.setMaximumHeight(content_height)

            # Set dynamic width
            self.scrollAreaLongText.setMinimumWidth(content_width + 40)
            self.scrollAreaLongText.setMaximumWidth(content_width + 40)

            # Exchange scroll areas
            index = layout.indexOf(self.scrollArea)
            layout.insertWidget(index, self.scrollAreaLongText)  # type: ignore
            self.scrollArea.hide()

    def keep_layer_assets(self):
        self.selected_option = "KEEP LAYER ASSETS"
        self.accept()
    def keep_econome_assets(self):
        self.selected_option = "KEEP ECONOME ASSETS"
        self.accept()
    def delete_missing_assets(self):
        self.selected_option = "DELETE MISSING ASSETS"
        self.accept()
    def no_change(self):
        self.selected_option = "NO CHANGE"
        self.accept()