# -*- coding: utf-8 -*-

# EconoMe Plugin, Version 1.3

import os, sys

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtGui import QPalette

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'econo_me_dialog_base.ui'))


class EconoMeDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(EconoMeDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # Force light mode when dark mode is detected
        if self.palette().color(QPalette.Window).value() < 100:
            self.setStyleSheet("""
                    QWidget { background-color: #F0F0F0; color: black; }  /* Light gray */
                    QLabel { color: black; }
                    QPushButton { background-color: #E0E0E0; border: 1px solid #C0C0C0; padding: 5px; }
                    QPushButton:hover { background-color: #D0D0D0; }
                    QLineEdit, QTextEdit { background-color: white; color: black; border: 1px solid #B0B0B0; }
                """)
            
        self.SCENARIO_WIDGETS = {
            "FREE": {
            "LABEL": "LABEL_SCENARIO_FREE",
            "LAYER_INTENSITY": "LAYER_INTENSITY_SCENARIO_FREE",
            "COMBO_BOX_INTENSITY_COLUMN_NAME": "COMBO_BOX_INTENSITY_COLUMN_NAME_FREE",
            "BUTTON_DEL_AFFECTED_ASSETS": "BUTTON_DEL_AFFECTED_ASSETS_FREE",
            "IMAGE_LABEL_INT_MAP_STATUS": "IMAGE_LABEL_INT_MAP_STATUS_FREE",
            },
            "30": {
            "LABEL": "LABEL_SCENARIO_30",
            "LAYER_INTENSITY": "LAYER_INTENSITY_SCENARIO_30",
            "COMBO_BOX_INTENSITY_COLUMN_NAME": "COMBO_BOX_INTENSITY_COLUMN_NAME_30",
            "BUTTON_DEL_AFFECTED_ASSETS": "BUTTON_DEL_AFFECTED_ASSETS_30",
            "IMAGE_LABEL_INT_MAP_STATUS": "IMAGE_LABEL_INT_MAP_STATUS_30",
            },
            "100": {
            "LABEL": "LABEL_SCENARIO_100",
            "LAYER_INTENSITY": "LAYER_INTENSITY_SCENARIO_100",
            "COMBO_BOX_INTENSITY_COLUMN_NAME": "COMBO_BOX_INTENSITY_COLUMN_NAME_100",
            "BUTTON_DEL_AFFECTED_ASSETS": "BUTTON_DEL_AFFECTED_ASSETS_100",
            "IMAGE_LABEL_INT_MAP_STATUS": "IMAGE_LABEL_INT_MAP_STATUS_100",
            },
            "300": {
            "LABEL": "LABEL_SCENARIO_300",
            "LAYER_INTENSITY": "LAYER_INTENSITY_SCENARIO_300",
            "COMBO_BOX_INTENSITY_COLUMN_NAME": "COMBO_BOX_INTENSITY_COLUMN_NAME_300",
            "BUTTON_DEL_AFFECTED_ASSETS": "BUTTON_DEL_AFFECTED_ASSETS_300",
            "IMAGE_LABEL_INT_MAP_STATUS": "IMAGE_LABEL_INT_MAP_STATUS_300",
            },
            "EXTREME": {
            "LABEL": "LABEL_SCENARIO_EXTREME",
            "LAYER_INTENSITY": "LAYER_INTENSITY_SCENARIO_EXTREME",
            "COMBO_BOX_INTENSITY_COLUMN_NAME": "COMBO_BOX_INTENSITY_COLUMN_NAME_EXTREME",
            "BUTTON_DEL_AFFECTED_ASSETS": "BUTTON_DEL_AFFECTED_ASSETS_EXTREME",
            "IMAGE_LABEL_INT_MAP_STATUS": "IMAGE_LABEL_INT_MAP_STATUS_EXTREME",
            },
        }

        self.GROUP_BOX_DAMAGE_POTENTIAL.collapsedStateChanged.connect(self.update_window_size)
        
    def update_window_size(self):
        # Adjust dialog size based on system OS
        if sys.platform == 'darwin':  # For Mac OS
            if self.GROUP_BOX_DAMAGE_POTENTIAL.isCollapsed():
                self.setFixedSize(580, 620)
                self.scroll.setFixedWidth(self.width() - 20)
                self.content.setFixedWidth(self.scroll.width())
            else:
                self.setFixedSize(600, 620)
                self.scroll.setFixedWidth(self.width() - 20)
                self.content.setFixedWidth(self.scroll.width() - 12)

        else:  # For Windows and others
            if self.GROUP_BOX_DAMAGE_POTENTIAL.isCollapsed():
                self.setFixedSize(570, 610)
                self.scroll.setFixedWidth(self.width() - 20)
                self.content.setFixedWidth(self.scroll.width())
            else:
                self.setFixedSize(590, 610)
                self.scroll.setFixedWidth(self.width() - 20)
                self.content.setFixedWidth(self.scroll.width() - 12)
