# EconoMe

## Description
Connecting your QGIS-Project with EconoMe.\
Version 1.3

Load information from QGIS into your EconoMe project and vice versa. 
Download the calculated damage and risk results from EconoMe to visualize them in your QGIS project.

USER MANUAL available [here](https://econome.ch/econome_doc/wiki/manual_plugin_E.pdf)!

IMPORTANT: You need to have an EconoMe User Account in order to use the plugin!

© 2025 Federal Office for the Environment FOEN, Switzerland

## Features
- Connect to your EconoMe project(s)
- Synchronize damage potential between EconoMe and local GIS layers
- Consequence analysis and upload
- Visualize risk results

## Installation
### QGIS Plugin Manager (Recommended)
1. Open QGIS.
2. Go to **Plugins** > **Manage and Install Plugins**.
3. Search for "EconoMe".
4. Click **Install**.

### Manual Installation
1. Download the plugin from GitLab or other sources.
2. Place the plugin folder in your QGIS plugin directory (typically `~/.qgis3/python/plugins/` or `C:/Users/[username]/AppData/Roaming/QGIS/QGIS3/profiles/default/python/plugins/`).
3. Restart QGIS and enable the plugin from the Plugin Manager.

## Requirements
- QGIS 3.x or later.
- Python 3.x.
- Additional dependencies: `requests` (usually pre-installed)

## Usage
1. After installation, open QGIS.
2. You should see the plugin in the **Plugins** menu.
3. Use the plugin’s interface to select your desired functionality.

## License
This plugin is licensed under the **GPL-3**. See the [LICENSE](LICENSE) file for more information.

## Contact
- Author(s): 
  - Kevin Helzel (WSL Institute for Snow and Avalanche Research SLF, Davos, Switzerland)
  - Tobia Lezuo (Geotest AG, Davos, Switzerland)

- Email: 
  - Plugin & Code: kevin.helzel@slf.ch
  - EconoMe project leader: linda.ettlin@slf.ch

- Gitlab: https://gitlabext.wsl.ch/econome-dev-team/econome
