# -*- coding: utf-8 -*-

"""
EconoMe - Connecting your QGIS-Project with EconoMe.
Plugin Version 1.2.3

Copyright (C) 2025 Federal Office for the Environment FOEN, Switzerland

Authors
  - Kevin Helzel (WSL Institute for Snow and Avalanche Research SLF, Davos, Switzerland)
  - Tobia Lezuo (Geotest AG, Davos, Switzerland)

Email
  - Plugin & Code: kevin.helzel@slf.ch
  - EconoMe project leader: linda.ettlin@slf.ch

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <https://www.gnu.org/licenses/>.

Generated by QGIS Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
"""

import os
import sys

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import Qt, QCoreApplication
from qgis.PyQt.QtGui import QIcon, QPixmap, QPalette, QCursor
from qgis.PyQt.QtWidgets import QLabel


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'econo_me_dialog_status.ui'))


class StatusDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, message_title = 'Test Title', message_text = None, status_icon: QPixmap = None, parent=None):
        """Constructor."""
        super(StatusDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # Force light mode when dark mode is detected
        if self.palette().color(QPalette.Window).value() < 100:
            self.setStyleSheet("""
                    QWidget { background-color: #F0F0F0; color: black; }  /* Light gray */
                    QLabel { color: black; }
                    QPushButton { background-color: #E0E0E0; border: 1px solid #C0C0C0; padding: 5px; }
                    QPushButton:hover { background-color: #D0D0D0; }
                    QLineEdit, QTextEdit { background-color: white; color: black; border: 1px solid #B0B0B0; }
                """)

        # Increase font size for Mac
        if sys.platform == 'darwin':
            for widget in self.findChildren(QLabel):
                font = widget.font()
                font.setPointSize(font.pointSize() + 5)
                widget.setFont(font)

        # Dialog header
        self.setWindowIcon(QIcon(os.path.join(os.path.dirname(__file__), "icon.png")))
        self.labelScrollArea_message_text.setWordWrap(True)
        
        # Status icon
        self.img_label.setPixmap(QPixmap(status_icon))
        
        # Dialog button
        self.pushButton_Ok.clicked.connect(self.close)
        self.pushButton_Ok.setCursor(QCursor(Qt.PointingHandCursor))
        
        # Set the message title and text
        self.label_message_title.setText(message_title.upper())
        if len (message_text) < 100:
            self.label_suptitle.setText(message_text)
            # hide the scroll area
            self.scrollArea.hide()
        else:
            self.labelScrollArea_message_text.setText(message_text)
            # hide the one liner
            self.label_suptitle.hide()
        