# -*- coding: utf-8 -*-

# EconoMe Plugin, Version 1.2.3

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtGui import QPalette

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'econo_me_dialog_base.ui'))


class EconoMeDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(EconoMeDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # Force light mode when dark mode is detected
        if self.palette().color(QPalette.Window).value() < 100:
            self.setStyleSheet("""
                    QWidget { background-color: #F0F0F0; color: black; }  /* Light gray */
                    QLabel { color: black; }
                    QPushButton { background-color: #E0E0E0; border: 1px solid #C0C0C0; padding: 5px; }
                    QPushButton:hover { background-color: #D0D0D0; }
                    QLineEdit, QTextEdit { background-color: white; color: black; border: 1px solid #B0B0B0; }
                """)
