from pathlib import Path

from qgis.PyQt.QtCore import QT_VERSION_STR, QIODevice, Qt
from qgis.PyQt.QtWidgets import QToolButton, QDockWidget, QFrame

PLUGIN_DIR = Path(__file__).parent
QT_MAJOR_VERSION = int(QT_VERSION_STR.split(".")[0])
IS_QT5 = QT_MAJOR_VERSION == 5
IS_QT6 = QT_MAJOR_VERSION == 6

if IS_QT5:
    QT_LEFT_BUTTON = Qt.LeftButton
    QT_RIGHT_BUTTON = Qt.RightButton
    QT_CROSSCURSOR = Qt.CrossCursor
    OPEN_READ_ONLY = QIODevice.ReadOnly
    OPEN_TEXT = QIODevice.Text
    MENUBUTTON_POPUP = QToolButton.MenuButtonPopup
    INSTANT_POPUP = QToolButton.InstantPopup
    NO_DOCKWIDGET_AREA = Qt.NoDockWidgetArea
    RIGHT_DOCKWIDGET_AREA = Qt.RightDockWidgetArea
    DOCK_WIDGET_CLOSABLE = QDockWidget.DockWidgetClosable
    NO_FRAME = QFrame.NoFrame

if IS_QT6:
    QT_LEFT_BUTTON = Qt.MouseButton.LeftButton
    QT_RIGHT_BUTTON = Qt.MouseButton.RightButton
    QT_CROSSCURSOR = Qt.CursorShape.CrossCursor
    OPEN_READ_ONLY = QIODevice.OpenModeFlag.ReadOnly
    OPEN_TEXT = QIODevice.OpenModeFlag.Text
    MENUBUTTON_POPUP = QToolButton.ToolButtonPopupMode.MenuButtonPopup
    INSTANT_POPUP = QToolButton.ToolButtonPopupMode.InstantPopup
    NO_DOCKWIDGET_AREA = Qt.DockWidgetArea.NoDockWidgetArea
    RIGHT_DOCKWIDGET_AREA = Qt.DockWidgetArea.RightDockWidgetArea
    DOCK_WIDGET_CLOSABLE = QDockWidget.DockWidgetFeature.DockWidgetClosable
    NO_FRAME = QFrame.Shape.NoFrame