from pathlib import Path

from qgis.core import QgsSettings
from qgis.PyQt.QtCore import QCoreApplication, QLocale, QTranslator

from .widgets import EasySearch


class Plugin:
    def __init__(self, iface):
        self.iface = iface
        self.load_translation()

    def initGui(self):
        self.toolbar = EasySearch()
        self.iface.addToolBar(self.toolbar)

    def unload(self):
        self.toolbar.unload()
        self.iface.mainWindow().removeToolBar(self.toolbar)
        self.toolbar.deleteLater()

    def tr(self, message: str) -> str:
        return QCoreApplication.translate("Plugin", message)

    def load_translation(self):
        plugin_dir: Path = Path(__file__).parent
        locale: str = QLocale().name()
        user_locale: str = QgsSettings().value("locale/userLocale", "")
        locale_path = plugin_dir.joinpath(f"i18n/{locale}.qm")
        user_locale_path1 = plugin_dir.joinpath(f"i18n/{user_locale}.qm")
        user_locale_path2 = plugin_dir.joinpath(f"i18n/{locale[:2]}.qm")

        if locale_path.is_file():
            qm_path = locale_path
        elif user_locale_path1.is_file():
            qm_path = user_locale_path1
        elif user_locale_path2.is_file():
            qm_path = user_locale_path2
        else:
            return

        self.translator = QTranslator()
        self.translator.load(str(qm_path))
        QCoreApplication.installTranslator(self.translator)
