 # -*- coding: utf8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
import utils, math, time, os


class CreateSimpleMap( QObject ):
    
    def __init__( self, iface, printScale, printFormat, layoutIndex, titleString, subtitleString, personString, crsdesc, grid, legend, copyright, cuttinglines, foldingmarks, printAsRaster=False, mapExtent=None, overlapPercentage=0, overviewMap=False, adjacentTiles=None, exportPath=None, printToFile=False, tileName=None, printRotation=0):
        self.iface = iface
        self.canvas = self.iface.mapCanvas()
        self.printScale = printScale
        self.printFormat = printFormat
        self.layoutIndex = layoutIndex
        self.titleString = titleString
        self.subtitleString = subtitleString
        self.personString = personString
        self.crsdesc = crsdesc
        self.grid = grid
        self.legend = legend
        self.copyright = copyright
        self.cuttinglines = cuttinglines
        self.foldingmarks = foldingmarks
        self.printAsRaster = printAsRaster
        self.mapExtent = mapExtent
        self.overlapPercentage = overlapPercentage
        self.overviewMap = overviewMap
        self.adjacentTiles = adjacentTiles        
        self.exportPath = exportPath
        self.printToFile= printToFile
        self.tileName = tileName
        self.printRotation = printRotation
        
        self.newMapExtent = None
        self.printer = None
        self.painter = None
        self.fileName = None

        print "createsimpleMap"
        print printScale

    
    def setOutputFileName( self,  fileName ):
        self.fileName = fileName
        
        
    def setPrinterPainter( self, printer, painter ):
        self.printer = printer
        self.painter = painter
    

    def getMapExtent( self ):
        return self.newMapExtent


    def run( self ):        
        
        paperheight,  paperwidth = utils.getPapersize(self.printFormat)        

        layouts = utils.getLayouts()   
        layout = layouts[self.layoutIndex]
        
        margins = layout.getMargins()
        margin_top = margins['margin-top']
        margin_right = margins['margin-right']
        margin_bottom = margins['margin-bottom']
        margin_left = margins['margin-left']        
                
        orientation = layout.getOrientation()
        if orientation == "landscape":
            paperwidth_tmp = paperwidth
            paperwidth = paperheight
            paperheight = paperwidth_tmp
            
        headerHeight = 0
        footerHeight = 0            
        
        if self.printToFile == False:
            beforeList = self.iface.activeComposers()
            self.iface.actionPrintComposer().trigger()  
            afterList = self.iface.activeComposers()
            
            diffList = []
            for item in afterList:
                if not item in beforeList:
                    diffList.append(item)

            composerView = diffList[0]
            composition = composerView.composition()
            composition.setPaperSize(float(paperwidth),  float(paperheight))

            # Trick to easy handle API 2.0 changes made in commit 59c28db602f6.
            # The following QgsComposerView's methods was moved to 
            # QgsComposition class, so add fake attributes to composition 
            # object pointing to the old composerView's methods
            # IMPORTANT: this fix will work only if the composerView is not 
            # destroyed before using the composition fake methods
            if not hasattr(composition, 'addComposerShape'):
                composition.addComposerShape = composerView.addComposerShape
            if not hasattr(composition, 'addComposerLabel'):
                composition.addComposerLabel = composerView.addComposerLabel
            if not hasattr(composition, 'addComposerPicture'):
                composition.addComposerPicture = composerView.addComposerPicture
            if not hasattr(composition, 'addComposerLegend'):
                composition.addComposerLegend = composerView.addComposerLegend
            if not hasattr(composition, 'addComposerScaleBar'):
                composition.addComposerScaleBar = composerView.addComposerScaleBar
            if not hasattr(composition, 'addComposerMap'):
                composition.addComposerMap = composerView.addComposerMap

        else:
            mapRenderer = self.iface.mapCanvas().mapRenderer()
            composition = QgsComposition(mapRenderer)
            composition.setPlotStyle(QgsComposition.Print)
            composition.setPaperSize(float(paperwidth), float(paperheight))
            composition.setPrintResolution(300)


        ## Cutting lines.
        if self.cuttinglines == True:
            self.cuttingLines(composition)
        
        ## Folding marks.
        if self.foldingmarks == True:
            self.foldingMarks(composition)

        decorations = layout.getDecorations()
        for decoration in decorations:
            
            print "***********************************3"
            print str(decoration)
            print "***********************************3"

            type = decoration.getType()

            offset_x = decoration.getOffsetX()
            offset_y = decoration.getOffsetY()
            
            if decoration.getAffinityX() == "right":
                offset_x = float(paperwidth) - margin_left - margin_right - offset_x

            if decoration.getAffinityY() == "bottom":
                offset_y = float(paperheight) - margin_top - margin_bottom - decoration.getHeight() - offset_y        

            ## Header und Footer muessen vorhanden sein,
            ## sonst kann die Groesse der Karte nicht ausgerechnet 
            ## werden. Dementsprechend muessen sie auch vor 
            ## der Karte prozessiert werden.
            if type == "header"  or type == "footer":
                height = decoration.getHeight()
                width = decoration.getWidth()
                if type == "header":
                    headerHeight = height
                    headerWidth = width
                elif type == "footer":
                    footerHeight = height
                    footerWidth = width
                if orientation == "portrait":
                    item = QgsComposerShape(margin_left+offset_x,  margin_top+offset_y, float(paperwidth)-(margin_right+margin_left),  height, composition)
                else:
                    item = QgsComposerShape(margin_left+offset_x,  margin_top+offset_y, width,  float(paperheight)-(margin_top+margin_bottom), composition)
                item.setShapeType(1)
                item.setLineWidth(0.0)  
                pen = QPen()
                pen.setWidthF(0.2)
                pen.setJoinStyle(Qt.MiterJoin)
                item.setPen(pen)
                item.setPositionLock(1)   
                
                if self.printToFile == False:
                    composition.addComposerShape(item)
                else:
                    composition.addItem(item)
   
             
            elif type == "title" or type == "subtitle" or type == "person":
                titleFont = QFont(decoration.getFontFamily(), decoration.getFontSize())
                if decoration.getFontWeight() == 3:
                    titleFont.setBold(True)

                item = QgsComposerLabel(composition)
                item.setFont(titleFont)
                if type == "title":
                    item.setText(self.titleString)
                elif type == "subtitle":
                    item.setText(self.subtitleString)
                elif type == "person":
                    item.setText(decoration.getText() + self.personString)
                
                if decoration.getWidth() > 0:
                    #item.setRect(0, 0, decoration.getWidth(),  decoration.getHeight())
                    # funktioniert momenta nicht.... 
                    item.adjustSizeToText()  
                else:
                    item.adjustSizeToText()            
                    
                item.setFrame(0)
                item.setMargin(0)
                brush = QBrush()
                brush.setStyle(Qt.NoBrush)  
                brush.setColor(Qt.white)                
                item.setBrush(brush)      
                item.setZValue(20)
                item.setItemPosition(margin_left+offset_x,  margin_top+offset_y)
                item.updateItem()
                
                if self.printToFile == False:
                    composition.addComposerLabel(item)
                else:
                    composition.addItem(item)
                
                item.updateItem()
                
            elif type == "text" or type == "author" or type == "copyright":
                textFont = QFont(decoration.getFontFamily(), decoration.getFontSize())
                if decoration.getFontWeight() == 3:
                    textFont.setBold(True)

                item = QgsComposerLabel(composition)
                item.setFont(textFont)
                item.setText(unicode(decoration.getText()))
                if decoration.getWidth() > 0:
                    item.setRect(0, 0, decoration.getWidth(),  decoration.getHeight())
                else:
                    item.adjustSizeToText()
                item.setFrame(0)
                item.setMargin(0)
                brush = QBrush()
                brush.setStyle(Qt.NoBrush)  
                brush.setColor(Qt.white)                
                item.setBrush(brush)                
                item.setZValue(20)
                item.setItemPosition(margin_left+offset_x,  margin_top+offset_y)
                
                ## Rotate the item. (does not work...)
                if decoration.getRotation() != 0:
                    item.setRotation(decoration.getRotation())
                    
                if type == "copyright" and copyright == False:
                    continue
                else:
                    if self.printToFile == False:
                        composition.addComposerLabel(item)
                    else:
                        composition.addItem(item)
                    

            elif type == "date":
                dateFont = QFont(decoration.getFontFamily(), decoration.getFontSize())
                if decoration.getFontWeight() == 3:
                    textFont.setBold(True)
                    
                item = QgsComposerLabel(composition)
                item.setFont(dateFont)
                d = time.localtime()
                item.setText(unicode(decoration.getText()) + "%d.%d.%d" % (d[2],  d[1],  d[0]))
                item.adjustSizeToText()
                item.setFrame(0)
                item.setMargin(0)
                brush = QBrush()
                brush.setStyle(Qt.NoBrush)  
                brush.setColor(Qt.white)  
                item.setBrush(brush)
                item.setItemPosition(margin_left+offset_x,  margin_top+offset_y)    
                   
                if self.printToFile == False:
                    composition.addComposerLabel(item)
                else:
                    composition.addItem(item)
                
                
            elif type == "picture" or type == "northarrow":
                item = QgsComposerPicture(composition)
                pic = QDir.convertSeparators(QDir.cleanPath(QgsApplication.qgisSettingsDirPath() + "/python/plugins/easyprint/pictures/" + decoration.getPicture())) 
                item.setPictureFile( pic )
                item.setSceneRect(QRectF(0,  0, decoration.getWidth(), decoration.getHeight()))
                item.setItemPosition(margin_left+offset_x, margin_top+offset_y)
                if type == "northarrow":
                    item.setRotationMap(0)
                item.setFrame(0)
                item.setZValue(10) 
                item.setPositionLock(1)
                
                if self.printToFile == False:
                    composition.addComposerPicture(item)
                else:
                    composition.addItem(item)
                    
            
            elif type == "crsdescription":
                if self.crsdesc == True:
                    textFont = QFont(decoration.getFontFamily(), decoration.getFontSize())
                    if decoration.getFontWeight() == 3:
                        textFont.setBold(True)
                    
                    item = QgsComposerLabel(composition)
                    item.setFont(textFont)
                    
                    srsDescriptionText = self.iface.mapCanvas().mapRenderer().destinationCrs().description() 
                    itemText = unicode(decoration.getText()) + unicode(str(srsDescriptionText)) 
                    item.setText(itemText)
                    
                    if decoration.getWidth() > 0:
                        item.setRect(0, 0, decoration.getWidth(),  decoration.getHeight())
                    else:
                        item.adjustSizeToText()
                    item.setFrame(0)
                    item.setMargin(0)
                    brush = QBrush()
                    brush.setStyle(Qt.NoBrush)  
                    brush.setColor(Qt.white)                
                    item.setBrush(brush)                
                    item.setZValue(20)
                    item.setItemPosition(margin_left+offset_x,  margin_top+offset_y)
                        
                    if self.printToFile == False:
                        composition.addComposerLabel(item)
                    else:
                        composition.addItem(item)
 
     
            elif type == "legend":
                if self.legend == True:
                    legendFont = QFont(decoration.getFontFamily(), decoration.getFontSize())
                    groupFont = QFont(decoration.getFontFamily(), decoration.getFontSize()-1)
                    layerFont = QFont(decoration.getFontFamily(), decoration.getFontSize()-2)
                    itemFont = QFont(decoration.getFontFamily(), decoration.getFontSize()-2)
                    item = QgsComposerLegend(composition)
                    item.setTitle(decoration.getText())
                    item.adjustBoxSize()
                    item.setItemPosition(margin_left+offset_x, margin_top+offset_y)
                    item.setItemFont(itemFont)
                    item.setLayerFont(layerFont)
                    try:
                        item.setGroupFont(groupFont) 
                    except:
                        print "EASYPRINT: old qgis version..."
                    item.setTitleFont(legendFont)
                    item.setSymbolWidth(6)
                    item.setSymbolHeight(3)
                    item.setLayerSpace(2)
                    item.setSymbolSpace(1.5)
                    item.setBoxSpace(0)
                    item.setPositionLock(1)
                    item.setFrame(0)
                    item.setZValue(30)
                    brush = QBrush()
                    brush.setStyle(Qt.NoBrush)  
                    brush.setColor(Qt.white)                
                    item.setBrush(brush)      

                    if self.printToFile == False:
                        composition.addComposerLegend(item)
                    else:
                        item.updateLegend()
                        item.adjustBoxSize()
                        composition.addItem(item) 
                  
                    item.updateLegend()
                          

            elif type == "map":
                scale = float(self.printScale)
                print "scale: " + str(scale)
                
                if orientation == "portrait":
                    mapWidth = float(paperwidth)-(margin_right+margin_left)
                    mapHeight = float(paperheight)-margin_top-margin_bottom-headerHeight-footerHeight 
                    composerMap = QgsComposerMap(composition, margin_left+offset_x,  margin_top+offset_y, mapWidth,  mapHeight)
                else:
                    mapWidth = float(paperwidth) - (headerWidth+margin_right+margin_left+(offset_x-headerWidth))
                    mapHeight = float(paperheight) - margin_top-margin_bottom
                    composerMap = QgsComposerMap(composition, margin_left+offset_x,  margin_top+offset_y, mapWidth,  mapHeight )

                if self.mapExtent == None:
                    # No mapExtent means we are in the standard easyprint mode.
                    # This is a workaround for latlon stuff. Why is setNewScale not working?
                    projectEPSG = self.canvas.mapRenderer().destinationCrs().toProj4()
                    if str.find(str(projectEPSG),  "+proj=longlat") >= 0:
                        composerMap.setNewScale(scale) # Does not center correctly?
                    else:
                        rect = self.getMapExtentFromMapCanvas(mapWidth,  mapHeight,  scale)
                        composerMap.setNewExtent(rect)

                else:            
                    # If mapExtent is empty, it is a point.
                    # We do consider the printScale here.
                    if self.mapExtent.isEmpty():
                        projectEPSG = self.canvas.mapRenderer().destinationSrs().toProj4()
                        if str.find(str(projectEPSG),  "+proj=longlat") >= 0:
                            composerMap.setNewScale(scale) # Does not center correctly?
                        else:
                            newMapExtent = self.getMapExtentFromPoint(mapWidth, mapHeight, scale, self.mapExtent.center())
                            composerMap.setNewExtent(newMapExtent)

                    # We do NOT consider the printScale for Linestrings and Polygons.
                    else:
                        # Since the ratio of the feature's extent the one from the map may not be identical (except mapbook by grid)
                        # we have to calculate e new map extent.
                        self.newMapExtent = self.getMapExtentFromFeatureExtent(mapWidth, mapHeight, self.mapExtent)
                        self.newMapExtent.scale(float(1) + float(self.overlapPercentage)/100)
                        composerMap.setNewExtent(self.newMapExtent)

                    composerMap.setRotation(float(self.printRotation))
    
                composerMap.setFrame(1)
                pen = QPen()
                pen.setWidthF(0.2)
                pen.setJoinStyle(Qt.MiterJoin)
                composerMap.setPen(pen)
                composerMap.setPreviewMode(2)   # Does not work!?!?!
                composerMap.setPositionLock(1)
                
                ## Grids and grid annotations
                if self.grid == True:
                    interval = self.getGridInterval(composerMap.scale())
                    composerMap.setGridEnabled(True)
                    composerMap.setGridStyle(1)
                    composerMap.setGridIntervalX(interval)
                    composerMap.setGridIntervalY(interval)
                    composerMap.setShowGridAnnotation(True)
                    gridFont = QFont(decoration.getFontFamily(), 6)
                    gridFont.setItalic(True)
                    composerMap.setGridAnnotationFont(gridFont)
                    composerMap.setGridAnnotationPrecision(0)
                    composerMap.setGridAnnotationPosition(0, 3)
                    composerMap.setGridAnnotationDirection(2, 3)                    
                    composerMap.setGridAnnotationPosition(0, 2)
                    composerMap.setGridAnnotationDirection(2, 2)
                    composerMap.setGridAnnotationPosition(0, 1)
                    composerMap.setGridAnnotationDirection(0, 1)                    
                    composerMap.setGridAnnotationPosition(0, 0)
                    composerMap.setGridAnnotationDirection(0, 0)
                    composerMap.setAnnotationFrameDistance(4)
                    composerMap.setGridPenWidth(0.1)
                    
                if self.printToFile == False:
                    composition.addComposerMap(composerMap)
                else:
                    composition.addItem(composerMap)
                

            elif type == "scaletext":
                textFont = QFont(decoration.getFontFamily(), decoration.getFontSize())
                if decoration.getFontWeight() == 3:
                    textFont.setBold(True)
                    
                item = QgsComposerLabel(composition)
                item.setFont(textFont)
                item.setText(unicode(decoration.getText()))          
                if decoration.getWidth() > 0:
                    item.setRect(0, 0, decoration.getWidth(),  decoration.getHeight())
                else:
                    item.adjustSizeToText()
                item.setFrame(0)
                item.setMargin(0)
                brush = QBrush()
                brush.setStyle(Qt.NoBrush)  
                brush.setColor(Qt.white)                
                item.setBrush(brush)                
                item.setZValue(20)
                item.setItemPosition(margin_left+offset_x,  margin_top+offset_y) 
                
                if self.printToFile == False:
                    composition.addComposerLabel(item)
                else:
                    composition.addItem(item)

                composerScaleBar = QgsComposerScaleBar(composition)
                composerScaleBar.setComposerMap(composerMap)
                composerScaleBar.setFont(textFont)
                composerScaleBar.setStyle('Numeric')
                composerScaleBar.setFrame(0)
                composerScaleBar.setBoxContentSpace(0.3) # heuristic
                composerScaleBar.update()
                
                width = item.boundingRect().width()
                
                composerScaleBar.setItemPosition(margin_left+offset_x + width + 1, margin_top+offset_y)                
                
                if self.printToFile == False:
                    composition.addComposerScaleBar(composerScaleBar)
                else:
                    composition.addItem(composerScaleBar) 


            elif type == "mapbookid" and self.tileName <> None:
                textFont = QFont(decoration.getFontFamily(), decoration.getFontSize())
                if decoration.getFontWeight() == 3:
                    textFont.setBold(True)
                    
                brush = QBrush()
##                brush.setStyle(Qt.SolidPattern)  
                brush.setStyle(Qt.NoBrush)  
                brush.setColor(Qt.white)                
                pen = QPen()
                pen.setWidthF(0.0)
                pen.setJoinStyle(Qt.MiterJoin)
                item = QgsComposerLabel(composition)
                item.setFont(textFont)
                item.setText("Mapbook Id: " + unicode(self.tileName))
                item.adjustSizeToText()
                item.setBrush(brush) 
                item.setFrame(0)
                item.setMargin(0)
                item.setZValue(20)
                item.setItemPosition(margin_left+offset_x,  margin_top+offset_y)
                
                if self.printToFile == False:
                    composition.addComposerLabel(item)
                else:
                    composition.addItem(item)


            elif type == "tileindicator" and self.adjacentTiles <> None:
                textFont = QFont(decoration.getFontFamily(), decoration.getFontSize())
                if decoration.getFontWeight() == 3:
                    textFont.setBold(True)
                
                brush = QBrush()
                brush.setStyle(Qt.SolidPattern)  
                brush.setColor(Qt.white)                
                pen = QPen()
                pen.setWidthF(0.1)
                pen.setJoinStyle(Qt.MiterJoin)
                
                k = 0
                for i in range(3):
                    for j in range(3):
                        item = QgsComposerLabel(composition)
                        item.setFont(textFont)
                        item.setText(unicode(self.adjacentTiles[k]))

                        if decoration.getWidth() > 0 and decoration.getHeight() > 0:
                            item.setRect(0, 0, decoration.getWidth(),  decoration.getHeight())
                            item.setPen(pen)       
                            if k == 4:
                                brush.setColor(Qt.lightGray)
                            else: 
                                brush.setColor(Qt.white)
                            item.setBrush(brush)    
                            item.setZValue(20)
                            
                            if decoration.getAffinityX() == "right":
                                tile_offset_x = offset_x - 3 * decoration.getWidth()

                            if decoration.getAffinityY() == "bottom":
                                tile_offset_y = offset_y - 2 * decoration.getHeight()   
                                
                            item.setItemPosition(margin_left+tile_offset_x+j*decoration.getWidth(),  margin_top+tile_offset_y+(2-i)*decoration.getHeight())
              
                            if self.printToFile == False:
                                composition.addComposerLabel(item)
                            else:
                                composition.addItem(item)
                            
                        k = k +1
                        
                # No Python binding.... :(
#                item.setHAlign(Qt.AlignHCenter)
#                item.setVAlign(Qt.AlignVCenter)

        if self.printToFile == True:

            if self.printer == None:
                self.printer = QPrinter()
                self.printer.setOutputFormat(QPrinter.PdfFormat)
##                fileName = self.exportPath + os.sep + "easyprint_mapbook_" + str(self.tileName).replace(".", "_") + ".pdf"
#                fileName = self.exportPath + os.sep + "easyprint_mapbook_single_file.pdf"                
                self.printer.setOutputFileName(self.fileName)
                
            self.printer.newPage()
            self.printer.setPaperSize(QSizeF(composition.paperWidth(), composition.paperHeight()), QPrinter.Millimeter)
            self.printer.setFullPage(True)
            self.printer.setColorMode(QPrinter.Color)
            self.printer.setResolution(composition.printResolution())

            if self.painter == None:
#            painter = QPainter(self.printer)
                self.painter = QPainter(self.printer)
            
            paperRectMM = self.printer.pageRect(QPrinter.Millimeter)
            paperRectPixel = self.printer.pageRect(QPrinter.DevicePixel)
            
            if self.printAsRaster == True:
                dpi = composition.printResolution()
                dpmm = dpi / 25.4
                width = int(dpmm * composition.paperWidth())
                height = int(dpmm * composition.paperHeight())

                image = QImage(QSize(width, height), QImage.Format_ARGB32)
                image.setDotsPerMeterX(dpmm * 1000)
                image.setDotsPerMeterY(dpmm * 1000)
                image.fill(0)

                imagePainter = QPainter(image)
                sourceArea = QRectF(0, 0, composition.paperWidth(), composition.paperHeight())
                targetArea = QRectF(0, 0, width, height)
                composition.render(imagePainter, targetArea, sourceArea)
                imagePainter.end()
                self.painter.drawImage(paperRectPixel, image, QRectF(0, 0, image.width(), image.height()))
                
            else:
                composition.render(self.painter, paperRectPixel, paperRectMM)

#            self.painter.end()
            
            return self.printer, self.painter
            
            
        else:
            composerView.setComposition(composition)
            composer = composerView.composerWindow()    
            composer.show()        


    def getMapExtentFromFeatureExtent(self, mapWidth, mapHeight, featExtent):
        featWidth = featExtent.width()
        featHeight = featExtent.height()
        
        print mapWidth/mapHeight
        print featExtent.width()/featExtent.height()
        
        if (mapWidth/mapHeight) > (featWidth/featHeight):
            center = featExtent.center()
            xcenter = center.x()
            ycenter = center.y()
            
            minx = xcenter - (featHeight/(mapHeight/mapWidth)) / 2
            maxx = xcenter + (featHeight/(mapHeight/mapWidth)) / 2
            
            return QgsRectangle(minx,  featExtent.yMinimum(),  maxx,  featExtent.yMaximum())
            
        elif (mapWidth/mapHeight) < (featWidth/featHeight):
            center = featExtent.center()
            xcenter = center.x()
            ycenter = center.y()
            
            miny = ycenter - (featWidth/(mapWidth/mapHeight)) / 2
            maxy = ycenter + (featWidth/(mapWidth/mapHeight)) / 2     
            
            return QgsRectangle(featExtent.xMinimum(),  miny,  featExtent.xMaximum(),  maxy)

        else:
            return featExtent

    
    def getMapExtentFromPoint(self, mapWidth, mapHeight, scale, point):
        center = point
        xcenter = center.x()
        ycenter = center.y()
        
        mapWidth = mapWidth * scale / 1000
        mapHeight = mapHeight * scale / 1000        
        
        minx = xcenter - mapWidth / 2
        miny = ycenter - mapHeight / 2
        maxx = xcenter + mapWidth / 2
        maxy = ycenter + mapHeight / 2 
        
        return QgsRectangle(minx,  miny,  maxx,  maxy)


    def getMapExtentFromMapCanvas(self,  mapWidth,  mapHeight,  scale):
        print "in methode: " + str(scale)
        
        xmin = self.canvas.extent().xMinimum()
        xmax = self.canvas.extent().xMaximum()
        ymin = self.canvas.extent().yMinimum()
        ymax = self.canvas.extent().yMaximum()
        xcenter = xmin + (xmax - xmin) / 2
        ycenter = ymin + (ymax - ymin) / 2 
 
        mapWidth = mapWidth * scale / 1000
        mapHeight = mapHeight * scale / 1000
        minx = xcenter - mapWidth / 2
        miny = ycenter - mapHeight / 2
        maxx = xcenter + mapWidth / 2
        maxy = ycenter + mapHeight / 2 
        
        return QgsRectangle(minx,  miny,  maxx,  maxy)
        
        
    def getGridInterval(self,  scale):
        ## Masstab dividiert durch 10 und runden auf die naechste Zahl
        ## der gleichen Potenz:
        ## 1:1821 -> 182.1 -> 200
        ## 1:123 -> 12.3 -> 10
        power = math.floor(math.log10(scale))
        interval = int( round((scale/10)/(pow(10, power-1)))*(pow(10, power-1)) )
        return interval
            

    def cuttingLines(self, composition):
        offset = 0.1
        lineLength = 10
        paperHeight = composition.paperHeight()
        paperWidth = composition. paperWidth()
        
        ## top,left
        item = QgsComposerShape(0,  0,  lineLength,  0,  composition)
        item.setShapeType(1)
        item.setLineWidth(0.0)  
        pen = QPen()
        pen.setWidthF(0.05)
        pen.setJoinStyle(Qt.MiterJoin)
        item.setPen(pen)
        item.setPositionLock(1)         
        if self.printToFile == False:
            composition.addComposerShape(item)
        else:
            composition.addItem(item)
        
        item = QgsComposerShape(0,  0,  0,  lineLength,  composition)
        item.setShapeType(1)
        item.setLineWidth(0.0)  
        pen = QPen()
        pen.setWidthF(0.05)
        pen.setJoinStyle(Qt.MiterJoin)
        item.setPen(pen)
        item.setPositionLock(1)         
        if self.printToFile == False:
            composition.addComposerShape(item)
        else:
            composition.addItem(item)
        
        ## top,right
        item = QgsComposerShape(paperWidth-lineLength,  0,  lineLength,  0,  composition)
        item.setShapeType(1)
        item.setLineWidth(0.0)
        pen = QPen()
        pen.setWidthF(0.05)
        pen.setJoinStyle(Qt.MiterJoin)
        item.setPen(pen)
        item.setPositionLock(1)         
        if self.printToFile == False:
            composition.addComposerShape(item)
        else:
            composition.addItem(item)
        
        item = QgsComposerShape(paperWidth-offset,  0,  0,  lineLength,  composition)
        item.setShapeType(1)
        item.setLineWidth(0.0) 
        pen = QPen()
        pen.setWidthF(0.05)
        pen.setJoinStyle(Qt.MiterJoin)
        item.setPen(pen)
        item.setPositionLock(1)         
        if self.printToFile == False:
            composition.addComposerShape(item)
        else:
            composition.addItem(item)
        
        ## bottom,right
        item = QgsComposerShape(paperWidth-lineLength,  paperHeight-offset,  lineLength,  0, composition)
        item.setShapeType(1)
        item.setLineWidth(0.0) 
        pen = QPen()
        pen.setWidthF(0.05)
        pen.setJoinStyle(Qt.MiterJoin)
        item.setPen(pen)
        item.setPositionLock(1)         
        if self.printToFile == False:
            composition.addComposerShape(item)
        else:
            composition.addItem(item)
      
        item = QgsComposerShape(paperWidth-offset,  paperHeight-lineLength,  0,  lineLength,  composition)
        item.setShapeType(1)
        item.setLineWidth(0.0) 
        pen = QPen()
        pen.setWidthF(0.05)
        pen.setJoinStyle(Qt.MiterJoin)
        item.setPen(pen)
        item.setPositionLock(1)         
        if self.printToFile == False:
            composition.addComposerShape(item)
        else:
            composition.addItem(item)
        
        ## bottom,left
        item = QgsComposerShape(0,  paperHeight-offset,  lineLength,  0, composition)
        item.setShapeType(1)
        item.setLineWidth(0.0) 
        pen = QPen()
        pen.setWidthF(0.05)
        pen.setJoinStyle(Qt.MiterJoin)
        item.setPen(pen)
        item.setPositionLock(1)         
        if self.printToFile == False:
            composition.addComposerShape(item)
        else:
            composition.addItem(item)
        
        item = QgsComposerShape(0,  paperHeight-lineLength,  0,  lineLength,  composition)
        item.setShapeType(1)
        item.setLineWidth(0.0)
        pen = QPen()
        pen.setWidthF(0.05)
        pen.setJoinStyle(Qt.MiterJoin)
        item.setPen(pen)
        item.setPositionLock(1)         
        if self.printToFile == False:
            composition.addComposerShape(item)
        else:
            composition.addItem(item)


    def foldingMarks(self, composition):
        markWidth = 210
        markHeight = 297
        lineLength = 4
        paperHeight = composition.paperHeight()
        paperWidth = composition. paperWidth()
        
        if paperWidth / markWidth > 1:
            count = int(round(paperWidth/markWidth, 0))
            for i in range(1, count):
                item = QgsComposerShape(i * markWidth, 0,  0, lineLength, composition)
                item.setShapeType(1)
                item.setLineWidth(0.0) 
                pen = QPen()
                pen.setWidthF(0.05)
                pen.setJoinStyle(Qt.MiterJoin)
                item.setPen(pen)
                item.setPositionLock(1)         
                if self.printToFile == False:
                    composition.addComposerShape(item)
                else:
                    composition.addItem(item)
                
                item = QgsComposerShape(i * markWidth,  paperHeight - lineLength,   0, lineLength,  composition)
                item.setShapeType(1)
                item.setLineWidth(0.0) 
                pen = QPen()
                pen.setWidthF(0.05)
                pen.setJoinStyle(Qt.MiterJoin)
                item.setPen(pen)
                item.setPositionLock(1)         
                if self.printToFile == False:
                    composition.addComposerShape(item)
                else:
                    composition.addItem(item)
           
        if paperHeight  / markHeight > 1:
            count = int(round(paperHeight/markHeight, 0))
            if count == 1:
                count = count + 1

            for i in range(1, count):
                item = QgsComposerShape(0, i * markHeight, lineLength, 0,  composition)
                item.setShapeType(1)
                item.setLineWidth(0.0)  
                pen = QPen()
                pen.setWidthF(0.05)
                pen.setJoinStyle(Qt.MiterJoin)
                item.setPen(pen)
                item.setPositionLock(1)         
                if self.printToFile == False:
                    composition.addComposerShape(item)
                else:
                    composition.addItem(item)
                
                item = QgsComposerShape(paperWidth-lineLength, i * markHeight, lineLength, 0,  composition)
                item.setShapeType(1)
                item.setLineWidth(0.0)  
                pen = QPen()
                pen.setWidthF(0.05)
                pen.setJoinStyle(Qt.MiterJoin)
                item.setPen(pen)
                item.setPositionLock(1)         
                if self.printToFile == False:
                    composition.addComposerShape(item)
                else:
                    composition.addItem(item)

