 # -*- coding: utf8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
import utils, math, time, os

from doCreateSimpleMap import CreateSimpleMap

class CreateMapBookByFeature( QObject ):
    
    def __init__( self, iface, printScale, printFormat, layoutIndex, titleString, subtitleString, personString, crsdesc, grid, legend, copyright, cuttinglines, foldingmarks, printAsRaster, overlapPercentage, exportPath, mapLayer, titleAttr, subtitleAttr, scaleAttr, rotationAttr, defaultScale, defaultRotation, overviewMap=False, printSingleFile=False ):
        self.iface = iface
        self.canvas = self.iface.mapCanvas()
        self.printScale = float(printScale[3:])
        self.printFormat = printFormat
        self.layoutIndex = layoutIndex
        self.titleString = titleString
        self.subtitleString = subtitleString
        self.personString = personString
        self.crsdesc = crsdesc
        self.grid = grid
        self.legend = legend
        self.copyright = copyright
        self.cuttinglines = cuttinglines
        self.foldingmarks = foldingmarks
        self.printAsRaster = printAsRaster
        self.overlapPercentage = overlapPercentage
        self.exportPath = exportPath
        self.mapLayer = mapLayer
        self.titleAttr = titleAttr
        self.subtitleAttr = subtitleAttr
        self.scaleAttr = scaleAttr
        self.rotationAttr = rotationAttr
        self.defaultScale = defaultScale
        self.defaultRotation = defaultRotation
        self.overviewMap = overviewMap
        self.printSingleFile = printSingleFile
        
        
    def run(self):
        
        if self.overviewMap == True:
            memlayer = QgsVectorLayer("Polygon", u"Mapbook feature grid", "memory")
            qml = QDir.convertSeparators(QDir.cleanPath(QgsApplication.qgisSettingsDirPath() + '/python/plugins/easyprint/styles/regular_grid.qml'))
            memlayer.loadNamedStyle(qml)            
            memprovider = memlayer.dataProvider()
            memprovider.addAttributes( [ QgsField("name", QVariant.String)] )
            memlayer.updateFieldMap()
            memlayer.setCrs( self.canvas.mapRenderer().destinationCrs() )                
        
        vlayer = utils.getVectorLayerByName(self.mapLayer)
        if vlayer == None:
            QMessageBox.warning( None, "", "Layer not found: " + self.mapLayer)
            return      

        provider = vlayer.dataProvider()
        feat = QgsFeature()
        allAttrs = provider.attributeIndexes()
        provider.select(allAttrs)

        titleIndex = provider.fieldNameIndex(self.titleAttr)
        subtitleIndex = provider.fieldNameIndex(self.subtitleAttr)
        scaleIndex = provider.fieldNameIndex(self.scaleAttr)
        rotationIndex = provider.fieldNameIndex(self.rotationAttr)

        mapExtents = []
        featIDs = []
        titleStrings = []
        subtitleStrings = []
        printScales = []
        printRotations = []
        
        while provider.nextFeature(feat):
        
            geom = feat.geometry()
            mapExtent = geom.boundingBox()
            mapExtents.append(mapExtent)
            
            featID = feat.id()
            featIDs.append(featID)

            if titleIndex >= 0:
                titleStrings.append(feat.attributeMap()[titleIndex].toString())
            else:
                titleStrings.append(self.titleString)
            
            if subtitleIndex >= 0:
                subtitleStrings.append(feat.attributeMap()[subtitleIndex].toString())
            else:
                subtitleStrings.append(self.subtitleString)

            if scaleIndex >= 0:
                scale = feat.attributeMap()[scaleIndex].toString()
                                
                if scale == "" or scale == None:
                    printScales.append(self.defaultScale)
                else:
                    printScales.append(scale)
            else:
                printScales.append(self.defaultScale)
                
            if rotationIndex >= 0:
                rot = feat.attributeMap()[rotationIndex].toString()
                if rot == "" or rot == None:
                    printRotations.append(self.defaultRotation)
                else:
                    printRotations.append(rot)
            else:
                printRotations.append(self.defaultRotation)

        QApplication.setOverrideCursor(Qt.WaitCursor)       
        try:    
            
            printer = None
            painter = None
            
            for i in range(len(mapExtents)):
                simpleMap = CreateSimpleMap(self.iface, printScales[i], self.printFormat, self.layoutIndex, titleStrings[i], subtitleStrings[i], self.personString, self.crsdesc, self.grid, self.legend, self.copyright, self.cuttinglines, self.foldingmarks, self.printAsRaster, mapExtents[i], self.overlapPercentage, False, None, self.exportPath, True, featIDs[i], printRotations[i])
                fileName = self.exportPath + os.sep + "easyprint_mapbook_" + str(featIDs[i]) + ".pdf" 
                
                if self.printSingleFile == True:
                    simpleMap.setPrinterPainter(printer, painter)
                    fileName = self.exportPath + os.sep + "easyprint_mapbook_single_file.pdf"                

                simpleMap.setOutputFileName(fileName)
                printer, painter = simpleMap.run()
                
                if self.printSingleFile == False:
                    painter.end()
                
                if self.overviewMap == True:
                    rect = simpleMap.getMapExtent()
                    name = featIDs[i]
                    
                    f = QgsFeature()
                    f.setGeometry(QgsGeometry.fromRect(rect))
                    f.setAttributeMap( { 0 : QVariant(str(name)) } )
                    memprovider.addFeatures( [ f ] )
                    
            if self.overviewMap == True:
                QgsMapLayerRegistry().instance().addMapLayer(memlayer, True)                           
                memlayer.updateExtents()      
                self.iface.legendInterface().setLayerVisible(memlayer,  True)      
                self.iface.mapCanvas().refresh()    
                
                mapExtent = memlayer.extent()
                simpleMap = CreateSimpleMap(self.iface, self.printScale, self.printFormat, self.layoutIndex, self.titleString, self.subtitleString, self.personString, self.crsdesc,  self.grid, self.legend, self.copyright, self.cuttinglines, self.foldingmarks, self.printAsRaster, mapExtent, self.overlapPercentage, self.overviewMap, None, self.exportPath, True, "overview")
                fileName = self.exportPath + os.sep + "easyprint_mapbook_" + "overview" + ".pdf" 

                if self.printSingleFile == True:
                    simpleMap.setPrinterPainter(printer, painter)
               
                simpleMap.setOutputFileName(fileName)           
                printer, painter = simpleMap.run()

            painter.end()

        except:
            painter.end()
            QApplication.restoreOverrideCursor()
        QApplication.restoreOverrideCursor()
          

