 # -*- coding: utf8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
import utils, math, time, os

from doCreateSimpleMap import CreateSimpleMap

class CreateMapBookByGrid( QObject ):
    
    def __init__( self, iface, printScale, printFormat, layoutIndex, titleString, subtitleString, personString, crsdesc, grid, legend, copyright, cuttinglines, foldingmarks, printAsRaster, gridType, overlapPercentage, overviewMap, tileIndicator, exportPath, shadedCells, printSingleFile ):
        self.iface = iface
        self.canvas = self.iface.mapCanvas()
        self.printScale = float(printScale[3:])
        self.printFormat = printFormat
        self.layoutIndex = layoutIndex
        self.titleString = titleString
        self.subtitleString = subtitleString
        self.personString = personString
        self.crsdesc = crsdesc
        self.grid = grid
        self.legend = legend
        self.copyright = copyright
        self.cuttinglines = cuttinglines
        self.foldingmarks = foldingmarks
        self.printAsRaster = printAsRaster
        self.gridType = gridType
        self.overlapPercentage = overlapPercentage
        self.overviewMap = overviewMap
        self.tileIndicator = tileIndicator        
        self.exportPath = exportPath
        self.shadedCells = shadedCells
        self.printSingleFile = printSingleFile
            
        self.index = None
                
    def run( self ):        
        gridLayer = utils.getVectorLayerByName("Mapbook grid")
        if gridLayer == None:
            QMessageBox.warning( None, "", "No mapbook grid layer found.")
            return                
        if gridLayer.geometryType() <> QGis.Polygon:
            QMessageBox.warning( None, "", "'Mapbook grid' is not a polygon layer.")
            return                
        
        if self.tileIndicator == True:
            self.createSpatialIndex(gridLayer)
        
        # Create the maps by iterating over the features 
        # of the mapbook grid layer.
        # Weird: something in CreateSimpleMap kills the while loop....
        # -> put extents and tilenames into arrays.        
        provider = gridLayer.dataProvider()
        feat = QgsFeature()
        allAttrs = provider.attributeIndexes()
        provider.select(allAttrs)
        
        if self.shadedCells == True and gridLayer.isUsingRendererV2():
            rendererV2 = gridLayer.rendererV2()
            props = { 'color' : '125,125,125',  'style_border' : '0', 'width_border' : '0' }
            s = QgsFillSymbolV2.createSimple( props )
            s.setAlpha(0.33)
            rule = QgsRuleBasedRendererV2.Rule( s  )        
            
        tileNameIndex = provider.fieldNameIndex("name")
        rotationIndex = provider.fieldNameIndex("rotation")        
        printFormatIndex = provider.fieldNameIndex("printformat")
        printScaleIndex = provider.fieldNameIndex("printscale")
        layoutIndexIndex = provider.fieldNameIndex("layoutIndex")
        overlapPercentageIndex = provider.fieldNameIndex("overlap")
    
        tileNames = []
        mapExtents = []
        adjacentTiles = []
        while provider.nextFeature(feat):
            
            tileNames.append(str(feat.attributeMap()[tileNameIndex].toString()))
        
            geom = feat.geometry()
            mapExtents.append(geom.boundingBox())
            
            if printFormatIndex >= 0:
                self.printFormat = feat.attributeMap()[printFormatIndex].toString()
                
            if printScaleIndex >= 0:
                self.printScale = feat.attributeMap()[printScaleIndex].toString()
                
            if layoutIndexIndex >= 0:
                self.layoutIndex = int(feat.attributeMap()[layoutIndexIndex].toString())
                
            if overlapPercentageIndex >= 0:
                self.overlapPercentage = feat.attributeMap()[overlapPercentageIndex].toString()                 
            
            if self.tileIndicator == True:
                adjacentTiles.append(self.getAdjacentTiles(gridLayer, geom.boundingBox()))
            else:
                adjacentTiles.append(None)
  
        QApplication.setOverrideCursor(Qt.WaitCursor)       
        try:    

            printer = None
            painter = None

            for i in range(len(mapExtents)):
               
                if self.shadedCells == True and gridLayer.isUsingRendererV2():
                    if rendererV2.type() == 'RuleRenderer':
                        rule.setFilterExpression("name != '" + tileNames[i] + "'")
                        rendererV2.addRule(rule)
                        self.iface.legendInterface().refreshLayerSymbology(gridLayer)      
                        self.iface.mapCanvas().refresh()   
                
                simpleMap = CreateSimpleMap(self.iface, self.printScale, self.printFormat, self.layoutIndex, self.titleString, self.subtitleString, self.personString, self.crsdesc, self.grid, self.legend, self.copyright, self.cuttinglines, self.foldingmarks, self.printAsRaster, mapExtents[i], self.overlapPercentage, self.overviewMap, adjacentTiles[i], self.exportPath, True, tileNames[i])
                fileName = self.exportPath + os.sep + "easyprint_mapbook_" + str(tileNames[i]).replace(".", "_") + ".pdf" 
                
                if self.printSingleFile == True:
                    simpleMap.setPrinterPainter(printer, painter)
                    fileName = self.exportPath + os.sep + "easyprint_mapbook_single_file.pdf"                

                simpleMap.setOutputFileName(fileName)
                printer, painter = simpleMap.run()
                
                if self.printSingleFile == False:
                    painter.end()
                
                if self.shadedCells == True and gridLayer.isUsingRendererV2():
                    if rendererV2.type() == 'RuleRenderer':                
                        rendererV2.removeRuleAt(rendererV2.ruleCount()-1)
                        self.iface.legendInterface().refreshLayerSymbology(gridLayer)      
                        self.iface.mapCanvas().refresh()   


            if self.overviewMap == True:
                mapExtent = gridLayer.extent()
                simpleMap = CreateSimpleMap(self.iface, self.printScale, self.printFormat, self.layoutIndex, self.titleString, self.subtitleString, self.personString, self.crsdesc,  self.grid, self.legend, self.copyright, self.cuttinglines, self.foldingmarks, self.printAsRaster, mapExtent, self.overlapPercentage, self.overviewMap, None, self.exportPath, True, "overview")
                fileName = self.exportPath + os.sep + "easyprint_mapbook_" + "overview" + ".pdf" 

                if self.printSingleFile == True:
                    simpleMap.setPrinterPainter(printer, painter)
               
                simpleMap.setOutputFileName(fileName)           
                printer, painter = simpleMap.run()

            painter.end()

        except:
            print "mapbook by grid error"
            painter.end()
            QApplication.restoreOverrideCursor()
            
        QApplication.restoreOverrideCursor()


  
 

    def getAdjacentTiles(self, gridLayer, rect):
        tileNameIndex = self.provider.fieldNameIndex("name")
        
        tiles = ["", "", "", "", "", "", "", "", ""]
        
        # We need to enlarge the rect a bit to 
        # get all the neighbouring rects.
        scaledRect = QgsRectangle(rect)
        scaledRect.scale(1.01)
        intersect = self.index.intersects(scaledRect)
        
        for i in intersect:
            feat = QgsFeature()
            self.provider.featureAtId(i, feat)
            
            tileRect = feat.geometry().boundingBox()
            
            diffX = tileRect.xMinimum() < rect.xMinimum()
            diffY = tileRect.yMinimum() < rect.yMinimum()
            
#            print "intersect name:" + feat.attributeMap()[tileNameIndex].toString()
                        
            if tileRect.xMinimum() < rect.xMinimum() and tileRect.yMinimum() < rect.yMinimum():
                tiles[0] = feat.attributeMap()[tileNameIndex].toString()

            if tileRect.xMinimum() == rect.xMinimum() and tileRect.yMinimum() < rect.yMinimum():
                tiles[1] = feat.attributeMap()[tileNameIndex].toString()
                
            if tileRect.xMinimum() > rect.xMinimum() and tileRect.yMinimum() < rect.yMinimum():
                tiles[2] = feat.attributeMap()[tileNameIndex].toString()             
             
            if tileRect.xMinimum() < rect.xMinimum() and tileRect.yMinimum() == rect.yMinimum():
                tiles[3] = feat.attributeMap()[tileNameIndex].toString()
                
            if tileRect.xMinimum() == rect.xMinimum() and tileRect.yMinimum() == rect.yMinimum():
                tiles[4] = feat.attributeMap()[tileNameIndex].toString()  
  
            if tileRect.xMinimum() > rect.xMinimum() and tileRect.yMinimum() == rect.yMinimum():
                tiles[5] = feat.attributeMap()[tileNameIndex].toString()  
           
            if tileRect.xMinimum() < rect.xMinimum() and tileRect.yMinimum() > rect.yMinimum():
                tiles[6] = feat.attributeMap()[tileNameIndex].toString()                 
                
            if tileRect.xMinimum() == rect.xMinimum() and tileRect.yMinimum() > rect.yMinimum():
                tiles[7] = feat.attributeMap()[tileNameIndex].toString()                    

            if tileRect.xMinimum() > rect.xMinimum() and tileRect.yMinimum() > rect.yMinimum():
                tiles[8] = feat.attributeMap()[tileNameIndex].toString()      
        
#        print tiles
        return tiles
        

    def createSpatialIndex( self, layer ):
        if layer == None or layer.type() <> 0:
            return
            
        self.provider = layer.dataProvider()
        self.provider.select([])
        feat = QgsFeature()
                
        if self.index == None:
            self.index = QgsSpatialIndex()
            while self.provider.nextFeature(feat):
                self.index.insertFeature(feat)

