# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from Ui_easyprint import Ui_EasyPrint
import os, sys
import tools.utils


class EasyPrintGui(QDialog, Ui_EasyPrint):
  
    def __init__(self, parent):
        QDialog.__init__(self, parent)
        self.setupUi(self)
        
        self.okButton = self.buttonBox.button(QDialogButtonBox.Ok)
        self.connect(self.okButton, SIGNAL("accepted()"), self.accept)

        self.settings = QSettings("CatAIS","easyprint")
        self.mbexportpath.setText( self.settings.value("mb/gui/exportpath").toString() ) 
        self.mbfexportpath.setText( self.settings.value("mb/gui/exportpathfeature").toString() ) 

    def initGui(self, scales, paperformats, layouts, maplayers, vectorlayers):
        
        ## SimpleMap ##
        ## Set some stuff for the user scale spin box.
        self.userScale.setMinimum(1)
        self.userScale.setMaximum(100000000)
        self.userScale.setPrefix("1 : ")
        try:
            self.userScale.setValue(int(scales[0]))
        except TypeError:
            self.userScale.setValue(100000000)
        
        ## Fill the combobox with available scales.
        for scale in scales:
            self.printScale.addItem("1 : "+scale)
        
        ## Fill the combobox with available paperformats.
        self.printFormat.addItems(paperformats)
        
        ## Fill the combobox with available layouts.
        for l in layouts:
            self.layout.addItem(l.getID())        
       
        self.person.setText( self.settings.value("gui/person").toString() )
        self.grids.setChecked( self.settings.value("gui/grids", True).toBool() )
        self.legend.setChecked( self.settings.value("gui/legend", True).toBool() )  
        self.copyright.setChecked( self.settings.value("gui/copyright", False).toBool() )
        self.cuttinglines.setChecked( self.settings.value("gui/cuttinglines", False).toBool() )
        self.foldingmarks.setChecked( self.settings.value("gui/foldingmarks", False).toBool() )
        self.crsdesc.setChecked( self.settings.value("gui/crsdescription", False).toBool() )
        
        ## Mapbook Grid ##
        self.mbgridtype.insertItem( 0,  QCoreApplication.translate("EasyPrint", "Regular grid" ),  QVariant( 1 ) )
        self.mbgridtype.insertItem( 1,  QCoreApplication.translate("EasyPrint", "Regular grid (w/o empty grids)" ),  QVariant( 2 ) )
#        self.mbgridtype.insertItem( 2,  QCoreApplication.translate("EasyPrint", "Linear path" ),  QVariant( 3 ) )        
        self.mbgridtype.insertItem( 0,  "--------------------", -1 )
        self.mbgridtype.setCurrentIndex(0)
        
        self.mbmaplayer.addItems(sorted(maplayers))        

        ## Mapbook Feature ##
        self.mbfmaplayer.addItems(sorted(vectorlayers))
        
        
    @pyqtSignature("on_mbfmaplayer_currentIndexChanged(QString)")      
    def on_mbfmaplayer_currentIndexChanged(self):    
        vlayer = tools.utils.getVectorLayerByName(self.mbfmaplayer.currentText())
        
        if vlayer == None:
            return
            
        numberList = []
        stringList = []
        
        provider = vlayer.dataProvider()
        fields = provider.fields()
        
        for i in fields:
            fieldType = fields[i].type()
            if fieldType == 6 or fieldType == 2:
                numberList.append(fields[i].name())
            elif fieldType == 10:
                stringList.append(fields[i].name())
        
        self.mbftitle.clear()
        self.mbftitle.addItems(sorted(stringList))
        self.mbftitle.insertItem( 0,  "--------------------" )
        self.mbftitle.setCurrentIndex(0)        

        self.mbfsubtitle.clear()
        self.mbfsubtitle.addItems(sorted(stringList))
        self.mbfsubtitle.insertItem( 0,  "--------------------" )
        self.mbfsubtitle.setCurrentIndex(0)        

        self.mbfscale.clear()
        self.mbfscale.addItems(sorted(numberList))
        self.mbfscale.insertItem( 0,  "--------------------" )
        self.mbfscale.setCurrentIndex(0)        

        self.mbfrotation.clear()
        self.mbfrotation.addItems(sorted(numberList))
        self.mbfrotation.insertItem( 0,  "--------------------" )
        self.mbfrotation.setCurrentIndex(0)        


    @pyqtSignature("on_printScale_currentIndexChanged(QString)")      
    def on_printScale_currentIndexChanged(self):    
        currentIndex = self.printScale.currentIndex()
        if currentIndex == 1:
            self.userScale.setEnabled(True)
        else:
            self.userScale.setEnabled(False)


    @pyqtSignature("on_btnMbGrid_clicked()")    
    def on_btnMbGrid_clicked(self):
        if self.mbmaplayer.currentText() == "":
            QMessageBox.warning( None, "", "No reference map layer selected.")
            return
            
        currentIndex = self.printScale.currentIndex()
        if currentIndex == 1:
            self.scale = "1 : " + str(self.userScale.value())
        else:
            self.scale = self.printScale.currentText()            
            
        if self.mbgridtype.currentIndex() <> 0:
            self.emit(SIGNAL("mbGridClicked(int, QString, QString, int, QString, double)"), self.mbgridtype.itemData( self.mbgridtype.currentIndex() ).toInt()[0], self.scale, self.printFormat.currentText(), int(self.layout.currentIndex()), self.mbmaplayer.currentText(), self.mboverlap.value() )        


    @pyqtSignature("on_btnBrowseExport_clicked()")    
    def on_btnBrowseExport_clicked(self):
        dir= QFileDialog.getExistingDirectory(self, "Choose export directory", self.mbexportpath.text())
        dirInfo = QFileInfo(dir)
        self.mbexportpath.setText(QString(dirInfo.absoluteFilePath()))
        
        
    @pyqtSignature("on_btnBrowseExportFeature_clicked()")    
    def on_btnBrowseExportFeature_clicked(self):
        dir= QFileDialog.getExistingDirectory(self, "Choose export directory", self.mbfexportpath.text())
        dirInfo = QFileInfo(dir)
        self.mbfexportpath.setText(QString(dirInfo.absoluteFilePath()))


        
    def accept(self):
        self.settings.setValue( "gui/person", QVariant( self.person.text() ) ) 
        self.settings.setValue( "gui/grids", QVariant( self.grids.isChecked() ) )
        self.settings.setValue( "gui/legend", QVariant( self.legend.isChecked() ) )
        self.settings.setValue( "gui/copyright", QVariant( self.copyright.isChecked() ) )
        self.settings.setValue( "gui/cuttinglines", QVariant( self.cuttinglines.isChecked() ) )
        self.settings.setValue( "gui/foldingmarks", QVariant( self.foldingmarks.isChecked() ) )
        self.settings.setValue( "gui/crsdescription", QVariant( self.crsdesc.isChecked() ) )
        
        self.settings.setValue( "mb/gui/overlappercentage", QVariant( self.mboverlap.value()) )
        self.settings.setValue( "mb/gui/overviewmap", QVariant( self.mboverviewmap.isChecked() ) )  
        self.settings.setValue( "mb/gui/tileindicator", QVariant( self.mbtileindicator.isChecked() ) ) 
        self.settings.setValue( "mb/gui/printasraster", QVariant( self.mbprintasraster.isChecked() ) ) 
        self.settings.setValue( "mb/gui/shadedcells", QVariant( self.mbshadedcells.isChecked() ) )         
        self.settings.setValue( "mb/gui/exportpath", QVariant(self.mbexportpath.text() ) )        
        self.settings.setValue( "mb/gui/exportpathfeature", QVariant(self.mbfexportpath.text() ) )        
        
        currentIndex = self.printScale.currentIndex()
        if currentIndex == 1:
            self.scale = "1 : " + str(self.userScale.value())
        else:
            self.scale = self.printScale.currentText()            
        
        print "scale"
        print self.scale        
        
        tabIndex = self.tabWidget.currentIndex()
        if tabIndex == 0:
            self.emit( SIGNAL("okClickedSimpleMap(QString, QString, QString, QString, QString, bool, bool, bool, bool, bool, bool, int)"), self.scale,  self.printFormat.currentText(),  self.title.text(), self.subtitle.text(), self.person.text(), self.crsdesc.isChecked(), self.grids.isChecked(), self.legend.isChecked(), self.copyright.isChecked(),  self.cuttinglines.isChecked(), self.foldingmarks.isChecked(),   int(self.layout.currentIndex()) )
        
        elif tabIndex == 1:
            if self.mbexportpath.text() == "":
                QMessageBox.warning( None, "", "No export directory selected.")
                return                
            self.emit( SIGNAL("okClickedMapBook(QString, QString, QString, QString, QString, bool, bool, bool, bool, bool, bool, int,  bool, int, double, bool, bool, QString, bool, bool)"), self.scale,  self.printFormat.currentText(),  self.title.text(), self.subtitle.text(), self.person.text(), self.crsdesc.isChecked(), self.grids.isChecked(), self.legend.isChecked(), self.copyright.isChecked(),  self.cuttinglines.isChecked(), self.foldingmarks.isChecked(), int(self.layout.currentIndex()), self.mbprintasraster.isChecked(), self.mbgridtype.itemData( self.mbgridtype.currentIndex() ).toInt()[0], self.mboverlap.value(), self.mboverviewmap.isChecked(), self.mbtileindicator.isChecked(), self.mbexportpath.text(), self.mbshadedcells.isChecked(), self.mbprintsinglefile.isChecked() )
        
        elif tabIndex == 2:
            if self.mbfexportpath.text() == "":
                QMessageBox.warning( None, "", "No export directory selected.")
                return      
            self.emit( SIGNAL("okClickedMapBookFeature(QString, QString, QString, QString, QString, bool, bool, bool, bool, bool, bool, int, bool, double, QString, QString, QString, QString, QString, QString, double, double, bool, bool)"), self.scale,  self.printFormat.currentText(),  self.title.text(), self.subtitle.text(), self.person.text(), self.crsdesc.isChecked(), self.grids.isChecked(), self.legend.isChecked(), self.copyright.isChecked(),  self.cuttinglines.isChecked(), self.foldingmarks.isChecked(), int(self.layout.currentIndex()), self.mbfprintasraster.isChecked(), self.mbfextraspace.value(), self.mbfexportpath.text(), self.mbfmaplayer.currentText(), self.mbftitle.currentText(),  self.mbfsubtitle.currentText(), self.mbfscale.currentText(), self.mbfrotation.currentText(), self.mbfdefaultscale.value(),  self.mbfdefaultrotation.value(), self.mbfoverviewmap.isChecked(), self.mbfprintsinglefile.isChecked() )

