# -*- coding: latin1 -*-
#---------------------------------------------------------------------
# 
# EasyPrint - A QGIS plugin to create maps.
#
# Copyright (C) 2010 Stefan Ziegler
#
# EMAIL: stefan.ziegler (at) bd.so.ch
# WEB  : www.catais.org
#
#---------------------------------------------------------------------
# 
# licensed under the terms of GNU GPL 2
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
# 
#---------------------------------------------------------------------

## Import the PyQt and the QGIS libraries.
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4 import QtXml
from qgis.core import *
from qgis.gui import *

from datetime import datetime, date, time
import os, sys, time, math, locale

import tools.utils

## Initialize Qt resources from file resources.py.
import resources

## Import the code for the dialog.
from easyprintgui import EasyPrintGui

## Import some other classes.
from tools.layout import Layout
from tools.decoration import Decoration


class EasyPrint: 
    def __init__(self, iface):
        ## Save reference to the QGIS interface.
        self.iface = iface
        self.canvas = iface.mapCanvas()
        
        self.scales = []
        self.paperformats = []
        
        ## Initialise the translation environment.
        userPluginPath = QFileInfo(QgsApplication.qgisUserDbFilePath()).path()+"/python/plugins/easyprint"  
        systemPluginPath = QgsApplication.prefixPath()+"/share/qgis/python/plugins/easyprint"
        locale = QSettings().value("locale/userLocale").toString()
        myLocale = locale[0:2]       
    
        if QFileInfo(userPluginPath).exists():
          pluginPath = userPluginPath+"/i18n/easyprint_"+myLocale+".qm"
        elif QFileInfo(systemPluginPath).exists():
          pluginPath = systemPluginPath+"/i18n/easyprint_"+myLocale+".qm"

        self.localePath = pluginPath
        if QFileInfo(self.localePath).exists():
          self.translator = QTranslator()
          self.translator.load(self.localePath)
          
          if qVersion() > '4.3.3':        
            QCoreApplication.installTranslator(self.translator)

        
    def initGui(self):  
        ## Create action that will start plugin configuration.    
        self.action = QAction(QIcon(":/plugins/easyprint/easyprint.png"), "Easy Print", self.iface.mainWindow())
        QObject.connect(self.action, SIGNAL("triggered()"), self.run) 

        ## Add toolbar button and menu item.
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&EasyPrint", self.action)
        
        
    def unload(self):
        ## Remove the plugin menu item and icon.
        self.iface.removePluginMenu("&EasyPrint",self.action)
        self.iface.removeToolBarIcon(self.action)        
        
    
    def run(self): 
        
        layouts = self.layouts()   

        scales = self.preferences("scale",  False)
        scales.insert(0, str(int(self.canvas.scale())))
        scales.insert(1,  QCoreApplication.translate("EasyPrint", "user defined"))

        paperformats = self.preferences("format",  True)
        
        maplayers = tools.utils.getLayerNames("all")
        vectorlayers = tools.utils.getLayerNames([0, 1, 2])

        self.dlg = EasyPrintGui(self.iface.mainWindow()) 
        self.dlg.initGui(scales, paperformats, layouts, maplayers, vectorlayers)
        
        self.dlg.show()        
        
        ## Connect to the signals.
        QObject.connect(self.dlg, SIGNAL("okClickedSimpleMap(QString, QString, QString, QString, QString, bool, bool, bool, bool, bool, bool, int)"), self.doSimpleMap)       
        QObject.connect(self.dlg, SIGNAL("mbGridClicked(int, QString, QString, int, QString, double)"), self.doMapBookGrid)
        QObject.connect(self.dlg, SIGNAL("okClickedMapBook(QString, QString, QString, QString, QString, bool, bool, bool, bool, bool, bool, int, bool, int, double, bool, bool, QString, bool, bool)"), self.doMapBookByGrid)       
        QObject.connect(self.dlg, SIGNAL("okClickedMapBookFeature(QString, QString, QString, QString, QString, bool, bool, bool, bool, bool, bool, int,  bool, double, QString, QString, QString, QString, QString, QString, double, double, bool, bool)"), self.doMapBookByFeature)

        
    def doMapBookByFeature( self, printScale, printFormat, titleString, subtitleString, personString, crsdesc, grid, legend, copyright, cuttinglines, foldingmarks, layoutIndex, printAsRaster, overlapPercentage, exportPath, mapLayer, titleAttr, subtitleAttr, scaleAttr, rotationAttr, defaultScale, defaultRotation, overviewMap, printSingleFile ):
        from tools.doCreateMapBookByFeature import CreateMapBookByFeature
        d = CreateMapBookByFeature(self.iface, printScale, printFormat, layoutIndex, titleString, subtitleString, personString, crsdesc, grid, legend, copyright, cuttinglines, foldingmarks, printAsRaster, overlapPercentage, exportPath, mapLayer, titleAttr, subtitleAttr, scaleAttr, rotationAttr, defaultScale, defaultRotation, overviewMap, printSingleFile)
        d.run()


    def doMapBookGrid( self, gridType, printScale, printFormat, layoutIndex, layerName, overlapPercentage ):
        from tools.doCreateMapBookGrid import CreateMapBookGrid
        d = CreateMapBookGrid(self.iface, gridType, printScale, printFormat, layoutIndex, layerName, overlapPercentage)
        d.run()        

        
    def doMapBookByGrid( self, printScale, printFormat, titleString, subtitleString, personString, crsdesc, grid, legend, copyright, cuttinglines, foldingmarks, layoutIndex, printAsRaster, gridType, overlapPercentage, overviewMap, tileIndicator, exportPath, shadedCells, printSingleFile ):
        from tools.doCreateMapBookByGrid import CreateMapBookByGrid
        d = CreateMapBookByGrid(self.iface, printScale, printFormat, layoutIndex, titleString, subtitleString, personString, crsdesc, grid, legend, copyright, cuttinglines, foldingmarks, printAsRaster, gridType, overlapPercentage, overviewMap, tileIndicator, exportPath, shadedCells, printSingleFile)
        d.run()
        
    
    def doSimpleMap(self, printScale, printFormat, titleString, subtitleString, personString, crsdesc, grid, legend, copyright, cuttinglines, foldingmarks, layoutIndex):
        from tools.doCreateSimpleMap import CreateSimpleMap
        d = CreateSimpleMap(self.iface, float(printScale[3:]), printFormat, layoutIndex, titleString, subtitleString, personString, crsdesc, grid, legend, copyright, cuttinglines, foldingmarks)
        d.run()     


## Papersize, Layout and Preferences ##
##Also, use here the functions from utils.tools...

    def papersize(self,  format):
        height = 297
        width = 210
        
        preffilename = QDir.convertSeparators(QDir.cleanPath(QgsApplication.qgisSettingsDirPath() + "/python/plugins/easyprint/preferences/preferences.xml"))
        preffile = open(preffilename,"r")
        prefxml = preffile.read()
        
        doc = QtXml.QDomDocument()
        doc.setContent(prefxml,  True)  
        
        root = doc.documentElement()
        if root.tagName() != "preferences":
            return
            
        n = root.firstChild()
        while not n.isNull():
            e = n.toElement()
            sube = e.firstChild()
            while not sube.isNull():
                if sube.toElement().tagName() == "format":
                    if sube.toElement().text() == format:
                        height = sube.toElement().attribute("height",  "")
                        width = sube.toElement().attribute("width",  "")
                        try:
                            float(height)
                            float(width)
                            return height,  width
                        except ValueError:
                            print "height/width float error"
                sube = sube.nextSibling()
            n = n.nextSibling()
            
        return height,  width

        
    def preferences(self,  pref,  text):
        prefs = []
        
        preffilename = QDir.convertSeparators(QDir.cleanPath(QgsApplication.qgisSettingsDirPath() + "/python/plugins/easyprint/preferences/preferences.xml"))
        try:
            preffile = open(preffilename,"r")
            prefxml = preffile.read()

            doc = QtXml.QDomDocument()
            doc.setContent(prefxml,  True)  

            root = doc.documentElement()
            if root.tagName() != "preferences":
                return
                
            n = root.firstChild()
            while not n.isNull():
                e = n.toElement()
                sube = e.firstChild()
                while not sube.isNull():
                    if sube.toElement().tagName() == pref:
                        try:
                            if not text:
                                float(sube.toElement().text())
                            prefs.append(unicode(sube.toElement().text()))
                        except ValueError:
                            print "float error: reading scales"
                    sube = sube.nextSibling()
                n = n.nextSibling()

        except IOError:
            print "error opening preferences.xml"        
        
        return prefs

        
    def layouts(self):
        layouts = []
        
        layoutsfilename = QDir.convertSeparators(QDir.cleanPath(QgsApplication.qgisSettingsDirPath() + "/python/plugins/easyprint/layouts/layouts.xml"))
        try:
            layoutsfile = open(layoutsfilename,"r")
            layoutsxml = layoutsfile.read()
            
            doc = QtXml.QDomDocument()
            doc.setContent(layoutsxml,  True)  
            
            root = doc.documentElement()
            if root.tagName() != "layouts":
                return
            
            node = root.firstChild()
            while not node.isNull():
                if node.toElement() and node.nodeName() == "layout":
                    margins = []
                    id = node.toElement().attribute("id","")
                    layout = Layout(id)
                    ori = node.toElement().attribute("orientation",  "")
                    layout.setOrientation(ori)
                    ## Read a single layout.
                    layoutnode = node.toElement().firstChild()
                    while not layoutnode.isNull():
                        if layoutnode.toElement() and layoutnode.nodeName() == "margins":
                            ## Read margins.
                            marginnode = layoutnode.toElement().firstChild()
                            while not marginnode.isNull():
                                try:
                                    margins.append( float(marginnode.toElement().text()) )
                                    print marginnode.toElement().text()
                                except ValueError:
                                    margins.append( float(0.0) )
                                marginnode = marginnode.nextSibling()
                            print margins
                            layout.setMargins(margins)
                        
                        elif layoutnode.toElement() and layoutnode.nodeName() == "decorations": 
                            ## Read decorations.
                            deconode = layoutnode.toElement().firstChild()
                            while not deconode.isNull():
                                type = deconode.toElement().attribute("type","")
                                decoration = Decoration(type)
                                
                                affinity = deconode.toElement().attribute("affinity",  "")
                                offset_x = deconode.toElement().attribute("offset_x","")
                                offset_y = deconode.toElement().attribute("offset_y","")
                                height = deconode.toElement().attribute("height", "")
                                width = deconode.toElement().attribute("width",  "")
                                fontsize = deconode.toElement().attribute("font-size",  "")
                                fontfamily = deconode.toElement().attribute("font-family",  "")
                                fontweight = deconode.toElement().attribute("font-weight",  "")
                                rotation = deconode.toElement().attribute("rotation",  "")
                                
                                if str.find(str(affinity),  ",") >= 0: 
                                    affx = str(str.split(str(affinity),",")[1]).strip()
                                    affy = str(str.split(str(affinity),",")[0]).strip()
                                    
                                    if affx == "left" or affx == "right":
                                        decoration.setAffinityX(affx)
                                    
                                    if affy == "top" or affy == "bottom":
                                        decoration.setAffinityY(affy)
                                
                                if fontfamily != None:
                                    decoration.setFontFamily(fontfamily)
                                
                                try:
                                    decoration.setOffsetX(float(offset_x))
                                except ValueError:
                                    print "float offset_x error"
                                    
                                try:
                                    decoration.setOffsetY(float(offset_y))
                                except ValueError:
                                    print "float offset_y error"        
            
                                try:
                                    decoration.setHeight(float(height))
                                except ValueError:
                                    decoration.setHeight(float(0.0))
                                    print "float height error or not found."        
                                    
                                try:
                                    decoration.setWidth(float(width))
                                except ValueError:
                                    decoration.setWidth(float(0.0))
                                    print "float width error or not found."                                        
                                    
                                try:
                                    decoration.setFontSize(float(fontsize))
                                except ValueError:
                                    print "float fontsize error or not found."           
                                 
                                try:
                                    decoration.setFontWeight(int(fontweight))
                                    print decoration.getFontWeight()
                                except ValueError:
                                    print "float fontweight error or not found."  
                                 
                                try:
                                    decoration.setRotation(float(rotation))
                                except ValueError:
                                    print "float rotation error or not found."           
                                        
                                if type == "text" or type == "date" or type == "scaletext" or type == "legend" or type == "copyright" or type == "person":
                                    text = deconode.toElement().text()
                                    decoration.setText(text)
                                
                                if type == "picture" or type == "northarrow":
                                    pic = deconode.toElement().text()
                                    decoration.setPicture(pic)
                                
                                layout.addDecoration(decoration)
                                
                                deconode = deconode.nextSibling()

                        layoutnode = layoutnode.nextSibling()
                    print layout.getMargins()
                    layouts.append(layout)

                node = node.nextSibling()

        except IOError:
            print "error opening preferences.xml"        
        
        return layouts            
