# -*- coding: utf-8 -*-
"""
/***************************************************************************
 EasyProcessingTool
                                 A QGIS plugin
 EasyProcessingTool
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-04-05
        git sha              : $Format:%H$
        copyright            : (C) 2019 by iGIS Corp.
        email                : idscorea1@naver.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
import sys

sys.path.append(os.path.join(os.path.dirname(__file__), 'lib'))
sys.path.append(os.path.dirname(__file__))

from qgis.PyQt import QtCore
from qgis.PyQt.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon, QKeySequence, QPixmap
from qgis.PyQt.QtWidgets import QAction, QMenu, QMessageBox, QSplashScreen

# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the dialog
from .create_merged_buffer_dialog import CreateMergedBufferDialog
from .add_layer_multi_dialog import AddLayerMultiDialog
from .create_length_area_attributes_dialog import CreateLengthAreaAttributesDialog
from .create_centeroid_layer_dialog import CreateCenteroidLayerDialog
from .import_kml_dialog import ImportKMLDialog
from .export_kml_dialog import ExportKMLDialog
from .translate_coordinate_dialog import TranslateCoordinateDialog
from .set_coordinate_dialog import SetCoordinateDialog
from .auto_district_printer_dialog import AutoDistrictPrinterDialog
from .calculate_raster_area_dialog import CalculateRasterAreaDialog
from .plugin_info_dialog import PluginInfoDialog

from .boundary_utils import *
from .layer_utils import *

import os.path

class EasyProcessingTool:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'EasyProcessingTool{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)
        """
        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Plugin Tester')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        """
            
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('EasyProcessingTool', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=False,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.menu.addAction(action)

        self.actions.append(action)

        return action

    def initGui(self):
        # Declare instance attributes
        self.actions = []
        #self.menu = u'빠른 작업 도구'
        self.menuBar=self.iface.mainWindow().menuBar()
        self.menu=QMenu(u'빠른 작업 도구', self.menuBar)
        actions=self.menuBar.actions()
        lastAction=actions[-1]
        self.menuBar.insertMenu(lastAction, self.menu)
        
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'빠른 작업 도구')
        self.toolbar.setObjectName(u'EasyProcessingTool')
        
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        
        icon_path = os.path.join(os.path.dirname(__file__), 'icon', 'Print.png')
        
        self.add_action(
            icon_path,
            text=u'자동 구역 출력',
            callback=self.run_AutoDistrictPrinterDialog,
            parent=self.iface.mainWindow(),
            add_to_toolbar=True)
        
        self.menu.addSeparator()
        
        icon_path = os.path.join(os.path.dirname(__file__), 'icon', 'AddLayer.png')
        self.add_action(
            icon_path,
            text=u'다중 레이어 추가',
            callback=self.run_AddLayerMultiDialog,
            parent=self.iface.mainWindow(),
            add_to_toolbar=True)
            
        self.menu.addSeparator()
        
        icon_path = os.path.join(os.path.dirname(__file__), 'icon', 'AddData.png')
        
        self.add_action(
            icon_path,
            text=u'길이/면적 속성 입력',
            callback=self.run_CreateLengthAreaAttributesDialog,
            parent=self.iface.mainWindow())
            
        self.add_action(
            icon_path,
            text=u'중심점 생성',
            callback=self.run_CreateCenteroidLayerDialog,
            parent=self.iface.mainWindow())
            
        fieldAction=QAction(QIcon(icon_path), '길이/면적 속성 입력', self.iface.mainWindow())
        fieldMenu=QMenu(self.iface.mainWindow())
        fieldAction1=QAction('길이/면적 속성 입력', self.iface.mainWindow())
        fieldAction2=QAction('중심점 생성', self.iface.mainWindow())
        fieldMenu.addAction(fieldAction1)
        fieldMenu.addAction(fieldAction2)
        fieldAction.setMenu(fieldMenu)
        self.toolbar.addAction(fieldAction)
        
        fieldAction.triggered.connect(self.run_CreateLengthAreaAttributesDialog)
        fieldAction1.triggered.connect(self.run_CreateLengthAreaAttributesDialog)
        fieldAction2.triggered.connect(self.run_CreateCenteroidLayerDialog)
        
        self.actions.append(fieldAction)
        
        self.menu.addSeparator()
            
        icon_path = os.path.join(os.path.dirname(__file__), 'icon', 'KML.png')
            
        #ImportKMLDialog
        self.add_action(
            icon_path,
            text=u'KML 가져오기',
            callback=self.run_ImportKMLDialog,
            parent=self.iface.mainWindow())
        #ExportKMLDialog
        self.add_action(
            icon_path,
            text=u'KML 내보내기',
            callback=self.run_ExportKMLDialog,
            parent=self.iface.mainWindow())
            
        kmlAction=QAction(QIcon(icon_path), 'KML 가져오기', self.iface.mainWindow())
        kmlMenu=QMenu(self.iface.mainWindow())
        kmlAction1=QAction('KML 가져오기', self.iface.mainWindow())
        kmlAction2=QAction('KML 내보내기', self.iface.mainWindow())
        kmlMenu.addAction(kmlAction1)
        kmlMenu.addAction(kmlAction2)
        kmlAction.setMenu(kmlMenu)
        self.toolbar.addAction(kmlAction)
        
        kmlAction.triggered.connect(self.run_ImportKMLDialog)
        kmlAction1.triggered.connect(self.run_ImportKMLDialog)
        kmlAction2.triggered.connect(self.run_ExportKMLDialog)
        
        self.actions.append(kmlAction)
        
        self.menu.addSeparator()
            
        icon_path = os.path.join(os.path.dirname(__file__), 'icon', 'Coordinates.png')

        self.add_action(
            icon_path,
            text=u'레이어 좌표계 설정',
            callback=self.run_SetCoordinateDialog,
            parent=self.iface.mainWindow())
        
        self.add_action(
            icon_path,
            text=u'레이어 좌표계 변환',
            callback=self.run_TranslateCoordinateDialog,
            parent=self.iface.mainWindow())
            
        crsAction=QAction(QIcon(icon_path), '레이어 좌표계 설정', self.iface.mainWindow())
        crsMenu=QMenu(self.iface.mainWindow())
        crsAction1=QAction('레이어 좌표계 설정', self.iface.mainWindow())
        crsAction2=QAction('레이어 좌표계 변환', self.iface.mainWindow())
        crsMenu.addAction(crsAction1)
        crsMenu.addAction(crsAction2)
        crsAction.setMenu(crsMenu)
        self.toolbar.addAction(crsAction)
        
        crsAction.triggered.connect(self.run_SetCoordinateDialog)
        crsAction1.triggered.connect(self.run_SetCoordinateDialog)
        crsAction2.triggered.connect(self.run_TranslateCoordinateDialog)
        
        self.actions.append(crsAction)
        
        self.menu.addSeparator()
        
        icon_path = os.path.join(os.path.dirname(__file__), 'icon', 'CalculateArea.png')
        self.add_action(
            icon_path,
            text='래스터 면적 추출',
            callback=self.run_CalculateRasterArea,
            parent=self.iface.mainWindow(),
            add_to_toolbar=True)
            
        self.menu.addSeparator()
        self.add_action(
            None,
            text='플러그인 정보',
            callback=self.run_PluginInfoDialog,
            parent=self.iface.mainWindow())
            

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removeToolBarIcon(action)
        self.menu.clear()
        self.menu.deleteLater()
        # remove the toolbar
        del self.toolbar
            
    def run_AutoDistrictPrinterDialog(self):
        # Create the dialog (after translation) and keep reference
        dlg = AutoDistrictPrinterDialog()
        
        """Run method that performs all the real work"""
        # show the dialog
        dlg.show()
        # Run the dialog event loop
        result = dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
            
    def run_CreateMergedBufferDialog(self):
        # Create the dialog (after translation) and keep reference
        dlg = CreateMergedBufferDialog()
        
        """Run method that performs all the real work"""
        # show the dialog
        dlg.show()
        # Run the dialog event loop
        result = dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
    
    def run_AddLayerMultiDialog(self):
        # Create the dialog (after translation) and keep reference
        dlg = AddLayerMultiDialog()
        
        """Run method that performs all the real work"""
        # show the dialog
        dlg.show()
        # Run the dialog event loop
        result = dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
            
    def run_CreateLengthAreaAttributesDialog(self):
        # Create the dialog (after translation) and keep reference
        dlg = CreateLengthAreaAttributesDialog()
        
        """Run method that performs all the real work"""
        # show the dialog
        dlg.show()
        # Run the dialog event loop
        result = dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
            
    def run_CreateCenteroidLayerDialog(self):
        # Create the dialog (after translation) and keep reference
        dlg = CreateCenteroidLayerDialog()
        
        """Run method that performs all the real work"""
        # show the dialog
        dlg.show()
        # Run the dialog event loop
        result = dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
            
    def run_ImportKMLDialog(self):
        # Create the dialog (after translation) and keep reference
        dlg = ImportKMLDialog()
        
        """Run method that performs all the real work"""
        # show the dialog
        dlg.show()
        # Run the dialog event loop
        result = dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
            
    def run_ExportKMLDialog(self):
        # Create the dialog (after translation) and keep reference
        dlg = ExportKMLDialog()
        
        """Run method that performs all the real work"""
        # show the dialog
        dlg.show()
        # Run the dialog event loop
        result = dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
            
    def run_TranslateCoordinateDialog(self):
        # Create the dialog (after translation) and keep reference
        dlg = TranslateCoordinateDialog()
        
        """Run method that performs all the real work"""
        # show the dialog
        dlg.show()
        # Run the dialog event loop
        result = dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
            
    def run_SetCoordinateDialog(self):
        # Create the dialog (after translation) and keep reference
        dlg = SetCoordinateDialog()
        
        """Run method that performs all the real work"""
        # show the dialog
        dlg.show()
        # Run the dialog event loop
        result = dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
            
    def run(self, dlg):
        """Run method that performs all the real work"""
        # show the dialog
        dlg.show()
        # Run the dialog event loop
        result = dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
            
    def run_CalculateRasterArea(self):
        self.run(CalculateRasterAreaDialog(self.iface.mainWindow()))
        
    def run_PluginInfoDialog(self):
        self.run(PluginInfoDialog(self.iface.mainWindow()))
        
    def showMessage(self, text, title=''):
        msg = QMessageBox(self.iface.mainWindow())
        msg.setText(text)
        if title:
            msg.setWindowTitle(title)
        else:
            msg.setWindowTitle('빠른 작업 도구')
        msg.exec_()