# EasyGeocoder

EasyGeocoder is a QGIS plugin for batch geocoding CSV address data using OpenStreetMap Nominatim.

## Features

- Batch geocoding from CSV (`UTF-8`).
- Configurable column mapping:
  - address (required)
  - city (optional)
  - postal code (optional)
  - country (optional)
- Structured Nominatim lookup with free-text fallback.
- Result layer in `EPSG:4326` with source columns preserved.
- Status column for QA (`OK`, `NOT FOUND`, `TIMEOUT`, etc.).

## Requirements

- QGIS `3.x`

## Usage

1. Open `EasyGeocoder` from the QGIS plugin menu.
2. Select input CSV and output path (`.gpkg` recommended).
3. Map CSV columns.
4. Start geocoding and wait for background task completion.

## Repository

- Source code: https://github.com/gjkson16-cyber/easy_geocoder
- Issues: https://github.com/gjkson16-cyber/easy_geocoder/issues

## License

This project is licensed under the GNU General Public License v2.0 or later (`GPL-2.0-or-later`).
