# Changelog

All notable changes to this plugin are documented in this file.

## 2026-02-13

### Added
- Added optional CSV column mapping for postal code.
- Added two-step geocoding flow:
  - structured Nominatim request (`street`, `city`, `postalcode`, `country`)
  - fallback to free-text query when structured search returns `not_found`.
- Added support for including all input CSV columns in the output layer.
- Added automatic source-field type inference:
  - columns with only integer values are exported as `Integer (64 bit)`
  - other columns are exported as `Text (string)`.
- Added fallback point handling for unresolved records:
  - coordinates: `52.40058891, 7.07717619`
  - status derived from reason (for example: `NOT FOUND`, `TIMEOUT`, `NETWORK ERROR`).

### Changed
- Output attribute schema now includes:
  - all input CSV columns
  - `query`
  - `coordinates` (single text field in `lat, lon` format)
  - `status`.
- Output field order updated:
  - integer CSV fields first (right after `fid`)
  - then `query`
  - then non-integer CSV fields
  - `coordinates` always second to last
  - `status` always last.
- Geocoding task now writes all rows to output layer:
  - successful rows as `OK`
  - unresolved rows with fallback coordinates and reason-based status.

### Removed
- Removed generation of separate `*_not_found.csv` file.
- Removed related UI elements and dead code paths for selecting/saving `not_found.csv`.
