# -*- coding: utf-8 -*-
from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.Qwt5 import *
from PyQt4.Qwt5.qplt import *

# doc:
# http://qgis.org/pyqgis-cookbook/vector.html

class ExportPanel(QWidget):

  def __init__(self, plot):

    QWidget.__init__(self)

    self.filename=None
    self.thisPlot = plot
#    self.dataX = inarrX
#    self.dataY = inarrY
#    self.dataP = inarrP
#    self.dataS = inarrS
    self.exportFormat = {'PNG': 0, 'JPG':1}
    self.picknameInfoString='Choose a filename'

    self.setupUi(self)

  def setupUi(self, form):
    vbox = QtGui.QVBoxLayout(form)
    radioPNG = QtGui.QRadioButton("PNG", form)
    radioPNG.setChecked(True)
    vbox.addWidget(radioPNG);

    hbox = QtGui.QHBoxLayout()
    radioJPG = QtGui.QRadioButton("JPG", form)
    radioJPG.setChecked(False)
    hbox.addWidget(radioJPG)

    jpgVbox = QtGui.QVBoxLayout()
    jpgVbox.setAlignment(Qt.AlignCenter)
    self.jpgSlider=QtGui.QSlider(form)
    self.jpgSlider.setMaximum(100)
    self.jpgSlider.setSingleStep(10)
    self.jpgSlider.setOrientation(QtCore.Qt.Horizontal)
    self.jpgSlider.setTickPosition(QtGui.QSlider.TicksBelow)
    self.jpgSlider.setTickInterval(10)
    self.jpgSlider.setValue(75)
    self.jpgComText = QtGui.QLabel('Quality: 75%')
    jpgVbox.addWidget(self.jpgComText)
    jpgVbox.addWidget(self.jpgSlider)
    hbox.addLayout(jpgVbox)
    vbox.addLayout(hbox)
    self.jpgSlider.valueChanged.connect(self.set_jpgcomp)

    # radio group
    self.formatRG = QtGui.QButtonGroup(form)
    self.formatRG.addButton(radioPNG)
    self.formatRG.setId(radioPNG, self.exportFormat['PNG'])
    self.formatRG.addButton(radioJPG)
    self.formatRG.setId(radioJPG, self.exportFormat['JPG'])

    hboxFileChooser = QtGui.QHBoxLayout()
    hboxFileChooser.setDirection = QBoxLayout.RightToLeft
    
    self.fileName = QtGui.QLineEdit(form)
    self.fileName.move(10,10)
    if (self.filename==None):
      self.fileName.setText(self.picknameInfoString)
    else:
      self.fileName.setText(self.filename)
    self.fileName.setMinimumWidth(400)
    self.fileName.setMaximumWidth(1000)
    hboxFileChooser.addWidget(self.fileName)

    fileChooserButton = QtGui.QPushButton("Define",form)
    hboxFileChooser.addWidget(fileChooserButton)

    vbox.addLayout(hboxFileChooser)
    hboxFileChooser.addStretch(1)

    hboxExport = QtGui.QHBoxLayout()
    exportButton = QtGui.QPushButton("Export", form)
    vbox.addWidget(exportButton)
    spacerItem = QtGui.QSpacerItem(40,15,QtGui.QSizePolicy.Expanding,QtGui.QSizePolicy.Minimum)
    hboxExport.addItem(spacerItem)
    hboxExport.addWidget(exportButton)
    vbox.addLayout(hboxExport)
    
    # connections
    QObject.connect(fileChooserButton,SIGNAL("clicked()"),self.pickupFilename)
    QObject.connect(exportButton, SIGNAL("clicked()"), self.exportDataToFile)
    QObject.connect(radioPNG, SIGNAL("clicked()"), self.resetSuffix)
    QObject.connect(radioJPG, SIGNAL("clicked()"), self.resetSuffix)


  def set_jpgcomp(self):
    self.jpgComText.setText( 'Quality: '+str(self.jpgSlider.value())+'%' )

  def pickupFilename(self):
    self.filename = QFileDialog.getSaveFileName(self, "save file")
    self.fileName.setText(QString(self.filename))
    # check if a filename is given (self.filename is not a directory)
    fileinfo = QFileInfo(self.filename)
    if fileinfo.isDir():
      print 'filename not defined: ', self.filename
      return  
    # append extension if filename was reset and filename is defined
    self.resetSuffix()

  def exportDataToFile(self): 
    # check export directory exists
    thisFilename = self.fileName.text().trimmed()
    
    if thisFilename == self.picknameInfoString:
      return
    
    if self.formatRG.checkedId()==self.exportFormat['PNG']:
      QPixmap.grabWidget(self.thisPlot).save(thisFilename, 'PNG')
    elif self.formatRG.checkedId()==self.exportFormat['JPG']:
      QPixmap.grabWidget(self.thisPlot).save(thisFilename, 'JPG', self.jpgSlider.value())
 
  def resetSuffix(self):
    thisFilename = str(self.fileName.text().trimmed())
    if thisFilename == self.picknameInfoString:
      print 'no string: return'
      return
    fileinfo = QFileInfo(thisFilename)
    suffix = str(fileinfo.suffix())
    if suffix != "":
      suffix = '.' + suffix
      if self.formatRG.checkedId()==self.exportFormat['PNG']:
        self.filename = thisFilename[:-4] + '.png'
      elif self.formatRG.checkedId()==self.exportFormat['JPG']:
        self.filename = thisFilename[:-4] + '.jpg'
    else:
      if self.formatRG.checkedId()==self.exportFormat['PNG']:
        self.filename = thisFilename + '.png'
      elif self.formatRG.checkedId()==self.exportFormat['JPG']:
        self.filename = thisFilename + '.jpg'
    
    self.fileName.setText(QString(self.filename))
    
