"""
/***************************************************************************
    Earth Beat           - A QGIS plugin: is your Earth beating?
                             -------------------
    begin                : December 2011
    copyright            : (C) 2011 Bruno Combal
    email                : bruno(dot)combal(at)gmail(dot)com
 ***************************************************************************/
"""

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *


from earthbeatwidget import EarthBeatWidget

class EarthBeat:
  def __init__(self, iface):
    # save reference to the QGIS interface
    self.iface = iface
    self.canvas = iface.mapCanvas()

  def initGui(self):
    # create action that will start plugin configuration
    #self.action = QAction(QIcon(":/plugins/earthbeat/earthbeat.png"), "Value Tool", self.iface.mainWindow())
    #self.action.setWhatsThis("EarthBeat")
    #QObject.connect(self.action, SIGNAL("activated()"), self.run)
    ## add toolbar button and menu item
    #self.iface.addToolBarIcon(self.action)
    #self.iface.addPluginMenu("Analyses", self.action)
    ## add the tool to select feature
    #self.tool = selectPointTool(self.iface.getMapCanvas(),self.action)

    # create the widget to display information
    self.valuewidget = EarthBeatWidget(self.iface,self.canvas)
    # create the dockwidget with the correct parent and add the earthbeatwidget
    self.valuedockwidget=QDockWidget("Earth Beat" , self.iface.mainWindow() )
    self.valuedockwidget.setObjectName("Earth Beat")
    self.valuedockwidget.setWidget(self.valuewidget)
    
    # add the dockwidget to iface
    self.iface.addDockWidget(Qt.LeftDockWidgetArea,self.valuedockwidget)
    #self.valuewidget.show()

###Qt.AllDockWidgetAreas
  def unload(self):
    self.valuedockwidget.close()
    self.valuewidget.disconnect()
    # remove the plugin menu item and icon
    #self.iface.removePluginMenu("Analyses",self.action)
    #self.iface.removeToolBarIcon(self.action)


  def showHideDockWidget( self ):
    if self.valuedockwidget.isVisible():
        self.valuewidget.checkBox_2.setCheckState( Qt.Checked )
    else:
        self.valuewidget.checkBox_2.setCheckState( Qt.Unchecked )
