# -*- coding: utf-8 -*-
from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import *
from PyQt4.QtGui import *

from UIProcessingsSettings import *
#________________________
updatedParameters = pyqtSignal()
#________________________

class doProcessingsSettings(QWidget, Ui_panelProcessingsSettings):
    def __init__(self):
        QWidget.__init__(self)
        self.setupUi(self)

    def setupUi(self, refPanel):
        # instantiate the object
        super(doProcessingsSettings, self).setupUi(refPanel)
        # group radio buttons
        self.dropButtonGroup = QButtonGroup()
        self.dropButtonGroup.addButton(self.showCorrectRadio)
        self.dropButtonGroup.addButton(self.showOrgCorrRadio)

#        self.statsButtonGroup = QButtonGroup()
#        self.statsButtonGroup.addButton(self.statsViewAxisCheck)
#        self.statsButtonGroup.addButton(self.statsViewBandCheck)
        # build buttons links
        QObject.connect(self.antiDropCheck, SIGNAL("stateChanged(int)"), self.setAntidropOption)
        QObject.connect(self.statsCheck, SIGNAL("stateChanged(int)"), self.statsOption)

        # set default settings
        self.applySettings()

    def setAntidropOption(self):
        if self.antiDropCheck.checkState(): # options are available
            self.showCorrectRadio.setEnabled(True)
            self.showOrgCorrRadio.setEnabled(True)
        else: # disable options
            self.showCorrectRadio.setEnabled(False)
            self.showOrgCorrRadio.setEnabled(False)

    def statsOption(self):
        if self.statsCheck.checkState(): #enable options
            self.statsViewAxisCheck.setEnabled(True)
            self.statsViewBandCheck.setEnabled(True)
        else: # disable options
            self.statsViewAxisCheck.setEnabled(False)
            self.statsViewBandCheck.setEnabled(False)

    def applySettings(self):
        # get settings
        defaultProcSettings = readDefaultProcessings()
        # apply to objects
        (status, test) = defaultProcSettings.getAntiDrops().toInt()
        self.antiDropCheck.setChecked( status )

        (status, test) = defaultProcSettings.getShowCorrectRadio().toInt()
        self.showCorrectRadio.setChecked( status )

        (status, test) = defaultProcSettings.getShowOrgCorrectRadio().toInt()
        self.showOrgCorrRadio.setChecked( status )
 
        (status, test) = defaultProcSettings.getStatsCheck().toInt()
        self.statsCheck.setChecked( status )
        (status, test) = defaultProcSettings.getStatsViewAxisCheck().toInt()
        self.statsViewAxisCheck.setChecked( status )
        (status, test) = defaultProcSettings.getStatsViewBandCheck().toInt()
        self.statsViewBandCheck.setChecked( status )

        self.statsOption() # enable/disable radio buttons

    def writeParam(self):
        global globDefaultProcessings
        settings = QSettings()
        settings.setValue('earthbeat/processings/antiDrops', QVariant(self.antiDropCheck.checkState() ) )
        if self.showCorrectRadio.isChecked():
            settings.setValue('earthbeat/processings/showCorrectDrops', QVariant(4 ) )
        else:
            settings.setValue('earthbeat/processings/showCorrectDrops', QVariant(0 ) )
        if self.showOrgCorrRadio.isChecked():
            settings.setValue('earthbeat/processings/showOrgCorrDrops', QVariant(8 ) )
        else:
            settings.setValue('earthbeat/processings/showOrgCorrDrops', QVariant(0 ) )
        
        settings.setValue('earthbeat/processings/statsCheck', QVariant(self.statsCheck.checkState() ) )
        settings.setValue('earthbeat/processings/statsViewAxisCheck', QVariant(self.statsViewAxisCheck.checkState() ) )
        settings.setValue('earthbeat/processings/statsViewBandCheck', QVariant(self.statsViewBandCheck.checkState() ) )

        self.emit( SIGNAL('updatedParameters()') )

    def closeEvent(self, event):
        # save parameters on exit
        self.writeParam()
        event.accept


# ______________
class readDefaultProcessings():
    def __init__(self):
        settings = QSettings()
        self.antiDrops_settings          =settings.value("earthbeat/processings/antiDrops", False)
        self.showCorrectDrops_settings   =settings.value("earthbeat/processings/showCorrectDrops", True)
        self.showOrgCorrectDrops_settings=settings.value("earthbeat/processings/showOrgCorrDrops", False)

        self.statsCheck_settings=settings.value("earthbeat/processings/statsCheck", False)
        self.statsViewAxisCheck_settings=settings.value("earthbeat/processings/statsViewAxisCheck", False)
        self.statsViewBandCheck_settings=settings.value("earthbeat/processings/statsViewBandCheck", False)

    def getDefault(self):
        return {
            "antiDrops":          self.antiDrops_settings,
            "showCorrectDrops":   self.showCorrectDrops_settings,
            "showOrgCorrectDrops":self.showOrgCorrectDrops_settings,
            "statsCheck":self.statsCheck_settings,
            "statsViewAxisCheck":self.statsViewAxisCheck_settings,
            "statsViewBandCheck":self.statsViewBandCheck_settings
            }

    def getAntiDrops(self):
        return self.antiDrops_settings

    def getShowCorrectRadio(self):
        return self.showCorrectDrops_settings

    def getShowOrgCorrectRadio(self):
        return self.showOrgCorrectDrops_settings

    def getStatsCheck(self):
        return self.statsCheck_settings

    def getStatsViewAxisCheck(self):
        return self.statsViewAxisCheck_settings

    def getStatsViewBandCheck(self):
        return self.statsViewBandCheck_settings
