"""
/***************************************************************************
Class Marker
   begin                : 2011 - 12 - 01
   copyright            : (C) 2011 Bruno Combal
   email                : bruno(dot)combal(at)gmail(dot)com

Place a marker on the map

 ***************************************************************************/
"""
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *

class Marker:
    def __init__(self, iface, canvas):
        self.have_layer = True
        self.iface = iface
        self.canvas = canvas
        self.last_desc=" "
        self.have_layer = False # layer created on first placed pin
    #__________________________
    # get the x,y and create the pin
    def place_pin(self, pointX, pointY, arrY, arrStats):
        # check each time if the layer (still) exists
        if self.have_layer == False:
            self.createMarkerLayer()

        ok = False
        (desc, ok) = QInputDialog.getText(
            self.iface.mainWindow(), 
            "Description",
            "Description for position %.2f, %.2f" % (float(str(pointX)), float(str(pointY))), 
            QLineEdit.Normal,
            self.last_desc)
        
        if (ok):
            self.last_desc = desc
            
            fc = int( self.provider.featureCount() )
            profileY = str(arrY[0])
            for ii in arrY[1:]:
                profileY += ", "+str(ii)
            
            stats = "min= "+str(arrStats[0])+", max= "+str(arrStats[1])+", average= "+str(arrStats[2])

            feature = QgsFeature()
            feature.setGeometry( QgsGeometry.fromPoint(QgsPoint(pointX, pointY)) )
            feature.setAttributeMap({0 : QVariant(fc), 
                                     1 : QVariant(desc),
                                     2 : QVariant(profileY),
                                     3 : QVariant(stats)})
            self.provider.addFeatures([feature])
            self.pinLayer.updateExtents()
            self.pinLayer.setCacheImage(None)
            self.canvas.refresh()
    #__________________________
    def createMarkerLayer(self):
        self.pinLayer =  QgsVectorLayer("Point", "Earthbeat places", "memory")
        self.provider = self.pinLayer.dataProvider()
        #print "data provider=", self.provider
        self.provider.addAttributes ([QgsField("id", QVariant.Int),
                                      QgsField("description", QVariant.String),
                                      QgsField("profile",QVariant.String),
                                      QgsField("stats",QVariant.String)])
        self.pinLayer.updateFieldMap()
        self.pinLayer.setDisplayField("description")
        self.provider.createSpatialIndex()
        QgsMapLayerRegistry.instance().addMapLayer(self.pinLayer)
        result = QObject.connect(self.pinLayer, SIGNAL("layerDeleted()"), self.layer_deleted)
        self.have_layer = True
    #___________________________
    def layer_deleted(self):
        self.have_layer = False
    #__________________________
    def deleteMarkerLayer(self):
        if self.have_layer==True:
            QgsMapLayerRegistry.instance().removeMapLayer(self.pinLayer.getLayerID())
            self.layer_deleted()

        
