# -*- coding: utf-8 -*-
from PyQt4 import QtCore, QtGui
from PyQt4.Qwt5 import QwtPlot

class Ui_Form(object):
    def setupUi(self, Form):

        self.vboxlayout = QtGui.QVBoxLayout(Form)

        self.hboxlayout = QtGui.QHBoxLayout()

        self.activateProfile = QtGui.QCheckBox(Form)
        self.activateProfile.setChecked(True)

        self.hboxlayout.addWidget(self.activateProfile)
        self.activateProfile.setToolTip("shortcut: Shift + A")

        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Minimum,QtGui.QSizePolicy.Fixed)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)

        spacerItem = QtGui.QSpacerItem(40,15,QtGui.QSizePolicy.Expanding,QtGui.QSizePolicy.Minimum)
        self.hboxlayout.addItem(spacerItem)
        self.vboxlayout.addLayout(self.hboxlayout)

        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Expanding,QtGui.QSizePolicy.Expanding)

        self.clearCollectionButton = QtGui.QPushButton("clear", self)
        self.clearCollectionButton.setFlat(True)
        self.hboxlayout.addWidget(self.clearCollectionButton)
        self.clearCollectionButton.setToolTip("Clear the point collection")

        self.exportCollectionButton = QtGui.QPushButton("export",self)
        self.exportCollectionButton.setFlat(True)
        self.hboxlayout.addWidget(self.exportCollectionButton)
        self.exportCollectionButton.setToolTip("Export data to a file")

        self.settingsButton = QtGui.QPushButton("settings", self)
        self.settingsButton.setFlat(True)
        self.hboxlayout.addWidget(self.settingsButton)
        self.settingsButton.setToolTip("Change settings options")

        self.infoButton = QtGui.QPushButton("?", self)
        self.infoButton.setFlat(True)
        self.hboxlayout.addWidget(self.infoButton)

        self.qwtPlot = QwtPlot(Form)
        self.qwtPlot.setAutoFillBackground(False)
        self.qwtPlot.setObjectName("qwtPlot")

            
        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Expanding,QtGui.QSizePolicy.Expanding)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.qwtPlot.sizePolicy().hasHeightForWidth())
        self.qwtPlot.setSizePolicy(sizePolicy)
        self.qwtPlot.setObjectName("qwtPlot")
        self.vboxlayout.addWidget(self.qwtPlot)

        self.retranslateUi(Form)
        QtCore.QMetaObject.connectSlotsByName(Form)

    def retranslateUi(self, Form):
        Form.setWindowTitle(QtGui.QApplication.translate("Form", "Form", None, QtGui.QApplication.UnicodeUTF8))
        self.activateProfile.setText(QtGui.QApplication.translate("Form", "On", None, QtGui.QApplication.UnicodeUTF8))
