# -*- coding: utf-8 -*-
from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.Qwt5 import QwtSymbol, QwtPlot, QwtPlotCurve
import math
import random

from doProcessingsSettings import *
#________________________
updatedParameters = pyqtSignal()
#________________________
def symbolList():
  listSymbol=[['No Symbol', QwtSymbol.NoSymbol, 'None'],
              ['Circle', QwtSymbol.Ellipse, u'\u25EF'],
              ["Square", QwtSymbol.Rect, u'\u25A1'],
              ["Diamond", QwtSymbol.Diamond, u'\u25C7'],
              ["Downward Triangle", QwtSymbol.DTriangle, u'\u25BD'],
              ["Upward Triangle", QwtSymbol.UTriangle, u'\u25B3'],
 #             ["Left Triangle",QwtSymbol.LTriangle],
 #             ["Right Triangle",QwtSymbol.RTriangle],
              ["Plus sign",QwtSymbol.Cross, '+'],
              ["X cross",QwtSymbol.XCross, 'x'],
 #             ["Horizontal Line",QwtSymbol.HLine],
 #             ["Vertical Line",QwtSymbol.VLine],
              ["Star",QwtSymbol.Star1, u'\u2605'],
              ["Six-pointed Star",QwtSymbol.Star2, u'\u2736'],
              ["Hexagon",QwtSymbol.Hexagon, u'\u2B21']]
  return listSymbol
#________________________
def colorList():
  listColor=[["Black", Qt.black],
             ["Dark Gray", Qt.darkGray],
             ["Gray", Qt.gray],
             ["Light Gray", Qt.lightGray],
             ["Red", Qt.red],
             ["Green", Qt.green],
             ["Blue", Qt.blue],
             ["Cyan", Qt.cyan],
             ["Magenta", Qt.magenta],
             ["Yellow", Qt.yellow],
             ["Dark Red", Qt.darkRed],
             ["Dark Green", Qt.darkGreen],
             ["dark Blue", Qt.darkBlue],
             ["Dark Cyan", Qt.darkCyan],
             ["Dark Magenta", Qt.darkMagenta],
             ["Dark Yellow", Qt.darkYellow],
             ["White", Qt.white],
             ["Transparent", Qt.transparent]]
  return listColor  

#QwtSymbol(QwtSymbol.Ellipse, QBrush(Qt.white), QPen(Qt.red, 2), QSize(9, 9))
#______________________________
def curveStyleList():
  curveStyleList=[["NoCurve", Qt.NoPen,'None'],
                  ["Lines", Qt.SolidLine,'-'],
                  ["Dash", Qt.DashLine, '- -'],
                  ["Dots", Qt.DotLine,'...'],
                  ["Dash dot", Qt.DashDotLine, "-.-."],
                  ["Dash dot dot", Qt.DashDotDotLine, "-..-.."]
      ]
  return curveStyleList
#______________________________
def curveStyleAuto(name):
  value=0
  if name is None:
    value = 0
  else:
    if name == 'default':
      value = 0
    if name == 'random':
      value = 1

  return value
#_____________________________________
def nextCurveStyle():
    settings = QSettings()
    
    (curveStyle, test) = settings.value("earthbeat/curveStyleAuto", readDefaultCurveLine().getCurveStyle() ).toInt()

    globDefaultLineCurves = readDefaultCurveLine().getDefault()

    if (curveStyle == curveStyleAuto("random") ):
      # randomise color and symbols only
      symbolType =  globDefaultLineCurves['symbolType']
      if ( symbolType != QVariant(Qt.NoPen) ):
        symList = symbolList()
        colList = colorList()
        globDefaultLineCurves['symbolType'] = QVariant( symList[ random.randint(1, len(symList)-1 ) ][1] )
        globDefaultLineCurves['symbolColor'] = QVariant( QColor( colList[random.randint(0, 15)][1] ))

      globDefaultLineCurves['lineColor'] = QVariant( QColor(colList[ random.randint(0, 15) ][1]) )
        
    return globDefaultLineCurves 

#______________________________
class readDefaultGraphics():
  def __init__(self):
    settings = QSettings()
    self.xaxis_left = settings.value("earthbeat/xaxis/left", 1)
    self.xaxis_right = settings.value("earthbeat/xaxis/right", 0)
    self.xaxis_min = settings.value("earthbeat/xaxis/min", None)
    self.xaxis_max = settings.value("earthbeat/xaxis/max", None)
    self.xaxis_title = settings.value("earthbeat/xaxis/title", None)

    self.yaxis_bottom = settings.value("earthbeat/yaxis/bottom", 1)
    self.yaxis_top = settings.value("earthbeat/yaxis/top", 0)
    self.yaxis_min = settings.value("earthbeat/yaxis/min", None)
    self.yaxis_max = settings.value("earthbeat/yaxis/max", None)
    self.yaxis_title = settings.value("earthbeat/yaxis/title", None)

  def getDefault(self):
    return {"xaxis_left":self.xaxis_left,
            "xaxis_right":self.xaxis_right,
            "xaxis_min":self.xaxis_min, 
            "xaxis_max":self.xaxis_max,
            "xaxis_title":self.xaxis_title, 
            "yaxis_bottom":self.yaxis_bottom, 
            "yaxis_top":self.yaxis_top,
            "yaxis_min":self.yaxis_min,
            "yaxis_max":self.yaxis_max,
            "yaxis_title":self.yaxis_title 
            }
  def getXAxisLeft(self):
    return self.xaxis_left
  def getXAxisRight(self):
    return self.xaxis_right
  def getXAxisMin(self):
    return self.xaxis_min
  def getXAxisMax(self):
    return self.xaxis_max
  def getXAxisTitle(self):
    return self.xaxis_title
  def getYAxisBottom(self):
    return self.yaxis_bottom
  def getYAxisTop(self):
    return self.yaxis_top
  def getYAxisMin(self):
    return self.yaxis_min
  def getYAxisMax(self):
    return self.yaxis_max
  def getYAxisTitle(self):
    return self.yaxis_title

#______________________________
class readDefaultCurveLine():
  def __init__(self):
    settings = QSettings()
    self.curveType = settings.value("earthbeat/lineType", 1)
    self.curveColor = settings.value("earthbeat/lineColor", QVariant(QColor(Qt.black)) )
    self.curveThickness = settings.value("earthbeat/lineThickness", 1 )
    self.curveStyle = settings.value("earthbeat/curveStyleAuto", QVariant(curveStyleAuto('default')) )
    self.symbolType = settings.value("earthbeat/symbolType", QVariant( QwtSymbol.NoSymbol) )
    self.symbolColor = settings.value("earthbeat/symbolColor", QVariant(QColor(Qt.red)) )
    self.symbolBackColor = settings.value("earthbeat/symbolBackColor", QVariant(QColor(Qt.transparent)) )
    self.symbolSize = settings.value("earthbeat/symbolSize", 5)

  def getDefault(self):
    return {"lineType":self.curveType, "lineColor":self.curveColor, "lineThickness":self.curveThickness,
            "curveStyleAuto":self.curveStyle,
            "symbolType":self.symbolType, "symbolColor":self.symbolColor, "symbolBackColor":self.symbolBackColor, "symbolSize":self.symbolSize}
  def getCurveStyle(self):
    return self.curveStyle
  def getLineType(self):
    return self.curveType
  def getLineColor(self):
    return self.curveColor
  def getLineThickness(self):
    return self.curveThickness
  def getSymbolType(self):
    return self.symbolType
  def getSymbolColor(self):
    return self.symbolColor
  def getSymbolBackColor(self):
    self.symbolBackColor
  def getSymbolSize(self):
    return self.symbolSize
#______________________________
class SettingsPanel(QWidget):

  def __init__(self):
    QWidget.__init__(self)
    self.setupUi(self)

  def setupUi(self, panel):
    # menu: curves style, graphic style, time series, statistics, export
    verticalList = QtGui.QVBoxLayout(panel)
    curvesButton = QtGui.QPushButton("Curves style", panel)
    graphicButton = QtGui.QPushButton("Graphic style", panel)
    statisticsButton = QtGui.QPushButton("Processings (Beta)", panel)
    resetButton = QtGui.QPushButton("Reset all settings", panel)

    verticalList.addWidget(curvesButton)
    verticalList.addWidget(graphicButton)
    verticalList.addWidget(statisticsButton)
    verticalList.addWidget(resetButton)

    QObject.connect(curvesButton, SIGNAL("clicked()"), self.doCurvesPanel)
    QObject.connect(graphicButton, SIGNAL("clicked()"), self.doGraphicsPanel)
    QObject.connect(statisticsButton, SIGNAL("clicked()"), self.doStatisticsPanel)
    QObject.connect(resetButton, SIGNAL("clicked()"), self.resetAllSettings)

  def resetAllSettings(self):
    settings = QSettings()
    settings.beginGroup("earthbeat")
    settings.remove("")
    settings.endGroup()
    self.reEmit(SIGNAL('updatedParameters()')) 

  def doCurvesPanel(self):
    self.thisCurvesPanel = SettingsCurvesStylePanel()
    self.thisCurvesPanel.resize(220,150)
    self.thisCurvesPanel.setWindowTitle("EarthBeat: curves settings")
    self.thisCurvesPanel.show()

  def doGraphicsPanel(self):
    self.thisCurvesPanel = SettingsGraphicsPanel()
    QObject.connect(self.thisCurvesPanel, SIGNAL('updatedParameters()'), lambda : self.reEmit(SIGNAL('updatedParameters()')) )
    self.thisCurvesPanel.resize(400,100)
    self.thisCurvesPanel.setWindowTitle("EarthBeat: graphics settings")
    self.thisCurvesPanel.show()

  def doStatisticsPanel(self):
    self.thisProcessingsPanel = doProcessingsSettings()
    QObject.connect(self.thisProcessingsPanel, SIGNAL('updatedParameters()'), lambda : self.reEmit(SIGNAL('updatedParameters()')) )
    self.thisProcessingsPanel.resize(400,100)
    self.thisProcessingsPanel.setWindowTitle("EarthBeat: processings settings")
    self.thisProcessingsPanel.show()

  def reEmit(self, signal):
    self.emit(signal)
#_________________________________
class SettingsGraphicsPanel(QWidget):

  class myTextArea(QtGui.QLineEdit):
    def focusInEvent(self, focusEvent):
      self.emit(SIGNAL("inEdition"))
    def focusOutEvent(self, focusEvent):
      self.emit(SIGNAL("outEdition"))

  def __init__(self):
    QWidget.__init__(self)
    self.graphicsParam = readDefaultGraphics().getDefault()
    self.setupUi(self)

  def getParam(self):
    return self.graphicsParam

  def writeParam(self):
    global globDefaultGraphics
    settings = QSettings()
    # write to a file
    settings.setValue('earthbeat/xaxis/left', QVariant(self.graphicsParam['xaxis_left']) )
    settings.setValue('earthbeat/xaxis/right', QVariant(self.graphicsParam['xaxis_right']) )
    settings.setValue('earthbeat/xaxis/title', QVariant(self.graphicsParam['xaxis_title']) )
    settings.setValue('earthbeat/xaxis/min', QVariant(self.graphicsParam['xaxis_min']) )
    settings.setValue('earthbeat/xaxis/max', QVariant(self.graphicsParam['xaxis_max']) )

    settings.setValue('earthbeat/yaxis/bottom', QVariant(self.graphicsParam['yaxis_bottom']) )
    settings.setValue('earthbeat/yaxis/top', QVariant(self.graphicsParam['yaxis_top']) )
    settings.setValue('earthbeat/yaxis/title', QVariant(self.graphicsParam['yaxis_title'] ) )
    settings.setValue('earthbeat/yaxis/min', QVariant(self.graphicsParam['yaxis_min']) )
    settings.setValue('earthbeat/yaxis/max', QVariant(self.graphicsParam['yaxis_max']) )

    globDefaultGraphics = readDefaultGraphics().getDefault()

    self.emit(SIGNAL('updatedParameters()'))

  def setupUi(self, panel):
    vbox = QtGui.QVBoxLayout(panel)
    vbox.setDirection(QBoxLayout.TopToBottom)
    # X-Axis
    labelXAxis = QtGui.QLabel("X Axis", panel)
    vbox.addWidget(labelXAxis)

    hboxXLR = QtGui.QHBoxLayout()
    vbox.addLayout(hboxXLR)
    xlrLabel = QtGui.QLabel(QString("Display axis on: "), panel)
    self.xLeft = QtGui.QCheckBox(QString("left"), panel)
    (setVal, test) = self.graphicsParam['xaxis_left'].toInt()
    self.xLeft.setChecked( bool(setVal) )
    self.xRight = QtGui.QCheckBox(QString("Right"), panel)
    (setVal, test) = self.graphicsParam['xaxis_right'].toInt()
    self.xRight.setChecked( bool(setVal) )
    QObject.connect(self.xLeft, SIGNAL("stateChanged(int)"), lambda : self.setCheckboxValue("xleft") )
    QObject.connect(self.xRight, SIGNAL("stateChanged(int)"), lambda : self.setCheckboxValue("xright") )
    hboxXLR.addWidget(xlrLabel)
    hboxXLR.addWidget(self.xLeft)
    hboxXLR.addWidget(self.xRight)
 
    hbX = QtGui.QHBoxLayout()
    vbox.addLayout(hbX)
    self.minX = self.myTextArea()
    self.maxX = self.myTextArea()
    self.titleX = self.myTextArea()
    hbX.addWidget(QtGui.QLabel("min"))
    hbX.addWidget(self.minX)
    (setVal, test) =  self.graphicsParam['xaxis_min'].toFloat()
    if test == False:
      self.minX.setText('auto')
    else:
      self.minX.setText( str(setVal) )
    QObject.connect(self.minX, SIGNAL("inEdition") , lambda : self.setMinMaxBoxValue(self.minX))
    QObject.connect(self.minX, SIGNAL("outEdition"), lambda : self.checkMinMaxBoxValue(self.minX))
    hbX.addWidget(QtGui.QLabel("max"))
    hbX.addWidget(self.maxX)
    (setVal, test) =  self.graphicsParam['xaxis_max'].toFloat()
    if test == False:
      self.maxX.setText('auto')
    else:
      self.maxX.setText( str(setVal) )
    QObject.connect(self.maxX, SIGNAL("inEdition") , lambda : self.setMinMaxBoxValue(self.maxX))
    QObject.connect(self.maxX, SIGNAL("outEdition") , lambda : self.checkMinMaxBoxValue(self.maxX))
    hbX.addWidget(QtGui.QLabel("title"))
    hbX.addWidget(self.titleX)
    setVal = self.graphicsParam['xaxis_title']
    self.titleX.setText( setVal.toString() )
    QObject.connect(self.titleX, SIGNAL('outEdition'), self.saveTitle )

    # Y-Axis
    labelYAxis = QtGui.QLabel("Y Axis", panel)
    vbox.addWidget(labelYAxis)
    
    hboxYUD = QtGui.QHBoxLayout()
    vbox.addLayout(hboxYUD)

    yudLabel = QtGui.QLabel(QString("Display axis on: "), panel)
    self.yDown = QtGui.QCheckBox(QString("Bottom"), panel)
    (setVal, test) = self.graphicsParam["yaxis_bottom"].toInt()
    self.yDown.setChecked( bool(setVal) )
    self.yUp = QtGui.QCheckBox(QString("Top"), panel)
    (setVal, test) = self.graphicsParam["yaxis_top"].toInt()
    self.yUp.setChecked( bool(setVal) )
    QObject.connect(self.yDown, SIGNAL("stateChanged(int)"), lambda : self.setCheckboxValue("ybottom") )
    QObject.connect(self.yUp, SIGNAL("stateChanged(int)"), lambda : self.setCheckboxValue("ytop") )
    hboxYUD.addWidget(yudLabel)
    hboxYUD.addWidget(self.yDown)
    hboxYUD.addWidget(self.yUp)

    hbY = QtGui.QHBoxLayout()
    vbox.addLayout(hbY)
    self.minY = self.myTextArea()
    self.maxY = self.myTextArea()
    self.titleY = self.myTextArea()
    hbY.addWidget(QtGui.QLabel("min"))
    hbY.addWidget(self.minY)
    (setVal, test) = self.graphicsParam['yaxis_min'].toFloat()
    if test==False:
      self.minY.setText('auto')
    else:
      self.minY.setText(str(setVal))
    QObject.connect(self.minY, SIGNAL("inEdition") , lambda : self.setMinMaxBoxValue(self.minY))
    QObject.connect(self.minY, SIGNAL("outEdition") , lambda : self.checkMinMaxBoxValue(self.minY))
    hbY.addWidget(QtGui.QLabel("max"))
    hbY.addWidget(self.maxY)
    (setVal, test) = self.graphicsParam['yaxis_max'].toFloat()
    if test==False:
      self.maxY.setText('auto')
    else:
      self.maxY.setText(str(setVal))
    QObject.connect(self.maxY, SIGNAL("inEdition") , lambda : self.setMinMaxBoxValue(self.maxY))
    QObject.connect(self.maxY, SIGNAL("outEdition") , lambda : self.checkMinMaxBoxValue(self.maxY))
    hbY.addWidget(QtGui.QLabel("title"))
    hbY.addWidget(self.titleY)
    setVal = self.graphicsParam['yaxis_title']
    self.titleY.setText( setVal.toString() )
    QObject.connect(self.titleX, SIGNAL('outEdition'), self.saveTitle )

  def saveTitle(self):
    self.graphicsParam['xaxis_title'] = self.titleX.text()
    self.graphicsParam['yaxis_title'] = self.titleY.text()

  def setMinMaxBoxValue(self, w):
    if w.text()=='auto':
      w.setText('')
      
  def checkMinMaxBoxValue(self, w):
    # check current input
    try:
      value = float(w.text())
    except ValueError:
      value = 'auto'
    w.setText(str(value))
    # check them all (as we don't know which widget was passed in parameter)
    try:
      minx = float(self.minX.text())
      try:
        maxx = float(self.maxX.text())
        if minx > maxx:
          # bad value, reset to auto
          w.setText('auto')
      except ValueError:
        # any minX is ok
        pass
 
    except ValueError:
      # anything ok for minX/maxX
      pass
    # same idea for minY/maxY
    try:
      miny = float(self.minY.text())
      try:
        maxy = float(self.maxY.text())
        if miny > maxy:
          # bad value, reset to auto
          w.setText('auto')
      except ValueError:
        # any minY is ok
        pass
    except ValueError:
      # anything ok for minX/maxX
      pass
    # save them all
    self.graphicsParam['xaxis_min'] = self.minX.text()
    self.graphicsParam['xaxis_max'] = self.maxX.text()
    self.graphicsParam['yaxis_min'] = self.minY.text()
    self.graphicsParam['yaxis_max'] = self.maxY.text()

  def setCheckboxValue(self, name):
    if name == 'xleft':
      if self.xLeft.checkState():
        self.graphicsParam["xaxis_left"] = 1
      else:
        self.graphicsParam["xaxis_left"] = 0
    if name == 'xright':
      if self.xRight.checkState():
        self.graphicsParam["xaxis_right"] = 1
      else:
        self.graphicsParam["xaxis_right"] = 0
    if name == 'ybottom':
      if self.yDown.checkState():
        self.graphicsParam["yaxis_bottom"] = 1
      else:
        self.graphicsParam["yaxis_bottom"] = 0
    if name == 'ytop':
      if self.yUp.checkState():
        self.graphicsParam["yaxis_top"] = 1
      else:
        self.graphicsParam["yaxis_top"] = 0

  def closeEvent(self, event):
    # in case outFocus was not done (window closed immediately after input), check/save axis min/max
    self.checkMinMaxBoxValue(self.minX)
    self.checkMinMaxBoxValue(self.maxX)
    self.checkMinMaxBoxValue(self.minY)
    self.checkMinMaxBoxValue(self.maxY)
    # in case outFocus was not done (window closed immediately after input), save axis titles
    self.graphicsParam['xaxis_title'] = self.titleX.text()
    self.graphicsParam['yaxis_title'] = self.titleY.text()
    # write all parameters to config file
    self.writeParam()
    event.accept()

#_________________________________
class SettingsCurvesStylePanel(QWidget):
  def __init__(self):
    QWidget.__init__(self)
    self.setupUi(self)
    
  def setupUi(self, panel):
    settings = QSettings()

    vbox = QtGui.QVBoxLayout(panel)
    editDefaultButton = QtGui.QPushButton("Edit default settings", panel)
    editDefaultButton.setFixedWidth(200)
    editCurvesListProp = QtGui.QPushButton("Edit curves list properties", panel)
    editCurvesListProp.setFixedWidth(200)
    newCurvesLabel = QtGui.QLabel("New curves style is:")
    newCurvesLabel.setContentsMargins(0,0,0,0)
    self.newCurvesRG = QtGui.QButtonGroup(panel)
    defaultRadio = QtGui.QRadioButton("default style",panel)
    randomRadio = QtGui.QRadioButton("random style", panel)
    defaultRadio.setChecked(False)
    randomRadio.setChecked(False)
    (curveStyle, test) = settings.value("earthbeat/curveStyleAuto", readDefaultCurveLine().getCurveStyle() ).toInt()
    if curveStyle == 0:
      defaultRadio.setChecked(True)
    if curveStyle == 1:
      randomRadio.setChecked(True)
    vbox.addWidget(editDefaultButton)
    vbox.addWidget(editCurvesListProp)
    vbox.addSpacing(20)
    vbox.addWidget(newCurvesLabel)
    vbox.addWidget(defaultRadio)
    vbox.addWidget(randomRadio)
    self.newCurvesRG.addButton(defaultRadio)
    a=curveStyleAuto('default')
    self.newCurvesRG.setId(defaultRadio, curveStyleAuto('default') )
    self.newCurvesRG.addButton(randomRadio)
    self.newCurvesRG.setId(randomRadio, curveStyleAuto('random') )

    QObject.connect(editDefaultButton, SIGNAL("clicked()"), self.settingsCurvesSymbols)
    QObject.connect(editCurvesListProp, SIGNAL("clicked()"), self.settingsCurvesProperties)

  def settingsCurvesSymbols(self):
    self.thisPanel = CurvesSymbolsPanel()
    self.thisPanel.resize(500,250)
    self.thisPanel.setWindowTitle("Earthbeat: default curves properties")
    self.thisPanel.show()

  def settingsCurvesProperties(self):
    print

  def closeEvent(self, event):
    global globalDefaultLineCurves
    settings = QSettings()
    settings.setValue("earthbeat/curveStyleAuto", QVariant(self.newCurvesRG.checkedId() ) )
    globalDefaultLineCurves=readDefaultCurveLine().getDefault()
    event.accept()
#________________________________
class CurvesSymbolsPanel(QWidget):
  def __init__(self, curveIdIn=None):
    # init for default settings
    self.curveId = curveIdIn
    QWidget.__init__(self)
    self.setupUi(self)

  def setupUi(self, panel):
    settings = QSettings()
    # main hbox
    hbox = QtGui.QHBoxLayout(panel)

    # graphic display on left
    self.curvePort = QwtPlot()
    sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Fixed)
    sizePolicy.setHorizontalStretch(0)
    sizePolicy.setVerticalStretch(0)
    sizePolicy.setHeightForWidth(self.curvePort.sizePolicy().hasHeightForWidth())
    self.curvePort.setSizePolicy(sizePolicy)
    hbox.addWidget(self.curvePort)

    # action widget container
    vboxAction = QtGui.QVBoxLayout()
    curvesLabel = QtGui.QLabel(QString("Curves") )
    hboxCurves = QtGui.QHBoxLayout()
    symbolsLabel = QtGui.QLabel(QString("Symbols") )
    hboxSymbols = QtGui.QHBoxLayout()
    hbox.addLayout(vboxAction)
    vboxAction.addWidget(curvesLabel)
    vboxAction.addLayout(hboxCurves)
    vboxAction.addSpacing(10)
    vboxAction.addWidget(symbolsLabel)
    vboxAction.addLayout(hboxSymbols)
    vboxAction.addSpacing(50)

    # hboxCurves
    self.LTButton = QtGui.QPushButton("&Lines")
    self.menuLines = QtGui.QMenu()
    self.lstMenuLines=[]
    listLines = curveStyleList()
    for ii in range(len(listLines)):
      self.thisAction = QtGui.QAction(listLines[ii][2], panel)
      self.thisAction.setData(ii)
      receiver = lambda ii=ii : self.linesMenuSet(listLines[ii][1])
      QObject.connect(self.thisAction, SIGNAL("triggered()"), receiver )
      self.menuLines.addAction(self.thisAction)
      self.lstMenuLines.append(self.thisAction)

    self.LTButton.setMenu(self.menuLines)

    LCButton = QtGui.QPushButton(QString("Color") )
    self.LWButton = QtGui.QDoubleSpinBox()
    self.LWButton.setMinimum(0)
    self.LWButton.setMaximum(10)
    self.LWButton.setSingleStep(0.25)
    self.LWButton.setDecimals(2)
    (lineWidthInit, test) = settings.value("earthbeat/lineThickness", readDefaultCurveLine().getLineThickness() ).toFloat()
    self.LWButton.setValue( lineWidthInit )
    hboxCurves.addWidget(self.LTButton)
    hboxCurves.addWidget(LCButton)
    hboxCurves.addWidget(self.LWButton)
    hboxCurves.addSpacing(100)

    # hboxSymbols
    #self.STButton = QtGui.QMenuBar()
    self.STButton = QtGui.QPushButton("&Symbols   ")
    self.menuSymbol = QtGui.QMenu()
    self.lstMenuSymbol=[]
    listSymbol = symbolList()
    for ii in range(len(listSymbol)):
      self.thisAction = QtGui.QAction(listSymbol[ii][2], panel)
      self.thisAction.setData(ii)
      receiver = lambda ii=ii: self.symbolMenuSet(listSymbol[ii][1])
      QObject.connect(self.thisAction, SIGNAL("triggered()"), receiver )
      self.menuSymbol.addAction(self.thisAction)
      self.lstMenuSymbol.append(self.thisAction)

    self.STButton.setMenu(self.menuSymbol)
    
    SCButton = QtGui.QPushButton(QString("Color") )
    SCBButton = QtGui.QPushButton(QString("Bckgrd") )
    self.SWButton = QtGui.QDoubleSpinBox()
 
    self.SWButton.setMinimum(0)
    self.SWButton.setMaximum(20)
    self.SWButton.setSingleStep(0.5)
    self.SWButton.setDecimals(1)
    (symbolSizeInit, test) = settings.value("earthbeat/symbolSize", readDefaultCurveLine().getSymbolSize() ).toFloat()
    self.SWButton.setValue(symbolSizeInit)
    hboxSymbols.addWidget(self.STButton)
    hboxSymbols.addWidget(SCButton)
    hboxSymbols.addWidget(SCBButton)
    hboxSymbols.addWidget(self.SWButton)
    
    QObject.connect(LCButton, SIGNAL("clicked()"), self.colorLine)
    QObject.connect(SCButton, SIGNAL("clicked()"), self.colorSymbol)
    QObject.connect(SCBButton, SIGNAL("clicked()"), self.colorBackSymbol)
    QObject.connect(self.LWButton, SIGNAL("valueChanged( double )"), self.drawCurveSymbols)
    QObject.connect(self.SWButton, SIGNAL("valueChanged( double )"), self.drawCurveSymbols)

    self.drawCurveSymbols()

  #______________________
  def linesMenuSet(self, line):
    settings = QSettings()
    settings.setValue("earthbeat/lineType", QVariant(line) )

    self.drawCurveSymbols()
  #___________________
  def colorLine(self):
    settings = QSettings()
    defaultColor = settings.value("earthbeat/lineColor", QVariant(QColor(readDefaultCurveLine().getLineColor() )))
    thisColor = QColorDialog.getColor(QColor(defaultColor), self, 'line color', QColorDialog.ShowAlphaChannel)
    if (thisColor is not None):
      settings.setValue("earthbeat/lineColor", QVariant(QColor(thisColor)) )

    self.drawCurveSymbols()

  #_____________________
  def colorSymbol(self):
    settings = QSettings()
    defaultColor = settings.value("earthbeat/symbolColor", QVariant(QColor(readDefaultCurveLine().getSymbolColor() )))
    thisColor = QColorDialog.getColor(QColor(defaultColor), self, 'symbol color', QColorDialog.ShowAlphaChannel)
    if (thisColor is not None):
      settings.setValue("earthbeat/symbolColor", QVariant(QColor(thisColor)) )

    self.drawCurveSymbols()

  #_________________________
  def colorBackSymbol(self):
    settings = QSettings()
    defaultColor = settings.value("earthbeat/symbolBackColor", QVariant(QColor(readDefaultCurveLine().getSymbolBackColor() )))
    thisColor = QColorDialog.getColor(QColor(defaultColor), self, 'symbol background color', QColorDialog.ShowAlphaChannel)
    if (thisColor is not None):
      settings.setValue("earthbeat/symbolBackColor", QVariant(QColor(thisColor)) )

    self.drawCurveSymbols()

  #_______________________
  def symbolMenuSet(self, symbol):
    settings = QSettings()
    settings.setValue("earthbeat/symbolType", QVariant(symbol) )

    self.drawCurveSymbols()
  #__________________________
  def drawCurveSymbols(self):
    settings = QSettings()
    penColor = settings.value("earthbeat/lineColor", QVariant(QColor(readDefaultCurveLine().getLineColor())) )
    (symbolType,test) = settings.value("earthbeat/symbolType", QVariant(readDefaultCurveLine().getSymbolType()) ).toInt()
    (lineType, test) = settings.value("earthbeat/lineType", QVariant(readDefaultCurveLine().getLineType()) ).toInt()
    symbolColor = settings.value("earthbeat/symbolColor", QVariant( QColor(readDefaultCurveLine().getSymbolColor()) ) )    
    symbolBackColor = settings.value("earthbeat/symbolBackColor", QVariant(QColor(readDefaultCurveLine().getSymbolBackColor())) )
    thisPen = QPen(QColor(penColor), self.LWButton.value()) # with initialised w spinbox
    thisPen.setStyle(lineType)

    self.curvePort.detachItems()
    self.curve=QwtPlotCurve()
    self.curve.attach(self.curvePort)
    self.curve.setData([0.5, 2, 3, 4.3], [0.2, 1.7, 1, 1.5])
    self.curve.setPen(thisPen)
    self.curve.setSymbol(QwtSymbol(symbolType,
                                   QBrush(QColor(symbolBackColor)),
                                   QPen(QColor(symbolColor), 1),
                                   QSize(self.SWButton.value(), self.SWButton.value() )
                                   ))
    self.curvePort.setAxisScale(QwtPlot.yLeft, 0, 2)
    self.curvePort.setAxisScale(QwtPlot.xBottom, 0, 5)
    self.curvePort.replot()

  def closeEvent(self, event):
    global globDefaultLineCurves
    settings = QSettings()
    settings.setValue("earthbeat/lineThickness", QVariant(self.LWButton.value()) )
    settings.setValue("earthbeat/symbolSize", QVariant(self.SWButton.value()) )
    globDefaultLineCurves = readDefaultCurveLine().getDefault()
    event.accept()
#________________________________
class ChooseSymbolType(QWidget):

  def __init__(self):
    QWidget.__init__(self)
    self.setupUi(self)

  def setupUi(self, panel):
    listSymbol = symbolList()

    nlines = math.ceil(len(listSymbol) / 4.0)

    vbox = QtGui.QVBoxLayout(panel)
    self.radioStyleGroup = QtGui.QButtonGroup(panel)
    for ilines in range(nlines):
      hbox = QtGui.QHBoxLayout()
      vbox.addLayout(hbox)
      for irow in range(4):
        ipos = 4 * ilines + irow
        if (ipos < len(listSymbol) ):
          vboxLocal = QtGui.QVBoxLayout()
          hbox.addLayout(vboxLocal)
          thisPlot = QwtPlot()
          thisPlot.setBaseSize(50,50)
          thisPlot.setMaximumSize(50,50)
          thisPlot.setMinimumSize(50,50)
          thisPlot.detachItems()
          thisPlot.enableAxis(QwtPlot.xTop, False)
          thisPlot.enableAxis(QwtPlot.xBottom, False)
          thisPlot.enableAxis(QwtPlot.yLeft, False)
          thisPlot.enableAxis(QwtPlot.yRight, False)
          noCurve = QwtPlotCurve()
          noCurve.setSymbol(QwtSymbol(listSymbol[ipos][1],
                                      QBrush(Qt.white),
                                      QPen(Qt.red, 2),
                                      QSize(30,30)))
          noCurve.attach(thisPlot)
          noCurve.setData([0],[0])
          vboxLocal.addWidget(thisPlot)
          thisPlot.replot()
          thisPlot.setFocus()
          self.radioSymbol = QRadioButton("",panel)
          vboxLocal.addWidget(self.radioSymbol)
          self.radioStyleGroup.addButton(self.radioSymbol)
          self.radioStyleGroup.setId(self.radioSymbol, ipos)

  def closeEvent(self, event):
    global globDefaultLineCurves
    settings = QSettings()
    settings.setValue("earthbeat/symbolType", QVariant(self.radioStyleGroup.checkedId()))
    globDefaultLineCurves = readDefaultCurveLine().getDefault()
    event.accept()
#________________________________
