"""
/***************************************************************************
         Earth Beat      - how is your Earth beating?
                             -------------------
    begin                : 2011 - 12 - 01
    copyright            : (C) 2011 Bruno Combal
    email                : bruno(dot)combal(at)gmail(dot)com
 ***************************************************************************/

 This script initializes the plugin, making it known to QGIS.
"""
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
import numpy

from PyQt4.Qwt5 import QwtPlot,QwtPlotCurve,QwtScaleDiv,QwtSymbol

globDefaultLineCurves = {}
globDefaultGraphics = {}
globDefaultProcessings = {}

from earthbeatwidgetbase import Ui_Form
#from UIEarthBeatDock import Ui_earthbeatDock
from doSettings import *
from doExportDataCollection import *
from Marker import *

def antiDropsFitter(yIn):
    y=yIn
    for ii in range(1, len(y)-1):
        if ( (y[ii]-y[ii-1]) < 0) and ( (y[ii+1]-y[ii]) > 0 ):
            y[ii] = 0.5*(y[ii+1]+y[ii-1])
    return y


#_____________________________________
#class EarthBeatWidget(QWidget, Ui_earthbeatDock ):
class EarthBeatWidget(QWidget, Ui_Form):
    def __init__(self, iface, canvas):

        global globDefaultLineCurves
        global globDefaultGraphics
        global globDefaultProcessings

        QWidget.__init__(self)
#        Ui_earthbeatDock.__init__(self)
        Ui_Form.__init__(self) 
        self.setupUi(self)

        self.iface = iface
        self.canvas = canvas

        self.markerLayer = Marker(self.iface, self.canvas)
        #self.markerLayer.createMarkerLayer()

        self.x = None
        self.y = None
        self.pinPos = None
        self.pinPosX = None
        self.pinPosY = None
        self.currentS = nextCurveStyle()

        self.arrX = []
        self.arrY = []
        self.arrP = []
        self.arrS = []
        self.arrStats = []

        globDefaultLineCurves = readDefaultCurveLine().getDefault()
        globDefaultGraphics = readDefaultGraphics().getDefault()
        globDefaultProcessings = readDefaultProcessings().getDefault()

        QObject.connect(self.activateProfile, SIGNAL("stateChanged(int)"), self.changeActive)
        self.changeActive(Qt.Checked)
        QObject.connect(self.canvas, SIGNAL( "keyPressed( QKeyEvent * )" ), self.pauseDisplay )
        QObject.connect(self.settingsButton, SIGNAL("clicked()"), self.settingsPage)
        QObject.connect(self.infoButton, SIGNAL("clicked()"), self.infoPage)
        QObject.connect(self.clearCollectionButton, SIGNAL("clicked()"), self.clearPlot)
        QObject.connect(self.exportCollectionButton, SIGNAL("clicked()"), self.exportPlotData)

        # qwtPlot
#        self.qwtPlot = QwtPlot(self)
#        self.qwtPlot.setAutoFillBackground(False)
#        self.qwtPlot.setObjectName("qwtPlot")
#        sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Expanding,QtGui.QSizePolicy.Expanding)
#        sizePolicy.setHorizontalStretch(0)
#        sizePolicy.setVerticalStretch(0)
#        #sizePolicy.setHeightForWidth(self.qwtPlot.sizePolicy().hasHeightForWidth())
#        self.qwtPlot.setSizePolicy(sizePolicy)
        self.qwtPlot.setAutoDelete(True)
#        self.verticalLayout.addWidget(self.qwtPlot)

    #________________________
    def settingsPage(self):
        self.settingsPanel = SettingsPanel()
        QObject.connect(self.settingsPanel, SIGNAL('updatedParameters()'), self.onParametersUpdated)
        self.settingsPanel.resize(120, 250)
        self.settingsPanel.move(300,300)
        self.settingsPanel.setWindowTitle("EarthBeat settings")
        self.settingsPanel.show()
    #________________________
    def infoPage(self):
        QMessageBox.about(self, "How is your Earth beating?",
                          """EarthBeat displays pixels' time series/spectral signatures.<br/>
Install the plugin, load a multi-layer image, hover the mouse on this image
to see each pixel profile.<br/>
<b>Keys</b><br/>
[SHIFT + A] : toggle the display<br/>
[C] : to save a profile.<br/>
<b>Hints</b><br/>
You can detach the profile display window from the "Layers" dock, and re-attach it by dropping it inside.<br/>
After changing settings, close the window to apply changes.<br/>
Settings are permanently saved and are restored when restarting QGis.<br/>
Profiles and their locations are stored as a vector file. To save it as a shapefile, CVS, ... use the contextual menu of the layer named "Earthbeat places"<br/>
<b>Author:</b> Bruno Combal<br/>
<b>Contact:</b> firstname.name (at) gmaildotcom<br/>
<b>Version: </b> 0.77"""
)
    #________________________
    def disconnect(self):
        self.changeActive(False)
        QObject.disconnect(self.canvas, SIGNAL( "keyPressed( QKeyEvent * )" ), self.pauseDisplay )
    #________________________
    def pauseDisplay(self,e):

        if ( e.modifiers() == Qt.ShiftModifier or e.modifiers() == Qt.MetaModifier ) and e.key() == Qt.Key_A:
            self.activateProfile.toggle()
            if (len(self.arrY)>0):
                self.plot(self.arrX, self.arrY, self.arrS)
            return True

        return False
    #________________________
    def clearPlot(self):
        # clear plot
        # delete saved data
        # delete markers layer
        self.arrX = []
        self.arrY = []
        self.arrP = []
        self.arrS = []
        self.arrStats = []
        self.qwtPlot.detachItems()
        self.qwtPlot.replot()
        self.markerLayer.deleteMarkerLayer()
    #_________________________
    def exportPlotData(self):
        self.exportPanel = ExportPanel(self.qwtPlot)
        self.exportPanel.resize(500,200)
        self.exportPanel.setWindowTitle("EarthBeat export")
        self.exportPanel.show()
    #___________________________
    def changeActive(self, state):
        # assumes QGIS > 1.7.4
        if (state==Qt.Checked):
            QObject.connect(self.canvas, SIGNAL("xyCoordinates(const QgsPoint &)"), self.plotValues)
            QObject.connect(self.canvas, SIGNAL( "keyPressed( QKeyEvent * )"), self.collectPlotValues)
        else:
            QObject.disconnect(self.canvas, SIGNAL("xyCoordinates(const QgsPoint &)"), self.plotValues)
            if (len(self.arrY)>0):
                self.plot(self.arrX, self.arrY, self.arrS, self.arrStats)
            QObject.disconnect(self.canvas, SIGNAL( "keyPressed( QKeyEvent * )"), self.collectPlotValues)
    #_____________________________
    def getValues(self, position):
        # read data from a multiband file
        # returns [x,y] vector
        x=[]
        y=[]
        thisPos = mapPos = position
        listLayers=[]
        mapCanvasCrs = self.iface.mapCanvas().mapRenderer().destinationCrs()

        # step 1: collect layers to display
        for ii in range(self.canvas.layerCount()):
            layer = self.canvas.layer(ii)
            if (layer!=None and layer.isValid() and layer.type()==QgsMapLayer.RasterLayer):
                if layer.providerKey()=="wms":
                    # can't handle wms for now
                    continue
                elif layer.providerKey()=="grassraster":
                    # grass raster
                    listLayers.append(layer)
                else:
                    # classical raster
                    listLayers.append(layer)

        # step 2: parse the list of valid layers and get pixel value
        for ilayer in listLayers:
            # if this layer has a different crs, convert into the canvas crs
            thisPos=mapPos
            try:
                if not ilayer.crs()==mapCanvasCrs and self.iface.mapCanvas().hasCrsTransformEnabled():
                    thisPos=QgsCoordinateTransform(mapCanvasCrs, ilayer.srs()).transform(mapPos)
            # get value
                isok, ident = ilayer.identify(thisPos)
   
            except QgsCsException, err:
                print 'QgsCsException caught.'
                continue

            if ilayer.providerKey()=="grassraster":
                # to be implemented
                continue
            else:
                for iband in range(1, ilayer.bandCount()+1):
                    val=ident[ilayer.bandName(iband)].toDouble()
                    if val[1]:
                        # keep data if "true"
                        y.append(val[0])
                        x.append(ilayer.bandName(iband))

        return x,y, thisPos
    #______________________________
    def onParametersUpdated(self):
        global globDefaultGraphics
        global globDefaultLineCurves
        global globDefaultProcessings

        # reload data
        globDefaultGraphics = readDefaultGraphics().getDefault()
        globDefaultLineCurves = readDefaultCurveLine().getDefault()
        globDefaultProcessings = readDefaultProcessings().getDefault()

        # redraw plot
        self.repaint()
        self.qwtPlot.updateAxes()
        self.qwtPlot.replot()
        self.repaint()
    #______________________________
    def plotValues(self, position):

        self.x , self.y, self.pinPos = self.getValues(position)
        self.pinPosX = self.pinPos.x()
        self.pinPosY = self.pinPos.y()

        if len(self.y)>1:
            thisXX = []
            thisYY = []
            thisSS = []
            thisStats = []
            thisXX.append(self.x)
            thisYY.append(self.y)
            thisSS.append(self.currentS )
            thisStats.append( [numpy.min(self.y), numpy.max(self.y), numpy.mean(self.y)] )

            if len(self.arrY)>0:
                for ii in self.arrX:
                    thisXX.append(ii)
                for ii in self.arrY:
                    thisYY.append(ii)
                for ii in self.arrS:
                    thisSS.append(ii)
                for ii in self.arrStats:
                    thisStats.append(ii)

            self.plot(thisXX, thisYY, thisSS, thisStats)
    #______________________________
    def collectPlotValues(self, e):

        if (e.key() == Qt.Key_C):
            if len(self.y)>1:
                self.arrX.append(self.x)
                self.arrY.append(self.y)
                self.arrStats.append([numpy.min(self.y), numpy.max(self.y), numpy.mean(self.y)])
                self.arrP.append([self.pinPosX, self.pinPosY])
                self.markerLayer.place_pin(self.pinPosX, self.pinPosY, self.arrY[-1], self.arrStats[-1])
                self.arrS.append(self.currentS)
                self.currentS = nextCurveStyle()
            return True

        return False
    #____________________________
    def plot(self, x, y, inStyles, dataStats):

        minY=[]
        maxY=[]
        lstCurve=[]
        self.qwtPlot.detachItems()
        
        (drawStats, test) = globDefaultProcessings['statsCheck'].toInt()
        statsXAxis = False
        statsYAxis = False
        if drawStats:
            (statsYAxis, test) = globDefaultProcessings['statsViewAxisCheck'].toInt()
            (statsXAxis, test) = globDefaultProcessings['statsViewBandCheck'].toInt()

        (antiDropsFit, test) = globDefaultProcessings['antiDrops'].toInt()
        (showCorrectRadio, test) = globDefaultProcessings['showCorrectDrops'].toInt()
        (showOrgCorrectRadio, test) = globDefaultProcessings['showOrgCorrectDrops'].toInt()

        for ii in range(len(y)): # loop over series
            minCurve = numpy.min(y[ii])
            xMinCurve = y[ii].index(minCurve) + 1
            maxCurve = numpy.max(y[ii])
            xMaxCurve = y[ii].index(maxCurve) + 1
            meanCurve = numpy.mean(y[ii])
           
            minY.append(minCurve)
            maxY.append(maxCurve)

            if (antiDropsFit == 0) or ( antiDropsFit>0 and showOrgCorrectRadio>0) :
                (penWidth, test) = inStyles[ii]['lineThickness'].toFloat()
                (lineType, test) = inStyles[ii]['lineType'].toInt()
                symbolColor = inStyles[ii]['symbolColor']
                (symbolType, test) = inStyles[ii]['symbolType'].toInt()
                symbolBackColor = inStyles[ii]['symbolBackColor']
                (symbolSize, test) = inStyles[ii]['symbolSize'].toFloat()
                
                thisPen = QPen(QColor(inStyles[ii]['lineColor']), penWidth, lineType)
                
                tmpCurve = QwtPlotCurve()
                tmpCurve.setSymbol(QwtSymbol(
                        symbolType, QBrush(QColor(symbolBackColor)), QPen(QColor(symbolColor), 0), QSize(symbolSize, symbolSize) 
                        ))

                tmpCurve.setPen(thisPen)
                tmpCurve.attach(self.qwtPlot)
                tmpCurve.setData(range(1, len(y[ii])+1), y[ii])
    #            lstCurve.append(tmpCurve)


            # draw interpolated curve
            if antiDropsFit:
                fittedY = antiDropsFitter(y[ii])
                fittedCurve = QwtPlotCurve()
                thisPen=QPen(QColor(Qt.red), 1, Qt.DashLine)
                fittedCurve.setPen(thisPen)
                fittedCurve.attach(self.qwtPlot)
                fittedCurve.setData( range(1, len(fittedY) + 1), fittedY)

            # draw stats
            if drawStats:
                minPlot = QwtPlotMarker()
                minPlot.setXValue(xMinCurve)
                minPlot.setYValue(minCurve)
                minPlot.attach(self.qwtPlot)   
                minPlot.setSymbol(QwtSymbol(
                        QwtSymbol.Ellipse, QBrush(QColor(Qt.red)), QPen(QColor(Qt.red), 0), QSize(5, 5) 
                ))
                maxPlot = QwtPlotMarker()
                maxPlot.setXValue(xMaxCurve)
                maxPlot.setYValue(maxCurve)
                maxPlot.attach(self.qwtPlot)
                maxPlot.setSymbol(QwtSymbol(
                        QwtSymbol.Ellipse, QBrush(QColor(Qt.green)), QPen(QColor(Qt.red), 0), QSize(5, 5) 
                ) )
                if statsXAxis>0 or statsYAxis>0:
                    minPen = QPen(QColor(Qt.blue), 1, Qt.DashLine)
                    xLineMin = QwtPlotCurve()
                    xLineMin.setSymbol(QwtSymbol(QwtSymbol.NoSymbol,QBrush(QColor(Qt.green)), QPen(QColor(Qt.red), 0) , QSize(1,1)) )
                    xLineMin.setPen(minPen)
                    xLineMin.attach(self.qwtPlot)
                    maxPen = QPen(QColor(Qt.blue), 1.5, Qt.DashLine)
                    xLineMax = QwtPlotCurve()
                    xLineMax.setSymbol(QwtSymbol(QwtSymbol.NoSymbol,QBrush(QColor(Qt.green)), QPen(QColor(Qt.red), 0) , QSize(1,1)) )
                    xLineMax.setPen(maxPen)
                    xLineMax.attach(self.qwtPlot)
                    
                    minDataX = []
                    minDataY = []
                    maxDataX = []
                    maxDataY = []
                    if statsXAxis:
                        minDataX = [xMinCurve, xMinCurve]
                        minDataY = [0,minCurve]
                        maxDataX = [xMaxCurve, xMaxCurve]
                        maxDataY = [0, maxCurve]
                    if statsYAxis:
                        minDataX += [xMinCurve, 0]
                        minDataY += [minCurve, minCurve]
                        maxDataX += [xMaxCurve, 0]
                        maxDataY += [maxCurve, maxCurve]
                    xLineMin.setData(minDataX, minDataY)
                    xLineMax.setData(maxDataX, maxDataY)

       # Y axis title
        (yaxis_min, test) = globDefaultGraphics['yaxis_min'].toFloat()
        if not test:
            yaxis_min=min(minY)
        (yaxis_max, test) = globDefaultGraphics['yaxis_max'].toFloat()
        if not test:
            yaxis_max=max(maxY)

        (leftAxis, test) = globDefaultGraphics['xaxis_left'].toInt() 
        if leftAxis==1:
            self.qwtPlot.enableAxis(QwtPlot.yLeft, True)
            self.qwtPlot.setAxisScale(QwtPlot.yLeft, yaxis_min, yaxis_max)
            ytitle = globDefaultGraphics['yaxis_title'].toString()
            self.qwtPlot.setAxisTitle(QwtPlot.yLeft, str(ytitle) )
        else:
            self.qwtPlot.enableAxis(QwtPlot.yLeft, False)

        (rightAxis, test)=globDefaultGraphics['xaxis_right'].toInt()
        if rightAxis==1:
            self.qwtPlot.enableAxis(QwtPlot.yRight, True)
            self.qwtPlot.setAxisScale(QwtPlot.yRight, yaxis_min, yaxis_max)
            if leftAxis != 1: # if possible, write axis label on left, if no left axis: write on right
                ytitle = globDefaultGraphics['yaxis_title'].toString()
                self.qwtPlot.setAxisTitle(QwtPlot.yRight, str(ytitle) )
        else:
            self.qwtPlot.enableAxis(QwtPlot.yRight, False)
        
        # X axis title
        (xaxis_min, test) = globDefaultGraphics['xaxis_min'].toFloat()
        if not test:
            xaxis_min = 0
        (xaxis_max, test) = globDefaultGraphics['xaxis_max'].toFloat()
        if not test:
            xaxis_max = len(x[0])

        (bottomAxis, test) =  globDefaultGraphics['yaxis_bottom'].toInt()
        if bottomAxis==1:
            self.qwtPlot.enableAxis(QwtPlot.xBottom, True)
            self.qwtPlot.setAxisScale(QwtPlot.xBottom, xaxis_min, xaxis_max)
            xtitle = globDefaultGraphics['xaxis_title'].toString()
            self.qwtPlot.setAxisTitle(QwtPlot.xBottom, str(xtitle) )
        else:
            self.qwtPlot.enableAxis(QwtPlot.xBottom, False)

        (topAxis, test) = globDefaultGraphics['yaxis_top'].toInt()
        if topAxis:
            self.qwtPlot.enableAxis(QwtPlot.xTop, True)
            self.qwtPlot.setAxisScale(QwtPlot.xTop, xaxis_min, xaxis_max)
            if bottomAxis != 1:
                xtitle = globDefaultGraphics['xaxis_title'].toString()
                self.qwtPlot.setAxisTitle(QwtPlot.xTop, str(xtitle) )
        else:
            self.qwtPlot.enableAxis(QwtPlot.xTop, False)
  
        self.qwtPlot.updateAxes()
        self.qwtPlot.replot()


    
