from datetime import date

from PyQt5.QtCore import QDate
from qgis.core import QgsGeometry, QgsFeature

from eagris.eagri.ws.lpi_ddp01_b.model.response import ParcelVersion, Parcel, ParcelCrop
from eagris.eagri.ws.lpi_gdp11_b.model.response import Dpb


def date_to_q_date(d: date):
    return QDate(d.year, d.month, d.day) if d else None


def dpb_to_feature(dpb: Dpb):
    geom = QgsGeometry.fromWkt(dpb.geometry)

    f = QgsFeature()
    f.setGeometry(geom)

    f.setAttributes([
        dpb.id,
        dpb.square,
        dpb.zkod,
        dpb.status,
        date_to_q_date(dpb.valid_from),
        date_to_q_date(dpb.valid_to),
        dpb.area,
        dpb.culture,
        dpb.culture_name,
        dpb.geometry
    ])
    return f


def parcel_version_to_feature(parcel_id: int, parcel_version: ParcelVersion) -> QgsFeature:
    geom = QgsGeometry.fromWkt(parcel_version.geometry)

    f = QgsFeature()
    f.setGeometry(geom)

    f.setAttributes([
        parcel_id,
        date_to_q_date(parcel_version.valid_from),
        date_to_q_date(parcel_version.valid_to),
        parcel_version.id,
        parcel_version.area,
        parcel_version.geometry
    ])
    return f


def parcel_to_feature(parcel: Parcel) -> QgsFeature:
    f = QgsFeature()
    f.setAttributes([
        parcel.id,
        parcel.name,
        date_to_q_date(parcel.valid_from),
        date_to_q_date(parcel.valid_to)
    ])

    return f


def parcel_crop_to_feature(parcel_id: int, parcel_crop: ParcelCrop):
    f = QgsFeature()
    f.setAttributes([
        parcel_id,
        parcel_crop.crop_id,
        parcel_crop.catch_crop,
        date_to_q_date(parcel_crop.valid_from),
        date_to_q_date(parcel_crop.valid_to)
    ])

    return f
