from datetime import date
from enum import Enum
from typing import List, Optional

from pydantic.dataclasses import dataclass


@dataclass
class ParcelVersion:
    id: int
    geometry: str
    valid_from: date
    valid_to: Optional[date]
    area: float


@dataclass
class ParcelCrop:
    crop_id: int
    catch_crop: bool
    valid_from: date
    valid_to: Optional[date]


@dataclass
class Parcel:
    id: int
    name: str
    valid_from: date
    valid_to: Optional[date]
    versions: List[ParcelVersion]
    crops: List[ParcelCrop]


@dataclass
class DpbDetailResponse:
    parcels: List[Parcel]


# TODO i18n
class Lpiddb01bParcelAttribute(Enum):
    # join field
    ID = 'IDPARCELA'
    NAME = 'NAZEV'
    VALID_FROM = 'PARCELAOD'
    VALID_TO = 'PARCELADO'


class Lpiddb01bParcelVersionAttribute(Enum):
    # join field
    PARCEL_ID = 'IDPARCELA'
    VALID_FROM = 'PARCELAVERZEOD'
    VALID_TO = 'PARCELAVERZEDO'
    VERSION_ID = 'IDPARCELAVERZE'
    AREA = 'VYMERA'
    GEOMETRY = 'GEOMETRIE'


class Lpiddb01bParcelCropAttribute(Enum):
    PARCEL_ID = 'IDPARCELA'
    CROP_ID = 'KODPLODINY'
    CATCH_CROP = 'MEZIPLODINA'
    VALID_FROM = 'PLATNOSTOD'
    VALID_TO = 'PLATNOSTDO'
