from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QTreeWidgetItem, QTreeWidget

from eagris.auth.auth_creds_service import insert, findAll, delete
from eagris.model.auth import EagriAuthData, logicallyEqual


def eagriAuthToTreeItem(eagri_auth: EagriAuthData):
    item = QTreeWidgetItem()
    # 'None' is displayed if the value is 'None', this is a workaround to display an empty cell instead
    item.setText(0, str(eagri_auth.name) if eagri_auth.name else "")
    item.setText(1, str(eagri_auth.login))
    item.setText(2, str(eagri_auth.wskey))
    item.setText(3, str(eagri_auth.szrid))
    item.setText(4, str(eagri_auth.env.name))
    item.setData(0, Qt.UserRole, eagri_auth)
    return item


class EagrisCredentialsTree:
    def __init__(self, tree_widget: QTreeWidget):
        self.__tree_widget = tree_widget
        self.__populateCredsTree()

    def addAuthItem(self, auth_data: EagriAuthData):
        self.__tree_widget.addTopLevelItem(eagriAuthToTreeItem(auth_data))
        insert(auth_data)

    def authItemExists(self, auth_data: EagriAuthData):
        return any(
            logicallyEqual(self.__dataForItem(ix), auth_data) for ix in range(0, self.__tree_widget.topLevelItemCount())
        )

    def removeAll(self):
        self.__tree_widget.clear()

    def removeAllSelectedItems(self):
        for i in self.__tree_widget.selectedItems():
            auth_data = i.data(0, Qt.UserRole)
            delete(auth_data)
            self.__tree_widget.invisibleRootItem().removeChild(i)

    def __dataForItem(self, item_index: int):
        return self.__tree_widget.topLevelItem(item_index).data(0, Qt.UserRole)

    def __populateCredsTree(self):
        local_creds = findAll()
        self.__tree_widget.addTopLevelItems([eagriAuthToTreeItem(cred) for cred in local_creds])
