from eagris.eagri.ws.generated.lpiddp01b import ResponseType, ZemParcelyType, ParcelaVerzeType, PlodinaType
from eagris.eagri.ws.lpi_ddp01_b.model.response import DpbDetailResponse, Parcel, ParcelVersion, ParcelCrop


def mapResponse(raw_response: ResponseType):
    """
    Mapper expects that only one DPB is returned since we request DPB detail using its ID.
    """
    return DpbDetailResponse(
        [__mapParcel(parcel) for parcel in raw_response.dpb[0].zemparcely]
    )


def __mapParcel(parcel: ZemParcelyType):
    return Parcel(
        id=parcel.idparcela,
        name=parcel.nazev,
        valid_from=parcel.parcelaod.to_date(),
        valid_to=parcel.parcelado.to_date() if parcel.parcelado else None,
        crops=[__mapParcelCrop(crop) for crop in parcel.plodina],
        versions=[__mapParcelVersion(version) for version in parcel.parcelaverze]
    )


def __mapParcelCrop(crop: PlodinaType):
    return ParcelCrop(
        crop_id=crop.kodplodiny,
        valid_from=crop.platnostod.to_date(),
        valid_to=crop.platnostdo.to_date() if crop.platnostdo else None,
        catch_crop=crop.meziplodina
    )


def __mapParcelVersion(parcel_version: ParcelaVerzeType):
    return ParcelVersion(
        id=parcel_version.idparcelaverze,
        geometry=parcel_version.geometrie,
        valid_from=parcel_version.parcelaverzeod.to_date(),
        valid_to=parcel_version.parcelaverzedo.to_date() if parcel_version.parcelaverzedo else None,
        area=float(parcel_version.vymera)
    )
