from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QWidgetAction

from .configuration.cred_settings import isEagrisPluginSetUp
from eagris.controller.panel.panel import QgisEagriPanel
from eagris.controller.modal.modal import QgisEagriModal
from .controller.eagriswelcomewizard import QgisEagriWelcomeWizard


class Eagris:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        self.action = QWidgetAction(self.iface.mainWindow())
        self.panel = None
        self.modal = None
        self.welcomeWizard = QgisEagriWelcomeWizard(
            self.iface,
            lambda: self.__initEagrisComponents()
        )

    def initGui(self):
        if isEagrisPluginSetUp():
            self.__initEagrisComponents()
        else:
            self.welcomeWizard.show()

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu("eagris", self.action)
        self.iface.removeDockWidget(self.panel)

    def eagri(self):
        self.modal.show()
        self.modal.adjustSize()

    def __initEagrisComponents(self):
        print("eagris plugin is set up, loading components...")
        self.panel = QgisEagriPanel(self.iface, lambda: self.modal.show())
        self.modal = QgisEagriModal(self.iface, self.panel)
        self.action.setDefaultWidget(self.panel)
        # Register the panel with the QGIS interface
        self.iface.addDockWidget(Qt.RightDockWidgetArea, self.panel)
