from eagris.eagri.namespaces import SOAP_NS
from eagris.eagri.ws.lpi_gdp11_b.model.response import EagriErrorResponse
from eagris.common.xml import findXmlText, XmlNode
from eagris.error.exceptions import XmlSubnodeNotFoundException


def parseErrorResponse(response_element: XmlNode) -> EagriErrorResponse:
    try:
        return EagriErrorResponse(
            code=findXmlText(response_element, 'faultcode', SOAP_NS),
            message=findXmlText(response_element, 'faultstring', SOAP_NS)
        )
    except XmlSubnodeNotFoundException:
        return EagriErrorResponse(
            code=None,
            message="Error message could not be parsed. "
                    "This very likely means eAGRI services are not available at the moment."
        )
