from datetime import date, timedelta

from eagris.eagri.ws.lpi_gdp11_b.model.request import DpbListRequest
from eagris.common.plugin_constants import DPB_LIST_MAX_WEEKS
from eagris.model.auth import EagriAuthData
from eagris.eagri.ws.lpi_gdp11_b.client import request
from eagris.eagri.dpb_list.mapper import mapResponse


def dpbList(eagri_auth_data: EagriAuthData):
    r = request(DpbListRequest(eagri_auth_data, date.today() - timedelta(weeks=DPB_LIST_MAX_WEEKS), date.today()))
    return mapResponse(r)
