from enum import Enum

from PyQt5.QtCore import QVariant
from qgis.core import QgsField

from eagris.eagri.ws.lpi_ddp01_b.model.response import Lpiddb01bParcelVersionAttribute, Lpiddb01bParcelAttribute, \
    Lpiddb01bParcelCropAttribute
from eagris.eagri.ws.lpi_gdp11_b.model.response import LpiGdp11bAttribute


class LpisBlockListAttributeTableField(Enum):
    IDDPB = QgsField(LpiGdp11bAttribute.IDDPB.value, QVariant.Int)
    SQUARE = QgsField(LpiGdp11bAttribute.SQUARE.value, QVariant.String)
    ZKOD = QgsField(LpiGdp11bAttribute.ZKOD.value, QVariant.String)
    STATUS = QgsField(LpiGdp11bAttribute.STATUS.value, QVariant.String)
    VALID_FROM = QgsField(LpiGdp11bAttribute.VALID_FROM.value, QVariant.Date)
    VALID_TO = QgsField(LpiGdp11bAttribute.VALID_TO.value, QVariant.Date)
    AREA = QgsField(LpiGdp11bAttribute.AREA.value, QVariant.Double)
    CULTURE = QgsField(LpiGdp11bAttribute.CULTURE.value, QVariant.String)
    CULTURE_NAME = QgsField(LpiGdp11bAttribute.CULTURE_NAME.value, QVariant.String)
    GEOMETRY = QgsField(LpiGdp11bAttribute.GEOMETRY.value, QVariant.String)


class LpisBlockDetailParcelVersionAttributeTableField(Enum):
    PARCEL_ID = QgsField(Lpiddb01bParcelVersionAttribute.PARCEL_ID.value, QVariant.Int)
    VALID_FROM = QgsField(Lpiddb01bParcelVersionAttribute.VALID_FROM.value, QVariant.Date)
    VALID_TO = QgsField(Lpiddb01bParcelVersionAttribute.VALID_TO.value, QVariant.Date)
    VERSION_ID = QgsField(Lpiddb01bParcelVersionAttribute.VERSION_ID.value, QVariant.Int)
    AREA = QgsField(Lpiddb01bParcelVersionAttribute.AREA.value, QVariant.Double)
    GEOMETRY = QgsField(Lpiddb01bParcelVersionAttribute.GEOMETRY.value, QVariant.String)


class LpisBlockDetailParcelAttributeTableField(Enum):
    PARCEL_ID = QgsField(Lpiddb01bParcelAttribute.ID.value, QVariant.Int)
    NAME = QgsField(Lpiddb01bParcelAttribute.NAME.value, QVariant.String)
    VALID_FROM = QgsField(Lpiddb01bParcelAttribute.VALID_FROM.value, QVariant.Date)
    VALID_TO = QgsField(Lpiddb01bParcelAttribute.VALID_TO.value, QVariant.Date)


class LpisBlockDetailParcelCropAttributeTableField(Enum):
    PARCEL_ID = QgsField(Lpiddb01bParcelCropAttribute.PARCEL_ID.value, QVariant.Int)
    CROP_ID = QgsField(Lpiddb01bParcelCropAttribute.CROP_ID.value, QVariant.Int)
    CATCH_CROP = QgsField(Lpiddb01bParcelCropAttribute.CATCH_CROP.value, QVariant.Bool)
    VALID_FROM = QgsField(Lpiddb01bParcelCropAttribute.VALID_FROM.value, QVariant.Date)
    VALID_TO = QgsField(Lpiddb01bParcelCropAttribute.VALID_TO.value, QVariant.Date)
