from enum import Enum

from PyQt5.QtCore import QVariant
from qgis.core import QgsField

from ..eagri.ws.lpi_gdp11_b.model.response import LpiGdp11bAttribute


class LpisBlockAttributeTableField(Enum):
    IDDPB = QgsField(LpiGdp11bAttribute.IDDPB.value, QVariant.Int)
    SQUARE = QgsField(LpiGdp11bAttribute.SQUARE.value, QVariant.String)
    ZKOD = QgsField(LpiGdp11bAttribute.ZKOD.value, QVariant.String)
    STATUS = QgsField(LpiGdp11bAttribute.STATUS.value, QVariant.String)
    VALID_FROM = QgsField(LpiGdp11bAttribute.VALID_FROM.value, QVariant.Date)
    AREA = QgsField(LpiGdp11bAttribute.AREA.value, QVariant.Double)
    CULTURE = QgsField(LpiGdp11bAttribute.CULTURE.value, QVariant.String)
    CULTURE_NAME = QgsField(LpiGdp11bAttribute.CULTURE_NAME.value, QVariant.String)
    GEOMETRY = QgsField(LpiGdp11bAttribute.GEOMETRY.value, QVariant.String)
    """
    optional fields
    """
    VALID_TO = QgsField(LpiGdp11bAttribute.VALID_TO.value, QVariant.Date)
