# flake8: noqa
from datetime import date

from xsdata.formats.dataclass.parsers import XmlParser

from ....common.xml import parseXmlString, XmlNode
from ..common.requests import injectSignatureTokenIntoRequest, doSendRequest, wrapWithCommonElements
from ..generated.lpigdp11b import ResponseType
from ..lpi_gdp11_b.model.request import DpbListRequest
from ...eagri_soap_service_type import EagriSoapServiceType

"""
Why do we keep XML documents as string oneliners?
Because eAGRI does not care about c14n spec and evidently strips whitespaces to compute document signature. :)
#https://www.w3.org/TR/2001/REC-xml-c14n-20010315#Example-WhitespaceInContent

That's why standard c14n is not a good idea.
"""


def request(list_request: DpbListRequest) -> ResponseType:
    login, wskey, szrid, _, _ = list_request.eagri_auth_data
    request_without_token = lpiGdp11bRequest(login, szrid, list_request.date_from, list_request.date_to)
    r = injectSignatureTokenIntoRequest(list_request.eagri_auth_data, request_without_token)
    return XmlParser().from_bytes(doSendRequest(r, list_request.eagri_auth_data.env, EagriSoapServiceType.LPI_GDP11B))


def lpiGdp11bRequest(login: str, szrid: str, date_from: date, date_to: date) -> XmlNode:
    return parseXmlString(
        wrapWithCommonElements(
            EagriSoapServiceType.LPI_GDP11B,
            login,
            szrid,
            inner_xml=f"<ns2:GETDATA>true</ns2:GETDATA><ns2:DATOD>{date_from.isoformat()}</ns2:DATOD><ns2:DATDO>{date_to.isoformat()}</ns2:DATDO><ns2:TYPDATA><ns2:TYPDATAKOD>ZAKLADMIN</ns2:TYPDATAKOD></ns2:TYPDATA>"
        )
    )
