from enum import Enum

from ..eagri.namespaces import SERVICE_NS_PREFIX


class EagriSoapServiceType(Enum):
    LPI_GDP11B = 'LPI_GDP11B'
    """
        Lists all available DPB.
        https://eagri.cz/public/web/mze/farmar/elektronicka-vymena-dat/prehled-vystavenych-sluzeb/LPISPF_lpi-gdp11b.html
    """
    LPI_DDP01B = 'LPI_DDP01B'
    """
        Returns a DPB detail, including agricultural parcels.
        https://eagri.cz/public/web/mze/farmar/elektronicka-vymena-dat/prehled-vystavenych-sluzeb/LPISPF_lpi-ddp01b.html
    """

    def namespace(self):
        return "/".join([SERVICE_NS_PREFIX, self.value])
