from datetime import date, timedelta

from ..ws.lpi_gdp11_b.model.request import DpbListRequest
from ...common.plugin_constants import DPB_LIST_MAX_WEEKS
from ...model.auth import EagriAuthData
from ..ws.lpi_gdp11_b.client import request
from ..dpb_list.parser import mapResponse


def dpbList(eagri_auth_data: EagriAuthData):
    r = request(DpbListRequest(eagri_auth_data, date.today() - timedelta(weeks=DPB_LIST_MAX_WEEKS), date.today()))
    return mapResponse(r)
