from ..ws.generated.lpigdp11b import ResponseType, DpbType
from ...eagri.ws.lpi_gdp11_b.model.response import Dpb, DpbListResponse


def mapBlock(dpb_element: DpbType):
    return Dpb(
        id=dpb_element.iddpb,
        square=dpb_element.ctverec,
        zkod=dpb_element.zkod,
        status=dpb_element.stav,
        valid_from=dpb_element.platnostod.to_date(),
        area=float(dpb_element.vymera),
        culture=dpb_element.kultura,
        culture_name=dpb_element.kulturanazev,
        geometry=dpb_element.geometrie.strip(),
        valid_to=dpb_element.platnostdo.to_date() if dpb_element.platnostdo else None
    )


def mapResponse(raw_response: ResponseType):
    return DpbListResponse(
        raw_response.datzmenydpb.to_date() if raw_response.datzmenydpb else None,
        list(map(mapBlock, raw_response.dpb))
    )
