from qgis.core import QgsPalLayerSettings, QgsVectorLayerSimpleLabeling, QgsVectorLayer

from ..eagri.ws.lpi_gdp11_b.model.response import LpiGdp11bAttribute


def enableDpbLayerLabeling(vector_layer: QgsVectorLayer):
    label_settings = QgsPalLayerSettings()
    label_settings.enabled = True
    label_settings.fieldName = LpiGdp11bAttribute.ZKOD.value

    # Create the labeling object
    labeling = QgsVectorLayerSimpleLabeling(label_settings)

    # Enable labeling for the layer
    vector_layer.setLabeling(labeling)
    vector_layer.setLabelsEnabled(True)
