import os
from typing import Callable

from PyQt5.QtWidgets import QWizard, QWizardPage, QGridLayout
from qgis.PyQt import uic
from qgis.gui import QgsFileWidget, QgisInterface

from ..common.plugin_constants import ALLOWED_AUTH_FILE_SUFFIXES
from ..configuration.cred_settings import setupLocalCreds
from ..controller.constants import EAGRI_WELCOME_WIZARD_UI_PATH
from ..filesystem.utils import defaultAuthFilePath


class QgisEagriWelcomeWizard(QWizard):
    donePage: QWizardPage
    authSetupPage: QWizardPage
    authSetupPageGridLayout: QGridLayout
    authPathFileWidget: QgsFileWidget

    def __init__(
            self,
            iface: QgisInterface,
            wizard_done_callback: Callable[[], None]
    ):
        QWizard.__init__(self)
        ui_path = os.path.join(os.path.dirname(__file__), EAGRI_WELCOME_WIZARD_UI_PATH)
        uic.loadUi(ui_path, self)
        self.iface = iface
        self.findFinishButton().clicked.connect(self.__handleFinishButtonClick)
        self.currentIdChanged.connect(self.__handleCurrentIdChanged)
        self.wizardDoneCallback = wizard_done_callback
        self.authPathFileWidget.setFilePath(defaultAuthFilePath())

    def __handleFinishButtonClick(self):
        self.wizardDoneCallback()

    def __handleCurrentIdChanged(self, new_id_page):
        if new_id_page == self.pageIds()[-1]:
            setupLocalCreds(auth_creds_path=self.authPathFileWidget.filePath())
        else:
            pass

    def validateCurrentPage(self) -> bool:
        return os.path.isdir(self.authPathFileWidget.filePath()) \
            or self.authPathFileWidget.filePath().endswith(tuple(ALLOWED_AUTH_FILE_SUFFIXES))

    def findFinishButton(self):
        return self.button(QWizard.WizardButton.FinishButton)
