from typing import List

from ...auth.auth_settings import AuthCredSettings
from ...auth.sqlite.utils import executeSqliteStatement, executeSqliteValuedStatement, create_session
from ...common.plugin_constants import DEFAULT_ENV
from ...eagri.env import EagriEnv
from ...model.auth import EagriAuthData


def delete(settings: AuthCredSettings, auth_data: EagriAuthData):
    session = create_session(settings.authCredsPath)
    executeSqliteStatement(
        f"""
        DELETE FROM \"{settings.tableName}\"
        WHERE
            "{settings.wsKeyField}"='{auth_data.wskey}'
            AND "{settings.szridField}"='{auth_data.szrid}'
            AND "{settings.loginField}"='{auth_data.login}';
        """,
        session
    )


def insert(settings: AuthCredSettings, auth_data: EagriAuthData):
    session = create_session(settings.authCredsPath)
    executeSqliteStatement(
        f"""
        INSERT INTO \"{settings.tableName}\"(
            "{settings.loginField}", "{settings.wsKeyField}", "{settings.szridField}"
            {__appendOptionalFields(settings)}
        )
        VALUES (
            '{auth_data.login}', '{auth_data.wskey}', '{auth_data.szrid}'
            {__appendOptionalValues(settings, auth_data)}
        );
        """,
        session
    )


def findAll(settings: AuthCredSettings) -> List[EagriAuthData]:
    session = create_session(settings.authCredsPath)
    return executeSqliteValuedStatement(
        settings,
        __sqliteRowToAuthData,
        f"""
        SELECT
            \"{settings.loginField}\", \"{settings.szridField}\", \"{settings.wsKeyField}\"
            {__appendOptionalFields(settings)}
        FROM \"{settings.tableName}\";
        """,
        session
    )


def __appendOptionalFields(settings: AuthCredSettings):
    return f"""
            {f', "{settings.nameField}"' if settings.nameField else ''}
            {f', "{settings.envField}"' if settings.envField else ''}
            """


def __appendOptionalValues(settings: AuthCredSettings, auth_data: EagriAuthData):
    return f"""
            {f", '{auth_data.name}'" if settings.nameField else ''}
            {f", '{auth_data.env.name}'" if settings.envField else ''}
            """


def __sqliteRowToAuthData(settings: AuthCredSettings, tup) -> EagriAuthData:
    login = tup[settings.loginField]
    wskey = tup[settings.wsKeyField]
    szrid = tup[settings.szridField]
    name = tup[settings.nameField] if settings.nameField else None
    env = EagriEnv.fromStr(tup[settings.envField]) if settings.envField else DEFAULT_ENV
    return EagriAuthData(
        login=login,
        wskey=wskey,
        szrid=szrid,
        name=name,
        env=env
    )
