from PyQt5.QtCore import qDebug

from ..configuration.cred_settings import loadSettings
from ..auth.sqlite.auth_creds_dao import delete as sqliteDelete, insert as sqliteInsert, findAll as sqliteFindAll
from ..model.auth import EagriAuthData


def delete(auth_data: EagriAuthData):
    qDebug(f"Deleting auth data {str(auth_data.szrid)} using SQLite.")
    sqliteDelete(loadSettings(), auth_data)


def insert(auth_data: EagriAuthData):
    qDebug(f"Inserting new auth data {str(auth_data.szrid)} using SQLite.")
    sqliteInsert(loadSettings(), auth_data)


def findAll():
    qDebug("Fetching auth data using SQLite.")
    return sqliteFindAll(loadSettings())
