# -*- coding: utf-8 -*-

"""
/***************************************************************************
 smk_tools
                                 A QGIS plugin
 Suomen metsäkeskuksen työkalut
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-10-04
        copyright            : (C) 2022 by Suomen metsäkeskus
        email                : mikko.kesala@metsakeskus.fi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Suomen metsäkeskus'
__date__ = '2022-10-04'
__copyright__ = '(C) 2022 by Suomen metsäkeskus'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os,sys,shutil
from qgis.PyQt.QtCore import QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterBoolean,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingUtils,
                       QgsProcessingParameterRasterLayer,
                       QgsProcessingParameterRasterDestination,
                       QgsProcessingParameterDefinition)
from .algorithms.waterLine import getWater,feature2layer,getWaterline,getBufferzone
#from PIL import Image
import processing
#from sys import exit

pluginPath = os.path.abspath(
    os.path.join(
        os.path.dirname(__file__),
        os.pardir))

class riparianBufferZone(QgsProcessingAlgorithm):
    """
    This is an algorithm that takes a vector layer and
    get background rasters via interface the vector area
    and creates a new buffer zone along the waterbody.
    Input layer should be near waterbody

    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OUTPUT = 'OUTPUT'
    MINDIST = 'MINDIST'
    MEANDIST = 'MEANDIST'
    AREA = 'AREA'
    COST = 'COST'
    COSTB = 'COSTB'
    INPUT = 'INPUT'

    interface_name = ['suojakaista_taustarasterit','RUSLE','WB_Finland','DEM']
    #backgroud rasters: band1 = costdistance ; band2 = euclidean ; band3 = lsn


    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """
        #self.addParameter(QgsProcessingParameterRasterLayer('dem', 'DEM', defaultValue=None))
        #self.addParameter(QgsProcessingParameterRasterLayer('rusle', 'RUSLE', defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSource('cuttingarea','Planning area',[QgsProcessing.TypeVectorPolygon]))
        self.addParameter(QgsProcessingParameterNumber('cost', 'Retention of suspended solid (%)', type=QgsProcessingParameterNumber.Integer, minValue=0, maxValue=95, defaultValue=90))
        self.addParameter(QgsProcessingParameterNumber('minwidth', 'Minimum width', type=QgsProcessingParameterNumber.Integer, minValue=5, maxValue=30, defaultValue=10))
        self.addParameter(QgsProcessingParameterNumber('avgwidth', 'Average width', type=QgsProcessingParameterNumber.Integer, minValue=10, maxValue=50, defaultValue=20))
        self.addParameter(QgsProcessingParameterFeatureSink('bufferzone', 'Riparian zone', type=QgsProcessing.TypeVectorPoint, createByDefault=True, defaultValue=None))
              
    def processAlgorithm(self, parameters, context, feedback):
        results = {}
        feedb = {1:feedback.pushInfo,
                2:feedback.pushWarning,
                3:feedback.reportError}
        
        #feedback.pushInfo(parameters['cuttingarea'])
        #source = QgsProcessingUtils.mapLayerFromString(parameters['cuttingarea'],context)
        source = self.parameterAsSource(parameters, "cuttingarea", context)
        #source = parameters['cuttingarea']
        if source.featureCount() > 20:
            feedback.reportError("Input layer has too many features. 20 features is maximum. Process failed.")
            sys.exit()
            
        feedback.pushInfo("Inputs are good.\tInitializing a calculation of riparian buffer zones.")
        source = processing.run("native:dissolve", {'INPUT':parameters['cuttingarea'],'FIELD':[],'SEPARATE_DISJOINT':True,'OUTPUT':'TEMPORARY_OUTPUT'})
        source = source['OUTPUT']

        # Compute the number of steps to display within the progress bar and
        # get features from source
        total = 100.0 / source.featureCount() if source.featureCount() else 0
        count = source.featureCount() if source.featureCount() else 0

        features = source.getFeatures()
        cost = parameters['cost']
        #cost = self.parameterAsInt(parameters,self.COST,context)
        cost = (True,cost)
        #cost = (False,80) #change to above when massflux formula is correct
        mindist = parameters['minwidth']
        meandist = parameters['avgwidth']
        dist = (mindist,meandist)
        
        for current, feature in enumerate(features):
            # Stop the algorithm if cancel button has been clicked
            if feedback.isCanceled():
                break
            feedback.pushInfo("Stand "+ str(current+1) +"/"+ str(count))
            feedback.setProgress(int(current * total/4))
            
            rasterit = []
            for i in self.interface_name:
                #print (i)
                f = feature2layer(feature)
                rast = getWater(f,i)
                feedb[rast[2]](rast[1])
                if rast[2]==3:
                    sys.exit("Process failed to produce a riparian buffer zone")
                #rast = gdal.Open(rast)
                rasterit.append(rast[0])
                #exit

            feedback.pushInfo("Inputs retrieved from the interface")
            feedback.setProgress(int(current * total/3))
            waterline = getWaterline(rasterit,f)
            feedback.pushInfo("Border line for waters produced")
            feedback.setProgress(int(current * total/2))

            out = getBufferzone(rasterit,waterline[1],waterline[0],dist,cost)
            #out = outs[0]
            feedback.pushInfo("Riparian zone produced "+str(current+1)+"/"+str(count))

            # Add a feature in the sink
            if current == 0:
                (sink, dest_id) = self.parameterAsSink(parameters, "bufferzone",
                context, out.fields(), out.wkbType(), out.sourceCrs())
            
            for outfeat in out.getFeatures():
                sink.addFeature(outfeat, QgsFeatureSink.FastInsert)
            
            feedback.setProgress(int(current * total))

        # Return the results of the algorithm
        #style for layer
        style = os.path.join(os.path.dirname(__file__),"styles/suojakaista_style2.qml")
        #style = os.path.join(os.path.dirname(__file__),"suojakaista_style2.qml")
        layer = QgsProcessingUtils.mapLayerFromString(dest_id,context)
        layer.loadNamedStyle(style)


        results["bufferzone"] = dest_id
        
        return results

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Plan riparian zone'


    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'ReTreeT planning'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)
    
    def shortHelpString(self):
        helpfile = open(os.path.dirname(__file__) + '/descriptions/planriparianzones.html',encoding="utf-8")
        help = helpfile.read()
        return help


    def createInstance(self):
        return riparianBufferZone()
