# -*- coding: utf-8 -*-
"""
Created on Thu Jun  4 07:05:01 2020

@author: alauren
"""
#%%
import numpy as np
#%%
def decay_tree_potential(zone):
    """
    Mikkonen, N., Leikola, N., Lahtinen, A., Lehtomäki, J., Halme, P. 2018. Monimuotoisuudelle tärkeät
    metsäalueet Suomessa. Puustoisten elinympäristöjen monimuotoisuusarvojen Zonation-analyysien loppuraportti. 
    Suomen ympäristökeskuksen raportteja 9.
    Liite V. page 73
    Polynomial functions: ax^5 + bx4 + ... + ex + f
    x is stand mean breast height diameter (in cm), result is decay wood index, values [0...1] 
    zone, see Fig 21
    sfc, site fertility class:
        1 - lehto
        2 - lehtomainen kangas
        3 - tuore kangas
        4 - kuivahko kangas
        5 - kuiva kangas
        6 - karukkokangas
    tree species
        spruce - Norway spruce - 2 
        pine - Scots pine  - 1
        bpend - Betula pendula - 3
        bpub - Betula pubenscens - 4 
        aspen - Populus tremula - 5
        alnus - Alnus glutinosa - 7
        otherd - other deciduous tree - 29
        
        Tree species code in Metsävaratieto:
        Puulajikoodi	1	Pine	Pinus sylvestris	1
        Puulajikoodi	2	Spruce	Picea abies	2
        Puulajikoodi	3	Silver birch	Betula pendula	3
        Puulajikoodi	4	Downy birch	Betula pubescens	4
        Puulajikoodi	5	Asp	Populus tremula	5
        Puulajikoodi	6	Grey alder	Alnus incana	6
        Puulajikoodi	7	Black alder	Alnus glutinosa	7
        Puulajikoodi	8	Other coniferous tree		8
        Puulajikoodi	9	Other deciduous tree		9
        Puulajikoodi	10	Oregon pine	Pseudotsuga menziesii	10
        Puulajikoodi	11	Common juniper	Juniperus communis	11
        Puulajikoodi	12	Contorta pine	Pinus contorta	12
        Puulajikoodi	13	European white elm	Ulmus laevis	13
        Puulajikoodi	14	Larch	Larix sibirica/Larix decidua	14
        Puulajikoodi	15	Small-leaved lime	Tilia cordata	15
        Puulajikoodi	16	Black spruce	Picea mariana	16
        Puulajikoodi	17	Willow	Salix sp.	17
        Puulajikoodi	18	Rowan	Sorbus aucuparia	18
        Puulajikoodi	19	Fir	Abies sibirica	19
        Puulajikoodi	20	Goat willow	Salix caprea	20
        Puulajikoodi	21	Ash	Fraxinus excelsior	21
        Puulajikoodi	22	Swiss pine	Pinus cembra	22
        Puulajikoodi	23	Serbian spruce	Picea omorika	23
        Puulajikoodi	24	Oak	Quercus robur	24
        Puulajikoodi	25	Bird cherry	Prunus padus	25
        Puulajikoodi	26	Maple	Acer platanoides	26
        Puulajikoodi	27	Curly birch	Betula pendula var. carelica	27
        Puulajikoodi	28	Scots elm	Ulmus glabra	28
        Puulajikoodi	29	Deciduous tree		29


    """
    dcpot ={'codes':{'zones': 'first layer in nested dict, zones around Finland 1-4, see Mikkonen et al. 2018 for map',
                     'sfc': 'second layer in nested dict, site fertility classes 1-6',
                     'species': '1 - pine, 2- spruce, 3- pendula birch, 4 - pubenscens birch, 5- aspen, 7- alnus glutinosa, 29-other'},
    'zone1':{
            1:{
                2: [0.0000000161,-0.0000017284,0.0000659861,-0.0010311017,0.0147885592,-0.0049002034] ,
                1: [0,0.0000004623,-0.0000222413,0.0001927273,0.0120210416,-0.0075600744] ,
                3: [0.0000000698,-0.0000029907,0.0000126208,0.0006443447,0.0081154853,0.0028446742] ,
                4: [0.0000005147,-0.000039753,0.0010706348,-0.0116114394,0.0563842058,-0.0081785677] ,
                5: [0.0000004911,-0.0000364224,0.0009463543,-0.0099537068,0.0497723271,-0.0052573545] ,
                7: [0.0000074496,-0.000352509,0.005940476,-0.0415701978,0.1244785725,-0.0023168716] ,
                29: [0.0000159331,-0.0006551323,0.0096463222,-0.0594495816,0.1557082599,-0.0009990372] },
            2:{
                2: [0.0000000184,-0.0000017033,0.0000563171,-0.0007552955,0.0134742452,-0.0023702218] ,
                1: [0.0000000098,0.0000001796,-0.0000515518,0.0015055128,-0.0006701712,0.0042664418] ,
                3: [0.0000004286,-0.0000315153,0.0008107264,-0.0084532404,0.0439597902,-0.0043918714] ,
                4: [0.0000008478,-0.0000578998,0.0013844346,-0.013412316,0.0598250568,-0.0064807858] ,
                5: [0.0000006389,-0.0000448857,0.0011066815,-0.0110807294,0.0529277624,-0.0053017914] ,
                7: [0.0000128704,-0.0005507459,0.0084512065,-0.0543659749,0.1493117306,-0.0015781598] ,
                29: [0.00002051,-0.0007254342,0.009342154,-0.0512173513,0.1319081391,-0.0004774367] },
            3:{
                2: [0,0.0000005264,-0.0000425948,0.0011372754,-0.0002934437,0.0169174344] ,
                1: [0,0.0000013512,-0.0001013567,0.0023850056,-0.0060850485,0.0064301561] ,
                3: [0.0000004916,-0.000034262,0.0008300406,-0.0080614969,0.0409280753,-0.0062904828] ,
                4: [0.0000008494,-0.0000570531,0.0013427466,-0.012823404,0.0577501024,-0.0077276424] ,
                5: [0,0.0000079795,-0.0004296518,0.0072278336,-0.0222549155,0.0216449596] ,
                7: [0.000012044,-0.0004985693,0.0073668242,-0.0453107979,0.1239013027,-0.0021327974] ,
                29: [0.0000401044,-0.0013620237,0.0166251208,-0.0854673359,0.1885573057,-0.0007201616] },
            4:{
                2: [0,0.0000005986,-0.0000192421,0.0003016817,0.0115485958,0.0025994013] ,
                1: [0,0.0000012252,-0.0000893534,0.0021243604,-0.0042316368,0.0101178798] ,
                3: [0,0,0.0000848874,-0.0025538279,0.0357856249,-0.0197727664] ,
                4: [0.0000011998,-0.0000697299,0.0014158143,-0.0115995601,0.0505531563,-0.0090827056] ,
                5: [0.000002534,-0.0001252167,0.0021839468,-0.0155782893,0.0596280231,-0.0065490851] ,
                7: [0.0000988573,-0.0026154349,0.0245845858,-0.0956244366,0.169671486,-0.0020026933] ,
                29: [0.0002650248,-0.0060471431,0.0492898767,-0.1672909525,0.2451454027,-0.0006349294] },
            5:{
                2: [0.0000002716,-0.0000157163,0.0003436485,-0.0030953347,0.0272649678,-0.0038273867] ,
                1: [0,0.0000012644,-0.000069307,0.0010995711,0.0077363288,-0.0045700136] ,
                3: [0.0000026167,-0.0000929878,0.0011342487,-0.0054258503,0.0332693801,0.0003155131] ,
                4: [0.0000195064,-0.0006349216,0.0073406555,-0.0351181493,0.0908986831,-0.0032060826] ,
                5: [0.0000113631,-0.0004077298,0.0051975367,-0.0273533659,0.0790810564,-0.0031555977] ,
                7: [0.0004043769,-0.0089613217,0.0712133327,-0.2367022954,0.3241998142,-0.0006634528] ,
                29: [0,0.0026390485,-0.0378261877,0.1704826425,-0.1726942108,0.0023550176] },
            6:{
                2: [0,0,0,0.0010125092,0.0150097643,0.0023813648] ,
                1: [0.0000000283,0.0000006755,-0.0001089991,0.0024651722,-0.0018870714,0.0052463026] ,
                3: [0.0000124704,-0.0004611922,0.0060537298,-0.0328496818,0.0907612742,-0.0041143955] ,
                4: [0.0000016683,-0.0000969083,0.0021895457,-0.023563173,0.1367625836,-0.1076733924] ,
                5: [0.0000233258,-0.0007620291,0.0088408222,-0.0423768934,0.1028515013,-0.0028496552] ,
                7: [0,0,0.005392493,-0.0590984236,0.2201961376,-0.0256368371] ,
                29: [0,0,0.0093497583,-0.083783061,0.2517833753,-0.0135120058] },
           },         
    'zone2':{
            1:{
                2: [0,0.0000006155,-0.0000450509,0.0010562901,0.001896146,0.009633086] ,
                1: [0,0.0000009335,-0.0000663941,0.0014401761,0.0015466061,0.000034989] ,
                3: [0,0.0000023886,-0.0001199093,0.0017604835,0.0064533491,0.0003928322] ,
                4: [0.0000005078,-0.000039626,0.0010777939,-0.0118120982,0.0575682212,-0.0096812959] ,
                5: [0.0000004952,-0.0000373045,0.0009829351,-0.0104664729,0.0520280776,-0.0067635479] ,
                7: [0.0000075081,-0.0003506327,0.0058294432,-0.0402069148,0.1199446382,-0.002613634] ,
                29: [0.0000154781,-0.0006291426,0.0091523543,-0.0556536543,0.1459033017,-0.0011735548] },
            2:{
                2: [0,0.0000006155,-0.0000450509,0.0010562901,0.001896146,0.009633086] ,
                1: [0,0.0000006174,-0.0000326284,0.0004487432,0.0105988127,-0.0075041933] ,
                3: [0.0000001835,-0.0000111267,0.000224422,-0.0016810971,0.0179017119,0.0010852197] ,
                4: [0.0000007892,-0.0000545302,0.0013190001,-0.0129279489,0.0586627985,-0.0068225071] ,
                5: [0.0000005734,-0.0000429847,0.0011286691,-0.0120179552,0.0581328449,-0.008131752] ,
                7: [0.0000145047,-0.0006014285,0.0089383388,-0.0556707462,0.1490098749,-0.0016618983] ,
                29: [0,0,0.0010104419,-0.0177529097,0.1097035692,-0.0173601891] },
            3:{
                2: [0,0.0000005306,-0.0000448023,0.0012362144,-0.0014654573,0.0164931209] ,
                1: [0,0,0.000022917,-0.0010204842,0.0216302498,-0.0105496624] ,
                3: [0.0000006281,-0.0000454954,0.0011532698,-0.0118540667,0.056155832,-0.0080901647] ,
                4: [0.0000009307,-0.0000626945,0.0014860637,-0.0143806824,0.063780276,-0.0046716255] ,
                5: [0,0.0000084733,-0.0004459214,0.007342469,-0.0218166161,0.0214580688] ,
                7: [0.0000132149,-0.0005805631,0.0091730318,-0.0610986544,0.1701848768,-0.0011818426] ,
                29: [0,0,0.000990202,-0.0180949531,0.1133238427,-0.0136136818] },
            4:{
                2: [0,0.0000013384,-0.0000816544,0.001707919,0.0008330889,0.0132025288] ,
                1: [0,0.0000010166,-0.0000676667,0.0014820782,0.0015167476,0.0046006516] ,
                3: [0,0,0.0000800245,-0.0022774568,0.0326993896,-0.0144578193] ,
                4: [0.0000013047,-0.0000748816,0.0015031182,-0.0121962798,0.0522196363,-0.0092041945] ,
                5: [0.0000026447,-0.0001281296,0.0021927625,-0.0153685162,0.0588012658,-0.0058806919] ,
                7: [0,0,0.0019794703,-0.0307260916,0.1574728842,-0.0118975512] ,
                29: [0.0002614646,-0.0059727446,0.0487995206,-0.1663751121,0.2456566987,-0.0006193862] },
            5:{
                2: [0,0.0000040479,-0.0001761466,0.0027120941,0.0028549025,0.0111397051] ,
                1: [0,0.0000020094,-0.0001301944,0.0026234281,-0.0040767151,0.0070796259] ,
                3: [0.0000041677,-0.0001574013,0.0020859079,-0.0112566189,0.0463268449,-0.0010374605] ,
                4: [0.0000199097,-0.0006442758,0.0074117015,-0.0353237563,0.0913360115,-0.003231743] ,
                5: [0.0000108433,-0.0003926531,0.0050555795,-0.0269215264,0.0788169919,-0.0034048924] ,
                7: [0.0004318896,-0.0094351732,0.0739824124,-0.2429702683,0.3295543992,-0.0006597002] ,
                29: [0,0,0.0070031761,-0.0686189565,0.2293861734,-0.0180324391] },
            6:{
                2: [0,0.0000092054,-0.0003755234,0.0052546605,-0.0051711784,0.0160875537] ,
                1: [0,0.0000030626,-0.0001696886,0.0029412809,-0.0017420282,0.0028058062] ,
                3: [0.0000129718,-0.0004756278,0.0061959914,-0.0334149409,0.0918745245,-0.0041449752] ,
                4: [0.0000434301,-0.0012348638,0.0125008008,-0.0525099819,0.1142383729,-0.0022700043] ,
                5: [0.0000245697,-0.0007935809,0.0091121621,-0.0432970898,0.1043628446,-0.0028581742] ,
                7: [0,0,0.0057173199,-0.0617247899,0.2259910364,-0.0255182941] ,
                29: [0,0,0.0096623996,-0.0864707998,0.2587742488,-0.0141651976] },
           },         
    'zone3':{
            1:{
                2: [0,0,0.0000122709,-0.0007624465,0.0290175225,-0.0309302578] ,
                1: [0,0.0000003836,-0.0000136713,-0.0000543905,0.0147055443,-0.0115382974] ,
                3: [0.0000000812,-0.0000025757,-0.0000173798,0.0010223015,0.0081035278,0.0043284919] ,
                4: [0.0000008926,-0.0000586134,0.0013438732,-0.0124500644,0.0553706773,-0.0088025839] ,
                5: [0.0000005817,-0.0000388786,0.0009104427,-0.0086232657,0.0433743113,-0.0060358705] ,
                7: [0.0000082551,-0.000355986,0.0054499415,-0.034454681,0.1004627207,-0.0032690688] ,
                29: [0.0000191741,-0.0007210959,0.0096521416,-0.0536080315,0.132535611,-0.001878181] },
            2:{
                2: [0.0000000372,-0.0000032919,0.0001048535,-0.0013661297,0.0173523584,-0.0041851545] ,
                1: [0.0000000581,-0.000004782,0.00012806,-0.0011291177,0.01324466,0.0021001166] ,
                3: [0.0000007434,-0.0000509956,0.0012244189,-0.0119180632,0.0550499985,-0.0089540976] ,
                4: [0.0000011983,-0.0000734126,0.0015788582,-0.0138170861,0.0589918348,-0.0079444343] ,
                5: [0.0000008455,-0.0000541241,0.0012171283,-0.0111218403,0.0512982223,-0.0068051191] ,
                7: [0.0000141998,-0.000566332,0.0080472709,-0.0475170982,0.1254229615,-0.0030199959] ,
                29: [0.0000341563,-0.0011529939,0.0139572824,-0.0707435928,0.1588258703,-0.0012299346] },
            3:{
                2: [0,0.0000008241,-0.0000591222,0.0014262304,-0.0001559167,0.0149484085] ,
                1: [0,0.0000005446,-0.0000164774,-0.000156358,0.0170326122,-0.0151731205] ,
                3: [0,0.0000044906,-0.0001489538,0.0013133137,0.0156569208,-0.0038277485] ,
                4: [0.0000024729,-0.0001290246,0.0023699864,-0.0177546791,0.0658269113,-0.0055008469] ,
                5: [0,0,0.0001562745,-0.0046067531,0.0537072162,-0.0412866515] ,
                7: [0.0000162769,-0.000585938,0.0075014554,-0.0397237899,0.102593144,-0.0025992132] ,
                29: [0.0000440456,-0.0013787066,0.0153463234,-0.0707112495,0.1470997311,-0.0013175106] },
            4:{
                2: [0,0.0000018927,-0.0000772079,0.0012286067,0.0087162361,0.006765314] ,
                1: [0,0.0000012675,-0.0000882199,0.0020954396,-0.0031922096,0.0113978403] ,
                3: [0,0,0.0000843469,-0.0014555367,0.0237551975,0.005082126] ,
                4: [0,0,0.0003131284,-0.0068869653,0.0632760365,-0.0340467609] ,
                5: [0,0,0.0003543187,-0.0078771,0.0700779711,-0.0376300965] ,
                7: [0.0001040101,-0.0027123121,0.0250222206,-0.0946173574,0.1625612077,-0.0038541966] ,
                29: [0.0002722786,-0.0060045435,0.0469498663,-0.1510238501,0.2142271115,-0.001797677] },
            5:{
                2: [0.0000007434,-0.0000389231,0.0007562472,-0.0060387418,0.0369600166,-0.0055048664] ,
                1: [0.0000000485,-0.0000019886,-0.0000093689,0.0010724885,0.0036876387,0.0065684616] ,
                3: [0.0000134762,-0.000483611,0.0061431121,-0.0320798098,0.0873219905,-0.006101221] ,
                4: [0.0000469941,-0.001326444,0.0132503785,-0.0542358803,0.1129146343,-0.004049117] ,
                5: [0.0000206683,-0.0006761866,0.0078290083,-0.0371976946,0.0928146663,-0.0049042456] ,
                7: [0.0003465269,-0.0075489957,0.0583114029,-0.18520301,0.2496181502,-0.0024301401] ,
                29: [0.0009667794,-0.0183945971,0.1240917529,-0.3448562969,0.3852069122,-0.000931815] },
            6:{
                2: [0.0000018814,-0.0000895617,0.0015570974,-0.011098903,0.0500584897,-0.0068869694] ,
                1: [0.0000003745,-0.0000274009,0.0007016601,-0.0072645366,0.0404266958,-0.0025942599] ,
                3: [0.000027645,-0.0008898351,0.0101340238,-0.0473476725,0.1086884842,-0.0051200733] ,
                4: [0.0000973178,-0.0024765182,0.0223414139,-0.0827234057,0.1457634078,-0.0033752688] ,
                5: [0.0000439513,-0.0012918402,0.013439483,-0.0573061683,0.1192271055,-0.0040964012] ,
                7: [0.0006307148,-0.0127831695,0.0918602416,-0.2716487035,0.3275330978,-0.001741025] ,
                29: [0,0,0.0076237774,-0.0730281879,0.2298242375,-0.0247438319] },
           },         
    'zone4':{
            1:{
                2: [0.0000001362,-0.0000089326,0.0002173264,-0.0021928022,0.0227845402,-0.0043775857] ,
                1: [0,0,0.0000201272,-0.0007666773,0.0187609364,-0.0056661884] ,
                3: [0,0,0.0000142294,0.0006851383,0.0038379153,0.0305639777] ,
                4: [0,0,0.0001056533,-0.0018595467,0.0276357197,0.0014319387] ,
                5: [0,0.0000048016,-0.0001117991,0.0003543209,0.0226836786,-0.0063111968] ,
                7: [0.0000109015,-0.0004002291,0.0052118785,-0.0279047711,0.0799147601,-0.0042342366] ,
                29: [0.000032307,-0.0010219432,0.0114310178,-0.052416481,0.1155566015,-0.0031287472] },
            2:{               
                2: [0,0.0000049058,-0.0002520313,0.0043429636,-0.0095134968,0.0253623319],
                1: [0,0,0.0000225723,-0.0006202513,0.0177580701,-0.0011832482] ,
                3: [0,0,0.0000821947,-0.0013489222,0.0225653406,0.0086468736] ,
                4: [0,0.0000135491,-0.0002887099,0.001451635,0.0247671329,-0.0038273969] ,
                5: [0,0,0.0000919159,-0.0013406533,0.0229964151,0.0086222734] ,
                7: [0.0000232563,-0.0007786065,0.0092497879,-0.0451945856,0.1074552414,-0.0040762029] ,
                29: [0.0000634743,-0.0018274664,0.0186526646,-0.0783238736,0.1495900203,-0.0025211789] },
            3:{                      
                2: [0,0.0000038422,-0.0001752678,0.0028749856,0.000779639,0.014866698] ,
                1: [0,0,0.0000127058,0.0001898738,0.0042006395,0.04435213] ,
                3: [0,0,0.0001487373,-0.0032477261,0.0384672973,-0.0112808847] ,
                4: [0,0.0000520241,-0.0015190382,0.0140511857,-0.0150064164,0.0165457552] ,
                5: [0,0,0.0001862663,-0.0038237204,0.0422245854,-0.0127054555] ,
                7: [0.000022244,-0.0007248221,0.0083510986,-0.039450459,0.0966699136,-0.007998537] ,
                29: [0.0000571733,-0.0015683402,0.0151450449,-0.05958126,0.1177980604,-0.0055481454] },
            4:{                                     
                2: [0.0000015843,-0.0000734457,0.0012755734,-0.009198401,0.0464506582,-0.0076350317] ,
                1: [0,0,0.0000116647,0.0000042624,0.0117378253,0.0070122178] ,
                3: [0,0.0000237811,-0.0006969965,0.0063541234,0.0058201682,0.0066524128] ,
                4: [0,0.0000946763,-0.0025073073,0.0211413109,-0.0274326999,0.0237633916] ,
                5: [0.0000116611,-0.0003967235,0.0047990655,-0.0240006334,0.0726713154,-0.0077883137] ,
                7: [0.0001195714,-0.0029180046,0.0250762833,-0.0880100258,0.1496041466,-0.0094044374] ,
                29: [0.0003133823,-0.0064099859,0.0458978425,-0.1330159652,0.1814353937,-0.006143127] },
            5:{                                      
                2: [0.0000050816,-0.0001963719,0.0028507686,-0.017393995,0.06552299,-0.0088755793] ,
                1: [0,0.000003824,-0.0001528377,0.0019583311,0.0093019582,-0.0011384075] ,
                3: [0.0000341585,-0.0010567167,0.0115821628,-0.0522670867,0.1164330642,-0.0110599387] ,
                4: [0.0001112251,-0.0027012577,0.0231219019,-0.0808900733,0.1407658016,-0.0085794462] ,
                5: [0.0000449284,-0.0013038827,0.0133998791,-0.0566353526,0.1195635316,-0.010057277] ,
                7: [0.0003526446,-0.0074890484,0.0557315217,-0.1679583885,0.2211855538,-0.0091879247] ,
                29: [0.0007835618,-0.0145607268,0.0942725426,-0.2456538957,0.2703820828,-0.0062743999] },
            6:{                                      
                2: [0.0000000094,-0.0000016212,0.0001104195,-0.0035850719,0.0628358948,-0.0934533866] ,
                1: [0,0,0.0000759311,-0.0018448651,0.0292579425,-0.0051270841] ,
                3: [0.0000607977,-0.0017280977,0.0173812267,-0.0718177791,0.1399870537,-0.0109816278] ,
                4: [0.0002010279,-0.0045434558,0.0360747028,-0.1164661501,0.1750207637,-0.0087745744] ,
                5: [0.00008434,-0.0022248614,0.0207460282,-0.0793170088,0.1446013272,-0.0096399207] ,
                7: [0,0,0.0049165839,-0.0569047042,0.2187235843,-0.0565417242] ,
                29: [0.0011059106,-0.0200709884,0.1267110787,-0.3214094244,0.3292721334,-0.0068760501] },
            
            }         
          }      
    return dcpot[zone]
#%%
def NP_retention():
    #N and P retention parameters calculated from Heikkinen et al. 2018
    para = {'N': 15.41,
            'P': 19.139}
    return para



# %%

"""
Created 20.3.2024

Author @Mikko Kesälä

Diameter from height and crown width

Kalliovirta & Tokola (2005) Functions for estimating Stem diameter and Tree age using tree height, crown width and existing stand database information

"""
#%%
def diameterFromHeight(treespecies,height,vegeclass):
    """
    inputs: treespecies 1 = pine, 2 = spruce, 3 = deciduous, 0 = other
            height treeheight (m)
            vegeclass vegetation class in finland
    outputs:
            diameter tree diameter (cm)
    """
    d_cof = {'zone1':
                {
                0:[-2.145,1.291],
                1:[-1.775,1.314],
                2:[-1.740,1.228],
                3:[-5.533,1.475]},
            'zone2':
                {
                0:[-1.049,1.159],
                1:[-0.785,1.177],
                2:[-0.960,1.168],
                3:[-2.938,1.226]},
            'zone3':
                {
                0:[-1.187,1.212],
                1:[-0.948,1.218],
                2:[-0.457,1.161],
                3:[-1.984,1.206]},
            'zone4':
                {
                0:[-1.717,1.378],
                1:[-1.854,1.389],
                2:[-0.343,1.275],
                3:[-1.480,1.327]}

            }

    height = height * 10
    if treespecies > 3:
        treespecies = 0
        
    params = d_cof['zone'+str(vegeclass)][treespecies] 
    diameter = float(round(np.power(params[0]+params[1]*np.sqrt(height),2) / 10,2))

    return diameter
    

# %%
