# -*- coding: utf-8 -*-

"""
/***************************************************************************
 DynamicFlow
                                 A QGIS plugin
 Dynamic is a qgis plugin to estimate the spatio-temporal 3D gradient flow from the point observation of the attributes values such as aggregated cell-phone mobility data. 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-28
        copyright            : (C) 2024 by Bo-Cheng Lin, Chen-Yu Liu, Ta-Chien Chan
        email                : tachien@geohealth.tw

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Bo-Cheng Lin, Chen-Yu Liu, Ta-Chien Chan'
__date__ = '2024-03-28'
__copyright__ = '(C) 2024 by Bo-Cheng Lin, Chen-Yu Liu, Ta-Chien Chan'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .dynamic_flow_provider import DynamicFlowProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)

class DynamicFlowPlugin(object):

    def __init__(self):
        self.provider = None

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = DynamicFlowProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
