# -*- coding: utf-8 -*-
"""
/***************************************************************************
 droughtIndexerDialog
                                 A QGIS plugin
 A plugin to Process Standardized Agricultural Drought Index.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-03-03
        git sha              : $Format:%H$
        copyright            : (C) 2024 by John Ngugi
        email                : johnngugi0407@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.utils import active_plugins
from qgis.core import QgsProject
from qgis.core import QgsMapLayerType
from qgis.core import QgsWkbTypes
from PyQt5.QtWidgets import QGraphicsScene


try:
    import geopandas as gpd
    import matplotlib.pyplot as plt
except: 
    import subprocess
    install_modules = "C:/Users/hp/Documents/Qgis/Plugins/drought_indexer/requrements.bat"
    subprocess.run([install_modules], shell=True)    

import geopandas as gpd 
import json 
import pandas as pd 
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.backends.backend_qt5agg import FigureCanvasQTAgg as FigureCanvas
import concurrent.futures

 
# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'drought_indexer_dialog_base.ui'))


class droughtIndexerDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(droughtIndexerDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.initGui()

        # Fetch the currently loaded layers
        layers = QgsProject.instance().layerTreeRoot().children()
        print("layers" , layers)
        if layers:
            # Populate combobox with layers from the table of contents
            self.populateComboBox()

        self.okBtn.accepted.connect(self.showValue)
        self.okBtn.rejected.connect(self.cancelAction)
        self.pbRefreshLayers_5.clicked.connect(self.populateComboBox)
        self.pbCalculateDroughtGraph.clicked.connect(self.getDroundIndexChart)
    def populateComboBox(self):
        # Filter the layers in the TOC by type of Layer and geometry
        vector_layers = []
        for layer in QgsProject.instance().mapLayers().values():
            if layer.type() == QgsMapLayerType.VectorLayer:
                if layer.geometryType() == QgsWkbTypes.PolygonGeometry:
                    vector_layers.append(layer)

        # Clear the contents of the comboBox from previous runs
        self.cbTocLayers.clear()

        # Populate the comboBox with names of all the loaded vector layers
        return self.cbTocLayers.addItems([layer.name() for layer in vector_layers])

    def resetComboBox(self):
        # Reset combobox with new layers data from the table of contents
        self.populateComboBox()

    def initGui(self):
        # Reset combobox when the plugin is opened again
        self.resetComboBox()

    def cancelAction(self):
        # Define the action to perform when the cancel button is clicked
        self.close()  # Close the dialog
        
    def getGoJSONCoordinates(self,geojson_data):
            # Check the structure of the GeoJSON data
            if 'features' in geojson_data and len(geojson_data['features']) > 0:
                feature = geojson_data['features'][0]  # Assuming the first feature
                if 'geometry' in feature:
                    geometry = feature['geometry']
                    if 'coordinates' in geometry:
                        coordinates = geometry['coordinates']
                        print("coordinates are", coordinates)
                    else:
                        print("No coordinates found in the geometry")
                else:
                    print("No geometry found in the feature")
            else:
                print("No features found in the GeoJSON data")
            
            return coordinates
        
    def isPluginEnabled(self,plugin_name):
            plugins = active_plugins
            plugin_status = None
            # Check if the plugin is enabled
            if plugin_name in plugins:
                plugin_status = True
            else: 
                plugin_status = False    
            
            return plugin_status

    def showValue(self):
        
        # Check if the required plugin is enabled
        plugin_status  = self.isPluginEnabled('ee_plugin')
        if plugin_status != True:
            # Plugin is not enabled, show an error message and return
            QtWidgets.QMessageBox.warning(self, "Plugin Error", "The required plugin is not enabled.\n please install the Google Earth Engine plugin and try again")
            return
        
        import ee 
        from ee_plugin import Map

        xLeft = self.sbXmax.value()
        xmax = xLeft

        ymax = self.sbYmax.value()
        ymin = self.sbYmin.value()
        

        xmax_right = self.sbXmaxr.value()
        xLeft_right = xmax_right

        ymax_right = ymax
        ymin_right = ymin

        # ROI1=ee.FeatureCollection('users/muthamijohn/kwanza_constituency')
        
        current_shp_index = self.cbTocLayers.currentIndex()
        current_shp_name = self.cbTocLayers.currentText()
        current_shp_obj= QgsProject.instance().mapLayersByName(str(current_shp_name))
        
        print(current_shp_index) 
        if not self.cbTocROI.isChecked() :
            ROI1=ee.Geometry.Polygon([[xmax,ymax],[xmax_right,ymax_right],[xLeft_right,ymin_right],[xLeft,ymin],])
                      
        elif self.cbTocROI.isChecked():
             # image = None
            current_shp = self.cbTocLayers.currentText()
            current_shp= QgsProject.instance().mapLayersByName(str(current_shp))
            print(current_shp)
            layer_path = current_shp[0].source()      
            if layer_path:            
                df = gpd.read_file(layer_path)
                print(df)
                
                curent_shp_json = df.to_json()
                curent_shp_json = json.loads(curent_shp_json)
                # print(curent_shp_json)
                geo_json_data = curent_shp_json
                
                print("GEOJSON:", geo_json_data)
                geojson_data= geo_json_data
                coordinates = self.getGoJSONCoordinates(geojson_data)
                ROI1 = ee.Geometry.Polygon(coordinates)
            
        elif self.cbGeoJsonROI.isChecked():
            json_data = gpd.read_file(self.LegeojsonPath.filePath())
            curent_json = json_data
            curent_geo_json = json.loads(curent_json)
            coordinates = self.getGoJSONCoordinates(curent_geo_json)
            ROI1 = ee.Geometry.Polygon(coordinates)
        else:
            QtWidgets.QMessageBox.warning(self, "Region of interest Error", "Region of Interest Required \n ensure all parameters are correct")   
            self.cancelAction()
            
        # Update progress bar value
        self.progressBar.setValue(10)
        Map.centerObject(ROI1, 12)
        start_year = int( self.startDate.currentText())
        end_year = int(self.endDate.currentText())
        season = str(self.season.value())
        print(season)
        
        geometry = ROI1
        if season=='1':
            startmonth = 1
            endmonth = 3
        elif season == '2':
            startmonth = 4
            endmonth = 6
        elif season =='3':
            startmonth =7
            endmonth = 9
        elif season == '4':
            startmonth = 10
            endmonth = 12
        else:
            print(" no season lioke that exists ")

        images = []
         # Cloud mask
        def maskL5(col):
                # Bits 3 and 5 are cloud shadow and cloud, respectively.
                cloudShadowBitMask = (1 << 3)
                cloudsBitMask = (1 << 5)

                # Get the pixel QA band.
                qa = col.select('QA_PIXEL')

                # Both flags should be set to zero, indicating clear conditions.
                mask = qa.bitwiseAnd(cloudShadowBitMask).eq(0) \
                .And(qa.bitwiseAnd(cloudsBitMask).eq(0))

                return col.updateMask(mask)
            
            
        drought_index_values = []
        drought_index_values_names = []
        
        
        def calculate_drought_index(start_year, end_year,startmonth,endmonth):
            
                # Load the collection
                col = ee.ImageCollection("LANDSAT/LE07/C02/T1") \
                        .map(maskL5) \
                        .filter(ee.Filter.calendarRange(start_year, end_year, 'year')) \
                        .filter(ee.Filter.calendarRange(startmonth,endmonth, 'month'))\
                        .filterBounds(geometry)

                col_image = col.mean().clip(geometry)
                # Image reduction
                image = col.mean().clip(geometry)
                # Update progress bar value
                self.progressBar.setValue(25)

                # Calculate TOA spectral radiance
                ML = 0.055375
                AL = 1.18243
                TOA_radiance = image.expression('ML * B6 + AL', {
                        'ML': ML,
                        'AL': AL,
                        'B6': image.select('B6_VCID_1')
                })

                # Convert TOA spectral radiance to brightness temperature
                K1 = 607.76
                K2 = 1260.56
                brightnessTemp = TOA_radiance.expression(
                        '(K2 / (log((K1 / L) + 1))) - 273.15', {
                        'K1': K1,
                        'K2': K2,
                        'L': TOA_radiance
                        })


                brightnessTemp = brightnessTemp.clip(geometry)

                # Median
                ndvi = image.normalizedDifference(['B4', 'B3']).rename('NDVI')
                ndvi = ndvi.clip(geometry)

                # Find the min and max of NDVI
                min_val = ndvi.reduceRegion(ee.Reducer.min(), geometry, 30, maxPixels=1e9).get('NDVI')
                max_val = ndvi.reduceRegion(ee.Reducer.max(), geometry, 30, maxPixels=1e9).get('NDVI')
                min_value = ee.Number(min_val)
                max_value = ee.Number(max_val)

                # Fractional vegetation
                fv = ndvi.subtract(min_value).divide(max_value.subtract(min_value)).pow(2).rename('FV')
                VCI = (ndvi.subtract(min_value)).divide(max_value.subtract(min_value))

                # Emissivity
                a = ee.Number(0.004)
                b = ee.Number(0.986)
                EM = fv.multiply(a).add(b).rename('EMM')

                # Calculate land surface temperature
                landSurfaceTemp = brightnessTemp.expression(
                        '(BT / (1 + (10.60 * BT / 14388) * log(epsilon)))', {
                        'BT': brightnessTemp,
                        'epsilon': EM.select('EMM')
                        })

                # Clip the land surface temperature image to the geometry
                clippedLandSurfaceTemp = landSurfaceTemp.clip(geometry)
                
                # Update progress bar value
                self.progressBar.setValue(50)
                
                # Find the min and max of LST
                min_v = clippedLandSurfaceTemp.reduceRegion(ee.Reducer.min(), geometry, 30, maxPixels=1e9).values().get(0)
                max_v = clippedLandSurfaceTemp.reduceRegion(ee.Reducer.max(), geometry, 30, maxPixels=1e9).values().get(0)
                min_LST = ee.Number(min_v)
                max_LST = ee.Number(max_v)

                max_LST_1 = ee.Image(max_LST)
                #Obtain TCI
                TCI = max_LST_1.subtract(clippedLandSurfaceTemp).divide(max_LST.subtract(min_LST))

                #Calculate VCI
                VHI = (VCI.multiply(0.5)).add(TCI.multiply(0.5))

                # VHI classification into classes based on threshold values to calculate Drought Index
                image02 = VHI.lt(0.1).And(VHI.gte(-1))
                image04 = ((VHI.gte(0.1)).And(VHI.lt(0.2))).multiply(2)
                image06 = ((VHI.gte(0.2)).And(VHI.lt(0.3))).multiply(3)
                image08 = ((VHI.gte(0.3)).And(VHI.lt(0.4))).multiply(4)
                image10 = (VHI.gte(0.4)).multiply(5)
                Drought_Index = (image02.add(image04).add(image06).add(image08).add(image10))

                Drought_index_sd_image = Drought_Index.expression('(2*((Drought_Index - min_DI)/(max_DI - min_DI)) -1)',{
                    'Drought_Index': Drought_Index,
                    'min_DI' : ee.Number(Drought_Index.reduceRegion(ee.Reducer.min(), geometry, 30, maxPixels=1e9).values().get(0)),
                    'max_DI' :ee.Number(Drought_Index.reduceRegion(ee.Reducer.max(), geometry, 30, maxPixels=1e9).values().get(0)),

                })
                
                drought_index_value = Drought_index_sd_image.reduceRegion(
                    reducer = ee.Reducer.mean(),
                    geometry = geometry,
                    scale = 30,
                    maxPixels = 1e13
                )
                
                VHI_value = VHI.reduceRegion(
                    reducer = ee.Reducer.mean(),
                    geometry = geometry,
                    scale = 30,
                    maxPixels = 1e13
                )
                
                VCI_value = VCI.reduceRegion(
                    reducer = ee.Reducer.mean(),
                    geometry = geometry,
                    scale = 30,
                    maxPixels = 1e13
                )
                
                TCI_value = TCI.reduceRegion(
                    reducer = ee.Reducer.mean(),
                    geometry = geometry,
                    scale = 30,
                    maxPixels = 1e13
                )
                
                NDVI_value = ndvi.reduceRegion(
                    reducer = ee.Reducer.mean(),
                    geometry = geometry,
                    scale = 30,
                    maxPixels = 1e13
                )
                
                print(drought_index_value.getInfo())
                
                print("ndvi values" , NDVI_value.getInfo())
                print("vci values" , VCI_value.getInfo())
                print("tci values" , TCI_value.getInfo())
                print("vhi values" , VHI_value.getInfo())
                
                drought_index_values.append(ee.Number(drought_index_value.get('constant')).float().getInfo())
                VCI_value = ee.Number(VCI_value.get('NDVI')).float().getInfo()
                TCI_value = ee.Number(TCI_value.get('constant')).float().getInfo()
                VHI_value = ee.Number(VHI_value.get('NDVI')).float().getInfo()
                NDVI_value = ee.Number(NDVI_value.get('NDVI')).float().getInfo()
                
                
                
                
                self.lbDroughtIndex.setText(str(round(drought_index_values[0],4)))
                self.lbVCI.setText('Mean VCI: ' + str(round(VCI_value,4)))
                self.lbVHI.setText('Mean VHI: ' + str(round(VHI_value,4)))
                self.lbNDVI.setText('Mean NDVI: ' + str(round(NDVI_value,4)))
                self.lbTCI.setText('Mean TCI: ' + str(round(TCI_value,4)))
                
                
                
                
                if ee.Number(drought_index_value.get('constant')).float().getInfo() < 0.1:
                    style_sheet_DI = "color: yellow;"
                elif ee.Number(drought_index_value.get('constant')).float().getInfo() < -0.2:
                    style_sheet_DI = "color: orange;"
                elif ee.Number(drought_index_value.get('constant')).float().getInfo() < -0.7:
                    style_sheet_DI = "color: red;"         
                else:
                    style_sheet_DI = "color: green;"                 
                
                self.lbDroughtIndex.setStyleSheet(style_sheet_DI)   
                                
                drought_index_values_names_value = f" DI_{start_year}-{startmonth}"
                drought_index_values_names.append(drought_index_values_names_value)
                images.append(Drought_index_sd_image)
                images.append(ndvi)
                images.append(col_image)
                # Update progress bar value
                self.progressBar.setValue(75)
                return images
        
        calculate_drought_index(start_year, end_year,startmonth,endmonth)    
        
        
        spi_images = []        
        mean_spi_values = []
        spi_names = []            
        ndvi_values = []       
        ndvi_names = [] 
        

        spi_images = []        
        mean_spi_values = []
        spi_names = []            
        ndvi_values = []       
        ndvi_names = [] 

        # Function to calculate SPI
        def calculate_SPI(start_year, end_year,startmonth,endmonth):

            # Filter CHIRPS images for the rolling time window
            chirps_collection = (ee.ImageCollection("UCSB-CHG/CHIRPS/DAILY")
                                .filter(ee.Filter.calendarRange(start_year, end_year, 'year')) \
                                .filter(ee.Filter.calendarRange(startmonth,endmonth, 'month'))\
                                .select('precipitation'))\
                                .filterBounds(geometry)

            
    
            image = chirps_collection.median().clip(geometry)

            # Calculate mean and standard deviation for the filtered collection
            stats = chirps_collection.reduce(ee.Reducer.mean().combine(ee.Reducer.stdDev(), None, True))

            global spi
            # Calculate SPI
            spi = image.subtract(stats.select('precipitation_mean')).divide(stats.select('precipitation_stdDev'))

            mean_spi= spi.reduceRegion(
                reducer = ee.Reducer.mean(),
                geometry = geometry,
                scale = 500,
                maxPixels = 1e13
            )

            print('mean SPI is: ', mean_spi.getInfo())
            # Get SPI name
            spi_name = f"SPI-{str(start_year)}-{str(month)}"
            spi_names.append(spi_name)            
            mean_spi_value = ee.Number(mean_spi.get('precipitation')).float().getInfo()
            mean_spi_values.append(mean_spi_value)              

            return spi_images.append(image)


        def getNDVIPerMonth(start_year, end_year,startmonth,endmonth) :                   
            landsat_collection = ee.ImageCollection("LANDSAT/LE07/C02/T1")\
                                .map(maskL5)\
                                .filter(ee.Filter.calendarRange(start_year, end_year, 'year')) \
                                .filter(ee.Filter.calendarRange(startmonth,endmonth, 'month'))\
                                .filterBounds(geometry)          
                                
            ndvi_image = landsat_collection.median().normalizedDifference(['B4', 'B3']).clip(geometry)
            ndvi_value = ndvi_image.reduceRegion(reducer=ee.Reducer.mean(),
                                                    geometry= geometry,
                                                    scale = 30,
                                                    maxPixels = 1e13)
            ndvi_values.append(ee.Number(ndvi_value.get('nd')).float().getInfo())
            ndvi_names.append(f"ndvi_{start_year}-{startmonth}")
            
            return ndvi_values
                
      
        spi_vis = {
        'min': -1,
        'max': 1,
        'palette' : [
            '#0D0887',  # dark blue
            '#46039F',  # blue
            '#7201A8',  # purple
            '#9C179E',  # magenta
            '#BD3786',  # pink
            '#D8576B',  # light pink
            '#ED7953',  # orange
            '#FB9F3A',  # light orange
            '#F0F921',  # yellow
            '#FFFF99',  # light yellow
            '#FFFFE5'   # lightest yellow
        ]
        }

        indecesVis = {'min': -1 ,"max": 1, 'palette': ['red','yellow','green']}


        # Define the years for the analysis
        years = ee.List.sequence(start_year, end_year)
        if season == '1':
            months = [1, 2, 3]
        elif season == '2':
            months = [4, 5, 6]
        elif season == '3':
            months = [7, 8, 9]
        elif season == '4':
            months = [10, 11, 12]
        else:
            print('No such season, Enter a valid season of 1-4')

        print(years.getInfo())

        for i in range(years.length().getInfo()):
            for month in months:
                try:
                    calculate_SPI(years.getInfo()[i], years.getInfo()[i],month,month)
                    # calculate_drought_index(years.getInfo()[i], years.getInfo()[i],month,month)
                except:
                    print("Lacking some images ")    
                    
                try: 
                    getNDVIPerMonth(years.getInfo()[i], years.getInfo()[i],month,month) 
                except:
                    print(f'No Images for: {start_year} - {startmonth}')   

                          
            i = i+1

        # calculate_SPI(start_year, end_year,startmonth,endmonth)

            
       
               
               
               
               
               
               
               
                
        print("mean spi list: ", mean_spi_values)     
        print("spi name list: ", spi_names) 
        print('ndvi values are: ', ndvi_values)
        print("ndvi list names are : ", ndvi_names)
        print("drought_index_values: ", drought_index_values)
        
        # Create a pandas DataFrame from the mean SPI values and names
        df = pd.DataFrame({'SPI_Name': spi_names, 'Mean_SPI': mean_spi_values})
        print(df)
        
        ndvi_df = pd.DataFrame({'NDVI_Name': ndvi_names, 'Mean_NDVI': ndvi_values})
        print(ndvi_df)
        
        drought_index_df = pd.DataFrame({'DI_Name': drought_index_values_names, 'Mean_drought_index': drought_index_values})
        print(drought_index_df)
        
        # get the Satellite Imagery into the map Object
        Map.addLayer(images[2].select('B3','B2','B1'),{'min':3,'max':200, },'Landsat satellite image')
        Map.addLayer(spi_images[0].clip(geometry),spi_vis,'Standardized Precipitation')
        Map.addLayer(images[1],indecesVis,"NDVI")
        # add the SADI image to map object
        Map.addLayer(images[0],{'min':-1,'max':1,'palette':[
                '#E31A1C',  # Exceptional drought (dark red)
                '#FC4E2A',  # Extreme drought (red-orange)
                '#FD8D3C',  # Severe drought (dark orange)
                '#FEB24C',  # Moderate drought (orange)
                '#FED976',  # Mild drought (light orange)
                '#3a8025',  # Very mild drought (light yellow)
            ]},'Drought index standardized image')
        
    
        # Convert them to numpy arrays before plotting
        spi_name = spi_names
        mean_spi = mean_spi_values
        
        
        # set the style 
        plt.style.use('seaborn')
        
        # Create the line plot
        fig, ax = plt.subplots(figsize=(610/100, 250/100))  # Set the figure size (width, height)
        ax.plot(spi_names, mean_spi_values, marker='o',color = 'green',linewidth=1)  # Plot the data with markers
        ax.set_title('Mean SPI Values Over Time',fontsize=10,fontweight='bold')
        ax.set_xlabel('SPI Name',fontsize=6)
        ax.set_ylabel('Mean SPI',fontsize=8)
        ax.tick_params(axis='x', rotation=60,labelsize=6)  # Rotate x-axis labels for better readability
        ax.fill_between(spi_name, 0, mean_spi, alpha=0.2, color='green')
        ax.grid(True, linestyle='--', linewidth=0.5, alpha=0.7)  # Add grid lines
        ax.legend(loc='upper right', fontsize=8)

        # Add a horizontal line at y=0 to correspond to the x-axis
        ax.axhline(y=0, color='black', linestyle='--',linewidth = 0.8)

        # Customize y-axis ticks to show positive and negative values
        # ax.set_yticks([-1, -0.5, 0, 0.5, 1])
        
        # Set tight layout to adjust spacing automatically
        plt.tight_layout()
        # Create a FigureCanvas for the Matplotlib plot
        canvas = FigureCanvas(fig)

        # Create a QGraphicsScene to hold the Matplotlib plot
        scene = QGraphicsScene(self)
        scene.addWidget(canvas)

        # Set the QGraphicsScene to the graphicsView1 widget in your plugin
        self.spiGraphView.setScene(scene)

        # Show the Matplotlib plot
        fig.canvas.draw()  # Draw the plot    
        

            
        # Sample data for the DataFrame
        data = {
            'Category': ['A', 'B', 'C', 'D', 'E'],
            'Value': [10, 20, 15, 25, 30]
        }

        # Create the DataFrame
        df = pd.DataFrame(data)
        
        # Define colors for each category based on their values
        colors = np.where(df['Value'] > 20, 'green', 'blue')  # Change the condition and colors as needed
        
        
        #figsize=(254/100, 189/100)
        # Create a Matplotlib figure and subplots
        fig, ax = plt.subplots(figsize=(378/100, 178/100))

        # Plot the DataFrame as a bar graph
        ax.bar(ndvi_names,ndvi_values, width=0.5,color = 'cyan', edgecolor = 'darkblue')

        # Customize the plot if needed
        ax.set_xlabel('date',fontsize=8)
        ax.set_ylabel('NDVI',fontsize=8)
        ax.set_title('NDVI Values',fontsize=8)
        ax.tick_params(axis='both', which='major', labelsize=8)
        ax.tick_params(axis='x', rotation=60,)
        plt.tight_layout()
        # Create a FigureCanvas for the Matplotlib plot
        canvas = FigureCanvas(fig)

        # Create a QGraphicsScene to hold the Matplotlib plot
        scene = QGraphicsScene(self)
        
        scene.addWidget(canvas)

        # Set the QGraphicsScene to the graphics view widget in your plugin
        self.ndviGraphView.setScene(scene)
        
        
        
        # Show the Matplotlib plot
        fig.canvas.draw()   # Draw the plot
        
        # Update progress bar value
        self.progressBar.setValue(100)

    
    def getDroundIndexChart(self):
                
        start_year = int( self.startDate.currentText())
        end_year = int(self.endDate.currentText())
        season = str(self.season.value())
        print(season) 
        
        if season=='1':
            startmonth = 1
            endmonth = 3
        elif season == '2':
            startmonth = 4
            endmonth = 6
        elif season =='3':
            startmonth =7
            endmonth = 9
        elif season == '4':
            startmonth = 10
            endmonth = 12
        else:
            print(" no season lioke that exists ")

        # Check if the required plugin is enabled
        plugin_status  = self.isPluginEnabled('ee_plugin')
        if plugin_status != True:
            # Plugin is not enabled, show an error message and return
            QtWidgets.QMessageBox.warning(self, "Plugin Error", "The required plugin is not enabled.\n please install the Google Earth Engine plugin and try again")
            return
        
        import ee 
        
        def maskL5(col):
            # Bits 3 and 5 are cloud shadow and cloud, respectively.
            cloudShadowBitMask = (1 << 3)
            cloudsBitMask = (1 << 5)

            # Get the pixel QA band.
            qa = col.select('QA_PIXEL')

            # Both flags should be set to zero, indicating clear conditions.
            mask = qa.bitwiseAnd(cloudShadowBitMask).eq(0) \
            .And(qa.bitwiseAnd(cloudsBitMask).eq(0))

            return col.updateMask(mask)

        xLeft = self.sbXmax.value()
        xmax = xLeft

        ymax = self.sbYmax.value()
        ymin = self.sbYmin.value()
        

        xmax_right = self.sbXmaxr.value()
        xLeft_right = xmax_right

        ymax_right = ymax
        ymin_right = ymin

        # ROI1=ee.FeatureCollection('users/muthamijohn/kwanza_constituency')
        
        current_shp_index = self.cbTocLayers.currentIndex()
        current_shp_name = self.cbTocLayers.currentText()
        current_shp_obj= QgsProject.instance().mapLayersByName(str(current_shp_name))
        
        print(current_shp_index) 
        if xmax and ymax and xmax_right and ymax_right and xLeft_right and ymin_right and xLeft and ymin:
            ROI1=ee.Geometry.Polygon([[xmax,ymax],[xmax_right,ymax_right],[xLeft_right,ymin_right],[xLeft,ymin]])
                      
        elif self.cbTocROI.isChecked():
             # image = None
            current_shp = self.cbTocLayers.currentText()
            current_shp= QgsProject.instance().mapLayersByName(str(current_shp))
            print(current_shp)
            layer_path = current_shp[0].source()      
            if layer_path:            
                df = gpd.read_file(layer_path)
                print(df)
                
                curent_shp_json = df.to_json()
                curent_shp_json = json.loads(curent_shp_json)
                # print(curent_shp_json)
                geo_json_data = curent_shp_json
                
                print("GEOJSON:", geo_json_data)
                geojson_data= geo_json_data
                coordinates = self.getGoJSONCoordinates(geojson_data)
                ROI1 = ee.Geometry.Polygon(coordinates)
            
        elif self.cbGeoJsonROI.isChecked():
            json_data = gpd.read_file(self.LegeojsonPath.filePath())
            curent_json = json_data
            curent_geo_json = json.loads(curent_json)
            coordinates = self.getGoJSONCoordinates(curent_geo_json)
            ROI1 = ee.Geometry.Polygon(coordinates)
        else:
            QtWidgets.QMessageBox.warning(self, "Region of interest Error", "Region of Interest Required \n ensure all parameters are correct")   
        
        geometry = ROI1        
        
        self.pbDroughtIndex.setValue(10)
        landstcollection = ee.ImageCollection("LANDSAT/LE07/C02/T1") \
        .map(maskL5)\
        .filterBounds(geometry)\
        .filter(ee.Filter.calendarRange(start_year, end_year, 'year')) \
        .filter(ee.Filter.calendarRange(startmonth,endmonth, 'month'))
        
        self.pbDroughtIndex.setValue(20)


        def compute_veg_indices(start_date, end_date):

                def calculate_drought_index(geometry, start_date, end_date):
                    # Cloud mask
                    # Cloud mask
                        def maskL5(col):
                                # Bits 3 and 5 are cloud shadow and cloud, respectively.
                                cloudShadowBitMask = (1 << 3)
                                cloudsBitMask = (1 << 5)

                                # Get the pixel QA band.
                                qa = col.select('QA_PIXEL')

                                # Both flags should be set to zero, indicating clear conditions.
                                mask = qa.bitwiseAnd(cloudShadowBitMask).eq(0) \
                                .And(qa.bitwiseAnd(cloudsBitMask).eq(0))

                                return col.updateMask(mask)

                        # Load the collection
                        col = ee.ImageCollection("LANDSAT/LE07/C02/T1") \
                                .filterDate(start_date, end_date) \
                                .filterBounds(geometry)

                        col1 = col.mean().clip(geometry)

                        # Image reduction
                        image = col.mean()

                        # Calculate TOA spectral radiance
                        ML = 0.055375
                        AL = 1.18243
                        TOA_radiance = image.expression('ML * B6 + AL', {
                                'ML': ML,
                                'AL': AL,
                                'B6': image.select('B6_VCID_1')
                        })

                        # Convert TOA spectral radiance to brightness temperature
                        K1 = 607.76
                        K2 = 1260.56
                        brightnessTemp = TOA_radiance.expression(
                                '(K2 / (log((K1 / L) + 1))) - 273.15', {
                                'K1': K1,
                                'K2': K2,
                                'L': TOA_radiance
                                })


                        clippedbrightnessTemp = brightnessTemp.clip(geometry)

                        # Median
                        ndvi = image.normalizedDifference(['B4', 'B3']).rename('NDVI')
                        NDVI_IMAGE = ndvi.clip(geometry)

                        # Find the min and max of NDVI
                        min_val = NDVI_IMAGE.reduceRegion(ee.Reducer.min(), geometry, 30, maxPixels=1e9).get('NDVI')
                        max_val = NDVI_IMAGE.reduceRegion(ee.Reducer.max(), geometry, 30, maxPixels=1e9).get('NDVI')
                        min_value = ee.Number(min_val)
                        max_value = ee.Number(max_val)

                        # Fractional vegetation
                        fv = NDVI_IMAGE.subtract(min_value).divide(max_value.subtract(min_value)).pow(2).rename('FV')
                        VCI = (NDVI_IMAGE.subtract(min_value)).divide(max_value.subtract(min_value))

                        # Emissivity
                        a = ee.Number(0.004)
                        b = ee.Number(0.986)
                        EM = fv.multiply(a).add(b).rename('EMM')

                        # Calculate land surface temperature
                        landSurfaceTemp = clippedbrightnessTemp.expression(
                                '(BT / (1 + (10.60 * BT / 14388) * log(epsilon)))', {
                                'BT': clippedbrightnessTemp,
                                'epsilon': EM.select('EMM')
                                })

                        # Clip the land surface temperature image to the geometry
                        clippedLandSurfaceTemp = landSurfaceTemp.clip(geometry)

                        # Find the min and max of LST
                        min_v = clippedLandSurfaceTemp.reduceRegion(ee.Reducer.min(), geometry, 30, maxPixels=1e9).values().get(0)
                        max_v = clippedLandSurfaceTemp.reduceRegion(ee.Reducer.max(), geometry, 30, maxPixels=1e9).values().get(0)
                        min_LST = ee.Number(min_v)
                        max_LST = ee.Number(max_v)

                        max_LST_1 = ee.Image(max_LST)
                        #Obtain TCI
                        TCI = max_LST_1.subtract(clippedLandSurfaceTemp).divide(max_LST.subtract(min_LST))

                        #Calculate VCI
                        VHI = (VCI.multiply(0.5)).add(TCI.multiply(0.5))

                        # VHI classification into classes based on threshold values to calculate Drought Index
                        image02 = VHI.lt(0.1).And(VHI.gte(-1))
                        image04 = ((VHI.gte(0.1)).And(VHI.lt(0.2))).multiply(2)
                        image06 = ((VHI.gte(0.2)).And(VHI.lt(0.3))).multiply(3)
                        image08 = ((VHI.gte(0.3)).And(VHI.lt(0.4))).multiply(4)
                        image10 = (VHI.gte(0.4)).multiply(5)
                        Drought_Index = (image02.add(image04).add(image06).add(image08).add(image10)).float()

                        return Drought_Index, TCI, VCI, VHI


                Drought_Index, TCI, VCI, VHI = calculate_drought_index(geometry, start_date, end_date)

                # imageVHI =ee.ImageCollection("LANDSAT/LC08/C02/T1_L2").filterDate(date,date).filterBounds(geometry).map(maskL8sr).median().clip(geometry)
                # VHI,VCI,TCI = vh.getVHI(imageVHI,'SR_B5','SR_B4',geometry,lst)
                VHI_mean = VHI.reduceRegion(ee.Reducer.mean(), geometry, 30, maxPixels=1e9)
                VHI_mean = ee.Number(VHI_mean.get('NDVI')).float().getInfo()
                TCI_mean = TCI.reduceRegion(ee.Reducer.mean(), geometry, 30, maxPixels=1e9)
                TCI_mean = ee.Number(TCI_mean.get('constant')).float().getInfo()
                VCI_mean = VCI.reduceRegion(ee.Reducer.mean(), geometry, 30, maxPixels=1e9)
                VCI_mean = ee.Number(VCI_mean.get('NDVI')).float().getInfo()
                Drought_Index_mean = Drought_Index.reduceRegion(ee.Reducer.mean(), geometry, 30, maxPixels=1e9)
                Drought_Index_mean = ee.Number(Drought_Index_mean.get('NDVI')).float().getInfo()


                return {'start_date': start_date, 'end_date': end_date, 'VHI_mean': VHI_mean, 'Drought_index_mean': Drought_Index_mean, 'TCI_mean': TCI_mean, 'VCI_mean': VCI_mean}


            
        dates = ee.List(landstcollection.distinct('system:time_start').aggregate_array('system:time_start')).map(
            lambda time_start: ee.Date(time_start).format('YYYY-MM-dd')).getInfo()
        self.pbDroughtIndex.setValue(40)
        # Retrieve the first sequence of dates
        first_sequence = []
        current_sequence = []

        for i, date in enumerate(dates):
            if i == 0 or int(date.split('-')[0]) >= int(dates[i-1].split('-')[0]):
                current_sequence.append(date)
            else:
                break

        first_sequence = current_sequence



        # First, convert the date strings in the first_sequence list to datetime objects
        from datetime import datetime, timedelta

        date_format = "%Y-%m-%d"
        first_sequence = [datetime.strptime(date_str, date_format) for date_str in first_sequence]

        # Create date pairs by picking each date as the start date and adding 16 days to obtain the end date
        date_pairs = []
        for i in range(len(first_sequence)):
            start_date = first_sequence[i]
            end_date = start_date + timedelta(days=16)
            date_pairs.append((start_date.strftime(date_format), end_date.strftime(date_format)))


        self.pbDroughtIndex.setValue(60)
        # Perform computations for each date pair and store the results in a list
        data = []

        with concurrent.futures.ThreadPoolExecutor() as executor:
            # Submit tasks for each year
            futures = [executor.submit(compute_veg_indices, start_date, end_date) for start_date, end_date in date_pairs]

            # Retrieve results
            results = [future.result() for future in futures]
            data = results 
            
        self.pbDroughtIndex.setValue(90)
        # Convert the list of dictionaries to a pandas DataFrame and set 'start_date' and 'end_date' as the MultiIndex
        df= pd.DataFrame(data).set_index(['start_date', 'end_date'])





        # Step 1: Initialize an empty DataFrame to store the standardized values
        standardized_df = pd.DataFrame()

        # Step 2: Loop through each season and calculate the mean and standard deviation
        for season in df.index.get_level_values('start_date').str[:2].unique():
            seasonal_data = df.loc[df.index.get_level_values('start_date').str[:2] == season]
            min_of_season = seasonal_data['Drought_index_mean'].min()
            max_of_season = seasonal_data['Drought_index_mean'].max()
            range_of_season = max_of_season - min_of_season

            # Step 3: Compute the standardized values for the 'Drought_index_mean' column
            standardized_values = (seasonal_data['Drought_index_mean'] - min_of_season) / range_of_season * 2 - 1

            # Step 4: Assign the standardized values to the 'Standardized_Drought_Index' column
            seasonal_data['Standardized_Drought_Index'] = standardized_values

            # Append the seasonal data to the empty DataFrame
            standardized_df = pd.concat([standardized_df, seasonal_data])

        pd.set_option('display.max_columns', None)
        pd.set_option('display.max_rows', None)


        #...............Mean of the standardized drought index values for each month.................#

        # Reset the MultiIndex to make 'end_date' and 'start_date' regular columns
        standardized_df.reset_index(inplace=True)

        # Drop the 'end_date' column
        standardized_df.drop('end_date', axis=1, inplace=True)

        # Convert 'start_date' to the desired format '2019-07'
        standardized_df['start_date'] = pd.to_datetime(standardized_df['start_date']).dt.strftime('%Y-%m')

        # Group by 'start_date' and compute mean for all columns
        standardized_df= standardized_df.groupby('start_date').mean().reset_index()



        #......................Mean of the indeces values for each month..............................#
        df1 = df
        # Reset the MultiIndex to make 'end_date' and 'start_date' regular columns
        df1.reset_index(inplace=True)

        # Drop the 'end_date' column
        df1.drop('end_date', axis=1, inplace=True)

        # Convert 'start_date' to the desired format '2019-07'
        df1['start_date'] = pd.to_datetime(df1['start_date']).dt.strftime('%Y-%m')

        # Group by 'start_date' and compute mean for all columns
        df1= df1.groupby('start_date').mean().reset_index()
        
        print(df1)
        self.pbDroughtIndex.setValue(100)
