# -*- coding: utf-8 -*-
"""
/***************************************************************************
 droughtIndexerDialog
                                 A QGIS plugin
 A plugin to Process Standardized Agricultural Drought Index.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-03-03
        git sha              : $Format:%H$
        copyright            : (C) 2024 by John Ngugi
        email                : johnngugi0407@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.utils import active_plugins
from qgis.core import QgsProject
from qgis.core import QgsMapLayerType
from qgis.core import QgsWkbTypes

import geopandas as gpd 
import json 

 
# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'drought_indexer_dialog_base.ui'))


class droughtIndexerDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(droughtIndexerDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
        self.okBtn.accepted.connect(self.showValue)
        # Fetch the currently loaded layers
        layers = QgsProject.instance().layerTreeRoot().children()

        #filter the layers in the TOC by type of Layer and geometry
        vector_layers = []
        for layer in QgsProject.instance().mapLayers().values(): 
             if layer.type() == QgsMapLayerType.VectorLayer:
                  
                if layer.geometryType() == QgsWkbTypes.PolygonGeometry:  
                   vector_layers.append(layer) 

        # Clear the contents of the comboBox from previous runs
        self.cbTocLayers.clear()
        
        # Populate the comboBox with names of all the loaded layers
        self.cbTocLayers.addItems([layer.name() for layer in vector_layers])
        
        # Connect cancel button to close slot
        self.okBtn.rejected.connect(self.cancelAction)
        
    def cancelAction(self):
        # Define the action to perform when the cancel button is clicked
        self.close()  # Close the dialog    
   
    def getGoJSONCoordinates(self,geojson_data):
            # Check the structure of the GeoJSON data
            if 'features' in geojson_data and len(geojson_data['features']) > 0:
                feature = geojson_data['features'][0]  # Assuming the first feature
                if 'geometry' in feature:
                    geometry = feature['geometry']
                    if 'coordinates' in geometry:
                        coordinates = geometry['coordinates']
                        print("coordinates are", coordinates)
                    else:
                        print("No coordinates found in the geometry")
                else:
                    print("No geometry found in the feature")
            else:
                print("No features found in the GeoJSON data")
            
            return coordinates
        
    def isPluginEnabled(self,plugin_name):
            plugins = active_plugins
            plugin_status = None
            # Check if the plugin is enabled
            if plugin_name in plugins:
                plugin_status = True
            else: 
                plugin_status = False    
            
            return plugin_status

    def showValue(self):
        
        # image = None
        current_shp = self.cbTocLayers.currentText()
        current_shp= QgsProject.instance().mapLayersByName(str(current_shp))
        print(current_shp)
        layer_path = current_shp[0].source()
        
        df = gpd.read_file(layer_path)
        print(df)
        
        curent_shp_json = df.to_json()
        print(curent_shp_json)

        # Check if the required plugin is enabled
        plugin_status  = self.isPluginEnabled('ee_plugin')
        if plugin_status != True:
            # Plugin is not enabled, show an error message and return
            QtWidgets.QMessageBox.warning(self, "Plugin Error", "The required plugin is not enabled.\n please install the Google Earth Engine plugin and try again")
            return
        
        import ee 
        from ee_plugin import Map

        xLeft = self.sbXmax.value()
        xmax = xLeft

        ymax = self.sbYmax.value()
        ymin = self.sbYmin.value()
        

        xmax_right = self.sbXmaxr.value()
        xLeft_right = xmax_right

        ymax_right = ymax
        ymin_right = ymin

        ROI1=ee.FeatureCollection('users/muthamijohn/kwanza_constituency')

        if xmax and ymax and xmax_right and ymax_right and xLeft_right and ymin_right and xLeft and ymin:
            ROI1=ee.Geometry.Polygon([[xmax,ymax],[xmax_right,ymax_right],[xLeft_right,ymin_right],[xLeft,ymin],])
            
        elif self.cbTocROI.isChecked():
            current_shp_index = self.cbTocLayers.currentIndex()
            print(current_shp_index)
            current_shp_name = self.cbTocLayers.currentText()
            current_shp_obj= QgsProject.instance().mapLayersByName(str(current_shp_name))
            print(current_shp_obj)
            layer_path = current_shp_obj[0].source()
            
            df = gpd.read_file(layer_path)
            print(df)
            
            curent_shp_json = df.to_json()
            curent_shp_json = json.loads(curent_shp_json)
            # print(curent_shp_json)
            geo_json_data = curent_shp_json
            
            print("GEOJSON:", geo_json_data)
            geojson_data= geo_json_data
            coordinates = self.getGoJSONCoordinates(geojson_data)
            ROI1 = ee.Geometry.Polygon(coordinates)
            
        elif self.cbGeoJsonROI.isChecked():
            json_data = gpd.read_file(self.LegeojsonPath.filePath())
            curent_json = json_data
            curent_geo_json = json.loads(curent_json)
            coordinates = self.getGoJSONCoordinates(curent_geo_json)
            ROI1 = ee.Geometry.Polygon(coordinates)
            
            
         # Update progress bar value
        self.progressBar.setValue(10)
        Map.centerObject(ROI1, 12)
        start_year = int( self.startDate.currentText())
        end_year = int(self.endDate.currentText())
        season = str(self.season.value())
        print(season)
        
        geometry = ROI1
        if season=='1':
            startmonth = 1
            endmonth = 3
        elif season == '2':
            startmonth = 4
            endmonth = 6
        elif season =='3':
            startmonth =7
            endmonth = 9
        elif season == '4':
            startmonth = 10
            endmonth = 12
        else:
            print(" no season lioke that exists ")

        images = []

        def calculate_drought_index(start_year, end_year,startmonth,endmonth):
            
                # Cloud mask
            # Cloud mask
                def maskL5(col):
                        # Bits 3 and 5 are cloud shadow and cloud, respectively.
                        cloudShadowBitMask = (1 << 3)
                        cloudsBitMask = (1 << 5)

                        # Get the pixel QA band.
                        qa = col.select('QA_PIXEL')

                        # Both flags should be set to zero, indicating clear conditions.
                        mask = qa.bitwiseAnd(cloudShadowBitMask).eq(0) \
                        .And(qa.bitwiseAnd(cloudsBitMask).eq(0))

                        return col.updateMask(mask)

                # Load the collection
                col = ee.ImageCollection("LANDSAT/LE07/C02/T1") \
                        .map(maskL5) \
                        .filter(ee.Filter.calendarRange(start_year, end_year, 'year')) \
                        .filter(ee.Filter.calendarRange(startmonth,endmonth, 'month'))\
                        .filterBounds(geometry)

                col_image = col.mean().clip(geometry)
                # Image reduction
                image = col.mean().clip(geometry)
                # Update progress bar value
                self.progressBar.setValue(25)

                # Calculate TOA spectral radiance
                ML = 0.055375
                AL = 1.18243
                TOA_radiance = image.expression('ML * B6 + AL', {
                        'ML': ML,
                        'AL': AL,
                        'B6': image.select('B6_VCID_1')
                })

                # Convert TOA spectral radiance to brightness temperature
                K1 = 607.76
                K2 = 1260.56
                brightnessTemp = TOA_radiance.expression(
                        '(K2 / (log((K1 / L) + 1))) - 273.15', {
                        'K1': K1,
                        'K2': K2,
                        'L': TOA_radiance
                        })


                brightnessTemp = brightnessTemp.clip(geometry)

                # Median
                ndvi = image.normalizedDifference(['B4', 'B3']).rename('NDVI')
                ndvi = ndvi.clip(geometry)

                # Find the min and max of NDVI
                min_val = ndvi.reduceRegion(ee.Reducer.min(), geometry, 30, maxPixels=1e9).get('NDVI')
                max_val = ndvi.reduceRegion(ee.Reducer.max(), geometry, 30, maxPixels=1e9).get('NDVI')
                min_value = ee.Number(min_val)
                max_value = ee.Number(max_val)

                # Fractional vegetation
                fv = ndvi.subtract(min_value).divide(max_value.subtract(min_value)).pow(2).rename('FV')
                VCI = (ndvi.subtract(min_value)).divide(max_value.subtract(min_value))

                # Emissivity
                a = ee.Number(0.004)
                b = ee.Number(0.986)
                EM = fv.multiply(a).add(b).rename('EMM')

                # Calculate land surface temperature
                landSurfaceTemp = brightnessTemp.expression(
                        '(BT / (1 + (10.60 * BT / 14388) * log(epsilon)))', {
                        'BT': brightnessTemp,
                        'epsilon': EM.select('EMM')
                        })

                # Clip the land surface temperature image to the geometry
                clippedLandSurfaceTemp = landSurfaceTemp.clip(geometry)
                
                # Update progress bar value
                self.progressBar.setValue(50)
                
                # Find the min and max of LST
                min_v = clippedLandSurfaceTemp.reduceRegion(ee.Reducer.min(), geometry, 30, maxPixels=1e9).values().get(0)
                max_v = clippedLandSurfaceTemp.reduceRegion(ee.Reducer.max(), geometry, 30, maxPixels=1e9).values().get(0)
                min_LST = ee.Number(min_v)
                max_LST = ee.Number(max_v)

                max_LST_1 = ee.Image(max_LST)
                #Obtain TCI
                TCI = max_LST_1.subtract(clippedLandSurfaceTemp).divide(max_LST.subtract(min_LST))

                #Calculate VCI
                VHI = (VCI.multiply(0.5)).add(TCI.multiply(0.5))

                # VHI classification into classes based on threshold values to calculate Drought Index
                image02 = VHI.lt(0.1).And(VHI.gte(-1))
                image04 = ((VHI.gte(0.1)).And(VHI.lt(0.2))).multiply(2)
                image06 = ((VHI.gte(0.2)).And(VHI.lt(0.3))).multiply(3)
                image08 = ((VHI.gte(0.3)).And(VHI.lt(0.4))).multiply(4)
                image10 = (VHI.gte(0.4)).multiply(5)
                Drought_Index = (image02.add(image04).add(image06).add(image08).add(image10))

                Drought_index_sd_image = Drought_Index.expression('(2*((Drought_Index - min_DI)/(max_DI - min_DI)) -1)',{
                    'Drought_Index': Drought_Index,
                    'min_DI' : ee.Number(Drought_Index.reduceRegion(ee.Reducer.min(), geometry, 30, maxPixels=1e9).values().get(0)),
                    'max_DI' :ee.Number(Drought_Index.reduceRegion(ee.Reducer.max(), geometry, 30, maxPixels=1e9).values().get(0)),

                })



                images.append(Drought_index_sd_image)
                # images.append(Drought_Index)
                images.append(ndvi)
                images.append(col_image)

                # Update progress bar value
                self.progressBar.setValue(75)
                return images
        
        calculate_drought_index(start_year, end_year,startmonth,endmonth)    

       # add the SADI image to map object
        Map.addLayer(images[0],{'min':-1,'max':1,'palette':['#ec0000','#ecca00','#ec9b00','#ec5300','#ec2400']},'Drought index standardized image')
    
        # # get the Satellite Imagery into the map Object
        
        Map.addLayer(images[2].select('B3','B2','B1'),{'min':3,'max':200, },'Landsat satellite image')
       

        # Get NDVI
        ndvi = images[1]
        indecesVis = {'min': -1 ,"max": 1, 'palette': ['red','yellow','green']}
        Map.addLayer(ndvi,indecesVis,"NDVI")
        # Update progress bar value
        self.progressBar.setValue(100)



    

        
